package at.petrak.hexcasting.common.command;

import at.petrak.hexcasting.api.PatternRegistry;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import var;

public class PatternResLocArgument extends class_2232 {
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_PATTERN = new DynamicCommandExceptionType(
        (errorer) ->
            new class_2588("hexcasting.pattern.unknown", errorer)
    );

    public static PatternResLocArgument method_9441() {
        return new PatternResLocArgument();
    }

    @Override
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return class_2172.method_9264(PatternRegistry.getAllPerWorldPatternNames().stream().map(Object::toString), builder);
    }

    public static HexPattern getPattern(
        CommandContext<class_2168> ctx, String pName) throws CommandSyntaxException {
        var targetId = ctx.getArgument(pName, class_2960.class);
        var lookup = PatternRegistry.getPerWorldPatterns(ctx.getSource().method_9225());
        HexPattern foundPat = null;
        for (var key : lookup.keySet()) {
            var rhs = lookup.get(key);
            if (rhs.getFirst().equals(targetId)) {
                foundPat = HexPattern.fromAngles(key, rhs.getSecond());
                break;
            }
        }

        if (foundPat == null) {
            throw ERROR_UNKNOWN_PATTERN.create(targetId);
        } else {
            return foundPat;
        }
    }
}
