package at.petrak.hexcasting.common.command;

import at.petrak.hexcasting.api.PatternRegistry;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.common.items.ItemScroll;
import at.petrak.hexcasting.common.lib.HexItems;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2232;
import net.minecraft.class_2487;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import var;

public class ListPatternsCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(class_2170.method_9247("hexcasting:patterns")
            .requires(dp -> dp.method_9259(class_2170.field_31840))
            .then(class_2170.method_9247("list").executes(ctx -> {

                var lookup = PatternRegistry.getPerWorldPatterns(ctx.getSource().method_9225());
                var listing = lookup.entrySet()
                    .stream()
                    .sorted((a, b) -> compareResLoc(a.getValue().getFirst(), b.getValue().getFirst()))
                    .toList();

                ctx.getSource().method_9226(new class_2588("command.hexcasting.pats.listing"), false);
                for (var pair : listing) {
                    ctx.getSource().method_9226(new class_2585(pair.getValue().getFirst().toString())
                        .method_27693(": ")
                        .method_27693(SpellDatum.make(HexPattern.fromAngles(pair.getKey(), pair.getValue().getSecond()))
                            .display()), false);
                }


                return lookup.size();
            }))
            .then(class_2170.method_9247("give")
                .then(class_2170.method_9244("patternName", PatternResLocArgument.method_9441()).executes(ctx -> {
                        var sender = ctx.getSource().method_9228();
                        if (sender instanceof class_3222 player) {
                            var targetId = class_2232.method_9443(ctx, "patternName");
                            var pat = PatternResLocArgument.getPattern(ctx, "patternName");


                            var tag = new class_2487();
                            tag.putString(ItemScroll.TAG_OP_ID, targetId.toString());
                            tag.put(ItemScroll.TAG_PATTERN,
                                pat.serializeToNBT());

                            var stack = new class_1799(HexItems.SCROLL);
                            stack.setTag(tag);

                            ctx.getSource().method_9226(
                                new class_2588(
                                    "command.hexcasting.pats.specific.success",
                                    stack.getDisplayName(),
                                    targetId),
                                true);

                            var stackEntity = player.method_7328(stack, false);
                            if (stackEntity != null) {
                                stackEntity.setNoPickUpDelay();
                                stackEntity.setOwner(player.method_5667());
                            }

                            return 1;
                        } else {
                            return 0;
                        }
                    }
                )))
            .then(class_2170.method_9247("giveAll").executes(ctx -> {
                var sender = ctx.getSource().method_9228();
                if (sender instanceof class_3222 player) {
                    var lookup = PatternRegistry.getPerWorldPatterns(ctx.getSource().method_9225());

                    lookup.forEach((pattern, entry) -> {
                        var opId = entry.component1();
                        var startDir = entry.component2();

                        var tag = new CompoundTag();
                        tag.putString(ItemScroll.TAG_OP_ID, opId.toString());
                        tag.put(ItemScroll.TAG_PATTERN,
                            HexPattern.fromAngles(pattern, startDir).serializeToNBT());

                        var stack = new ItemStack(HexItems.SCROLL);
                        stack.setTag(tag);

                        var stackEntity = player.drop(stack, false);
                        if (stackEntity != null) {
                            stackEntity.setNoPickUpDelay();
                            stackEntity.setOwner(player.getUUID());
                        }
                    });

                    ctx.getSource().method_9226(
                        new class_2588("command.hexcasting.pats.all", lookup.size()), true);
                    return lookup.size();
                } else {
                    return 0;
                }
            }))
        );
    }

    private static int compareResLoc(class_2960 a, class_2960 b) {
        var ns = a.method_12836().compareTo(b.method_12836());
        if (ns != 0) {
            return ns;
        }
        return a.method_12832().compareTo(b.method_12832());
    }
}
