package at.petrak.hexcasting.common.blocks.entity;

import at.petrak.hexcasting.api.block.circle.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.lib.HexBlockEntities;
import com.mojang.datafixers.util.Pair;
import org.jetbrains.annotations.Nullable;
import var;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class BlockEntityStoredPlayerImpetus extends BlockEntityAbstractImpetus {
    public static final String TAG_STORED_PLAYER = "stored_player";

    private UUID storedPlayer = null;

    public BlockEntityStoredPlayerImpetus(class_2338 pWorldPosition, class_2680 pBlockState) {
        super(HexBlockEntities.IMPETUS_STOREDPLAYER_TILE, pWorldPosition, pBlockState);
    }

    @Override
    public boolean activatorAlwaysInRange() {
        return true;
    }

    @Override
    protected @Nullable
    class_1657 getPlayer() {
        return this.storedPlayer == null ? null : this.field_11863.method_18470(this.storedPlayer);
    }

    public void setPlayer(UUID player) {
        this.storedPlayer = player;
        this.method_5431();
    }

    // just feels wrong to use the protected method
    public @Nullable
    class_1657 getStoredPlayer() {
        return this.getPlayer();
    }

    public void applyScryingLensOverlay(List<Pair<class_1799, class_2561>> lines,
        class_2680 state, class_2338 pos, class_746 observer,
        class_638 world,
        class_2350 hitFace, class_1268 lensHand) {
        super.applyScryingLensOverlay(lines, state, pos, observer, world, hitFace, lensHand);

        var bound = this.getPlayer();
        if (bound != null) {
            String name = bound.getScoreboardName();
            var head = new class_1799(class_1802.field_8575);
            NBTHelper.putString(head, "SkullOwner", name);
            lines.add(
                new Pair<>(head, new class_2588("hexcasting.tooltip.lens.impetus.storedplayer", name)));
        } else {
            lines.add(new Pair<>(new class_1799(class_1802.field_8077),
                new class_2588("hexcasting.tooltip.lens.impetus.storedplayer.none")));
        }
    }

    @Override
    protected void saveModData(class_2487 tag) {
        super.saveModData(tag);
        if (this.storedPlayer != null) {
            tag.method_25927(TAG_STORED_PLAYER, this.storedPlayer);
        }
    }

    @Override
    protected void loadModData(class_2487 tag) {
        super.loadModData(tag);
        if (tag.method_10573(TAG_STORED_PLAYER, class_2520.field_33261)) {
            this.storedPlayer = tag.method_25926(TAG_STORED_PLAYER);
        } else {
            this.storedPlayer = null;
        }
    }
}
