package at.petrak.hexcasting.common.blocks.entity;

import at.petrak.hexcasting.api.block.circle.BlockCircleComponent;
import at.petrak.hexcasting.api.block.circle.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.common.lib.HexBlockEntities;
import at.petrak.hexcasting.common.lib.HexSounds;
import net.minecraft.class_1304;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import var;

public class BlockEntityLookingImpetus extends BlockEntityAbstractImpetus {
    public static final int MAX_LOOK_AMOUNT = 30;
    public static final String TAG_LOOK_AMOUNT = "look_amount";

    private int lookAmount = 0;

    public BlockEntityLookingImpetus(class_2338 pWorldPosition, class_2680 pBlockState) {
        super(HexBlockEntities.IMPETUS_LOOK_TILE, pWorldPosition, pBlockState);
    }

    @Override
    public boolean activatorAlwaysInRange() {
        return false;
    }

    // https://github.com/VazkiiMods/Botania/blob/2607bcd31c4eaeb617f7d1b3ec1c1db08f59add4/Common/src/main/java/vazkii/botania/common/block/tile/TileEnderEye.java#L27
    public static void serverTick(class_1937 level, class_2338 pos, class_2680 bs, BlockEntityLookingImpetus self) {
        if (bs.method_11654(BlockCircleComponent.ENERGIZED)) {
            return;
        }

        int prevLookAmt = self.lookAmount;
        int range = 20;
        var players = level.method_18467(class_3222.class,
            new class_238(pos.method_10069(-range, -range, -range), pos.method_10069(range, range, range)));

        class_3222 looker = null;
        for (var player : players) {
            // might as well impl this heh
            var hat = player.getItemBySlot(class_1304.field_6169);
            // sadly `isEnderMask` requires the enderman
            if (!hat.isEmpty() && hat.is(class_2246.field_10147.method_8389())) {
                continue;
            }

            var lookEnd = player.getLookAngle().scale(range / 1.5f); // add some slop
            var hit = level.method_17742(new class_3959(
                player.getEyePosition(),
                player.getEyePosition().add(lookEnd),
                class_3959.class_3960.field_23142,
                class_3959.class_242.field_1348,
                player
            ));
            if (hit.getType() == class_239.class_240.field_1332 && hit.getBlockPos().equals(pos)) {
                looker = player;
                break;
            }
        }

        var newLook = class_3532.method_15340(
            prevLookAmt + (looker == null ? -1 : 1),
            0,
            MAX_LOOK_AMOUNT
        );
        if (newLook != prevLookAmt) {
            if (newLook == MAX_LOOK_AMOUNT) {
                self.lookAmount = 0;
                self.activateSpellCircle(looker);
            } else {
                if (newLook % 5 == 1) {
                    var t = (float) newLook / MAX_LOOK_AMOUNT;
                    var pitch = class_3532.method_16439(t, 0.5f, 1.2f);
                    var volume = class_3532.method_16439(t, 0.2f, 1.2f);
                    level.method_8396(null, pos, HexSounds.IMPETUS_LOOK_TICK, class_3419.field_15245, volume, pitch);
                }
                self.lookAmount = newLook;
                self.method_5431();
            }
        }
    }

    @Override
    protected void saveModData(class_2487 tag) {
        super.saveModData(tag);
        tag.method_10569(TAG_LOOK_AMOUNT, this.lookAmount);
    }

    @Override
    protected void loadModData(class_2487 tag) {
        super.loadModData(tag);
        this.lookAmount = tag.method_10550(TAG_LOOK_AMOUNT);
    }
}
