package at.petrak.hexcasting.common.blocks.entity;

import at.petrak.hexcasting.api.block.HexBlockEntity;
import at.petrak.hexcasting.api.misc.FrozenColorizer;
import at.petrak.hexcasting.common.blocks.BlockConjured;
import at.petrak.hexcasting.common.blocks.BlockConjuredLight;
import at.petrak.hexcasting.common.lib.HexBlockEntities;
import at.petrak.hexcasting.common.particles.ConjureParticleOptions;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;

public class BlockEntityConjured extends HexBlockEntity {
    private static final Random RANDOM = new Random();
    private FrozenColorizer colorizer = FrozenColorizer.DEFAULT.get();

    public static final String TAG_COLORIZER = "tag_colorizer";

    public BlockEntityConjured(class_2338 pos, class_2680 state) {
        super(HexBlockEntities.CONJURED_TILE, pos, state);
    }

    public void walkParticle(class_1297 pEntity) {
        if (method_11010().method_26204() instanceof BlockConjured conjured && !(conjured instanceof BlockConjuredLight)) {
            for (int i = 0; i < 3; ++i) {
                int color = this.colorizer.getColor(pEntity.field_6012, pEntity.method_19538()
                    .method_1019(new class_243(RANDOM.nextFloat(), RANDOM.nextFloat(), RANDOM.nextFloat()).method_1021(
                        RANDOM.nextFloat() * 3)));
                assert field_11863 != null;
                field_11863.method_8406(new ConjureParticleOptions(color, false),
                    pEntity.method_23317() + (RANDOM.nextFloat() * 0.6D) - 0.3D,
                    method_11016().method_10264() + (RANDOM.nextFloat() * 0.05D) + 0.95D,
                    pEntity.method_23321() + (RANDOM.nextFloat() * 0.6D) - 0.3D,
                    RANDOM.nextFloat(-0.02f, 0.02f),
                    RANDOM.nextFloat(0.02f),
                    RANDOM.nextFloat(-0.02f, 0.02f));
            }
        }
    }

    public void particleEffect() {
        if (method_11010().method_26204() instanceof BlockConjured) {
            int color = this.colorizer.getColor(RANDOM.nextFloat() * 16384,
                new class_243(RANDOM.nextFloat(), RANDOM.nextFloat(), RANDOM.nextFloat()).method_1021(
                    RANDOM.nextFloat() * 3));
            assert field_11863 != null;
            if (method_11010().method_26204() instanceof BlockConjuredLight) {
                if (RANDOM.nextFloat() < 0.5) {
                    field_11863.method_8406(new ConjureParticleOptions(color, true),
                        (double) method_11016().method_10263() + 0.45D + (RANDOM.nextFloat() * 0.1D),
                        (double) method_11016().method_10264() + 0.45D + (RANDOM.nextFloat() * 0.1D),
                        (double) method_11016().method_10260() + 0.45D + (RANDOM.nextFloat() * 0.1D),
                        RANDOM.nextFloat(-0.005f, 0.005f),
                        RANDOM.nextFloat(-0.002f, 0.02f),
                        RANDOM.nextFloat(-0.005f, 0.005f));
                }
            } else {
                if (RANDOM.nextFloat() < 0.2) {
                    field_11863.method_8406(new ConjureParticleOptions(color, false),
                        (double) method_11016().method_10263() + RANDOM.nextFloat(),
                        (double) method_11016().method_10264() + RANDOM.nextFloat(),
                        (double) method_11016().method_10260() + RANDOM.nextFloat(),
                        RANDOM.nextFloat(-0.02f, 0.02f),
                        RANDOM.nextFloat(-0.02f, 0.02f),
                        RANDOM.nextFloat(-0.02f, 0.02f));
                }
            }
        }
    }

    public void landParticle(class_1297 entity, int number) {
        if (method_11010().method_26204() instanceof BlockConjuredLight) {
            for (int i = 0; i < number * 2; i++) {
                int color = this.colorizer.getColor(entity.field_6012, entity.method_19538()
                    .method_1019(new class_243(RANDOM.nextFloat(), RANDOM.nextFloat(), RANDOM.nextFloat()).method_1021(
                        RANDOM.nextFloat() * 3)));
                assert field_11863 != null;
                field_11863.method_8406(new ConjureParticleOptions(color, false),
                    entity.method_23317() + (RANDOM.nextFloat() * 0.8D) - 0.2D,
                    method_11016().method_10264() + (RANDOM.nextFloat() * 0.05D) + 0.95D,
                    entity.method_23321() + (RANDOM.nextFloat() * 0.8D) - 0.2D,
                    0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void saveModData(class_2487 tag) {
        tag.method_10566(TAG_COLORIZER, this.colorizer.serializeToNBT());
    }

    @Override
    protected void loadModData(class_2487 tag) {
        this.colorizer = FrozenColorizer.fromNBT(tag.method_10562(TAG_COLORIZER));
    }

    public FrozenColorizer getColorizer() {
        return this.colorizer;
    }

    public void setColorizer(FrozenColorizer colorizer) {
        this.colorizer = colorizer;
        this.sync();
    }
}
