package at.petrak.hexcasting.common.blocks.circles.impetuses;

import at.petrak.hexcasting.api.block.circle.BlockAbstractImpetus;
import at.petrak.hexcasting.api.spell.DatumType;
import at.petrak.hexcasting.common.blocks.entity.BlockEntityStoredPlayerImpetus;
import at.petrak.hexcasting.common.lib.HexSounds;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;
import var;

public class BlockStoredPlayerImpetus extends BlockAbstractImpetus {
    public static final class_2746 POWERED = class_2741.field_12484;

    public BlockStoredPlayerImpetus(class_2251 p_49795_) {
        super(p_49795_);
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pPos, class_2680 pState) {
        return new BlockEntityStoredPlayerImpetus(pPos, pState);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(POWERED);
    }

    @Override
    public class_1269 method_9534(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_1657 pPlayer, class_1268 pHand,
        class_3965 pHit) {
        if (pLevel.method_8321(pPos) instanceof BlockEntityStoredPlayerImpetus tile) {
            var usedStack = pPlayer.method_5998(pHand);
            var datumContainer = IXplatAbstractions.INSTANCE.findDataHolder(usedStack);
            if (datumContainer != null) {
                if (pLevel instanceof class_3218 level) {
                    var stored = datumContainer.readDatum(level);
                    if (stored != null && stored.getType() == DatumType.ENTITY) {
                        var entity = (class_1297) stored.getPayload();
                        if (entity instanceof class_1657) {
                            // phew, we got something
                            tile.setPlayer(entity.getUUID());
                            level.method_8413(pPos, pState, pState, class_2248.field_31028);

                            pLevel.method_8396(null, pPos, HexSounds.IMPETUS_STOREDPLAYER_DING, class_3419.field_15245,
                                    1f, 1f);
                        }
                    }
                }
                return class_1269.field_5812;
            }
        }

        return class_1269.field_5811;
    }

    @Override
    public void method_9612(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2248 pBlock, class_2338 pFromPos,
        boolean pIsMoving) {
        super.method_9612(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);

        if (!pLevel.method_8608()) {
            boolean prevPowered = pState.method_11654(POWERED);
            boolean isPowered = pLevel.method_8479(pPos);

            if (prevPowered != isPowered) {
                pLevel.method_8501(pPos, pState.method_11657(POWERED, isPowered));

                if (isPowered && pLevel.method_8321(pPos) instanceof BlockEntityStoredPlayerImpetus tile) {
                    var player = tile.getStoredPlayer();
                    if (player instanceof class_3222 splayer) {
                        // phew
                        tile.activateSpellCircle(splayer);
                    }
                }
            }
        }
    }
}
