package at.petrak.hexcasting.common.blocks.circles.directrix;

import at.petrak.hexcasting.api.block.circle.BlockCircleComponent;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import org.jetbrains.annotations.Nullable;
import var;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.class_1750;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2390;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_3619;

public class BlockRedstoneDirectrix extends BlockCircleComponent {
    public static final class_2753 FACING = class_2741.field_12525;
    public static final class_2746 REDSTONE_POWERED = class_2741.field_12484;

    public BlockRedstoneDirectrix(class_2251 p_49795_) {
        super(p_49795_);
        this.method_9590(this.field_10647.method_11664()
            .method_11657(REDSTONE_POWERED, false)
            .method_11657(ENERGIZED, false)
            .method_11657(FACING, class_2350.field_11043));
    }

    @Override
    public boolean canEnterFromDirection(class_2350 enterDir, class_2350 normalDir, class_2338 pos, class_2680 bs,
        class_1937 world) {
        return enterDir != getRealFacing(bs);
    }

    @Override
    public EnumSet<class_2350> exitDirections(class_2338 pos, class_2680 bs, class_1937 world) {
        return EnumSet.of(getRealFacing(bs));
    }

    @Override
    public @Nullable HexPattern getPattern(class_2338 pos, class_2680 bs, class_1937 world) {
        return null;
    }

    @Override
    public class_2350 normalDir(class_2338 pos, class_2680 bs, class_1937 world, int recursionLeft) {
        return normalDirOfOther(pos.method_10093(getRealFacing(bs)), world, recursionLeft);
    }

    @Override
    public float particleHeight(class_2338 pos, class_2680 bs, class_1937 world) {
        return 0.5f;
    }

    protected class_2350 getRealFacing(class_2680 bs) {
        var facing = bs.method_11654(FACING);
        if (bs.method_11654(REDSTONE_POWERED)) {
            return facing.getOpposite();
        } else {
            return facing;
        }
    }

    @Override
    public void method_9612(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2248 pBlock, class_2338 pFromPos,
        boolean pIsMoving) {
        super.method_9612(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);

        if (!pLevel.field_9236) {
            boolean currentlyPowered = pState.method_11654(REDSTONE_POWERED);
            if (currentlyPowered != pLevel.method_8479(pPos)) {
                pLevel.method_8652(pPos, pState.method_11657(REDSTONE_POWERED, !currentlyPowered), 2);
            }
        }
    }


    @Override
    public void method_9496(class_2680 bs, class_1937 pLevel, class_2338 pos, Random rand) {
        if (bs.method_11654(REDSTONE_POWERED)) {
            for (int i = 0; i < 2; i++) {
                var step = bs.method_11654(FACING).method_10153().method_23955();
                var center = class_243.method_24953(pos).method_1031(step.x() * 0.5, step.y() * 0.5, step.z() * 0.5);
                double x = center.x + (rand.nextDouble() - 0.5) * 0.5D;
                double y = center.y + (rand.nextDouble() - 0.5) * 0.5D;
                double z = center.z + (rand.nextDouble() - 0.5) * 0.5D;
                pLevel.method_8406(class_2390.field_11188, x, y, z,
                    step.x() * 0.1, step.y() * 0.1, step.z() * 0.1);
            }
        }
    }

    @Override
    public class_3619 method_9527(class_2680 pState) {
        return class_3619.field_15972;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(REDSTONE_POWERED, FACING);
    }


    @Override
    public class_2680 method_9605(class_1750 pContext) {
        return this.method_9564().method_11657(FACING, pContext.method_7715());
    }

    @Override
    public class_2680 method_9598(class_2680 pState, class_2470 pRot) {
        return pState.method_11657(FACING, pRot.method_10503(pState.method_11654(FACING)));
    }

    @Override
    public class_2680 method_9569(class_2680 pState, class_2415 pMirror) {
        return pState.method_26186(pMirror.method_10345(pState.method_11654(FACING)));
    }
}
