package at.petrak.hexcasting.common.blocks.circles;

import at.petrak.hexcasting.annotations.SoftImplement;
import at.petrak.hexcasting.api.block.circle.BlockCircleComponent;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.common.lib.HexItems;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.world.level.block.state.properties.*;
import org.jetbrains.annotations.Nullable;
import var;
import javax.annotation.Nonnull;
import java.util.EnumSet;

// When on the floor or ceiling FACING is the direction the *bottom* of the pattern points
// (or which way is "down").
// When on the wall FACING is the direction of the *front* of the block
public class BlockSlate extends BlockCircleComponent implements class_2343, class_3737 {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2754<class_2738> ATTACH_FACE = class_2741.field_12555;

    public static final double THICKNESS = 1;
    public static final class_265 AABB_FLOOR = class_2248.method_9541(0, 0, 0, 16, THICKNESS, 16);
    public static final class_265 AABB_CEILING = class_2248.method_9541(0, 16 - THICKNESS, 0, 16, 16, 16);
    public static final class_265 AABB_EAST_WALL = class_2248.method_9541(0, 0, 0, THICKNESS, 16, 16);
    public static final class_265 AABB_WEST_WALL = class_2248.method_9541(16 - THICKNESS, 0, 0, 16, 16, 16);
    public static final class_265 AABB_SOUTH_WALL = class_2248.method_9541(0, 0, 0, 16, 16, THICKNESS);
    public static final class_265 AABB_NORTH_WALL = class_2248.method_9541(0, 0, 16 - THICKNESS, 16, 16, 16);

    public BlockSlate(class_2251 p_53182_) {
        super(p_53182_);
        this.method_9590(
            this.field_10647.method_11664()
                .method_11657(ENERGIZED, false)
                .method_11657(FACING, class_2350.field_11043)
                .method_11657(WATERLOGGED, false));
    }

    @Override
    public boolean method_9579(class_2680 state, @Nonnull class_1922 reader, @Nonnull class_2338 pos) {
        return !state.method_11654(WATERLOGGED);
    }

    @Nonnull
    @Override
    public class_3610 method_9545(class_2680 state) {
        return state.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Override
    public boolean canEnterFromDirection(class_2350 enterDir, class_2350 normalDir, class_2338 pos, class_2680 bs,
        class_1937 world) {
        var thisNormal = this.normalDir(pos, bs, world);
        return enterDir != thisNormal && normalDir == thisNormal;
    }

    @Override
    public EnumSet<class_2350> exitDirections(class_2338 pos, class_2680 bs, class_1937 world) {
        var allDirs = EnumSet.allOf(class_2350.class);
        var normal = this.normalDir(pos, bs, world);
        allDirs.remove(normal);
        allDirs.remove(normal.getOpposite());
        return allDirs;
    }

    @Override
    public @Nullable
    HexPattern getPattern(class_2338 pos, class_2680 bs, class_1937 world) {
        if (world.method_8321(pos) instanceof BlockEntitySlate tile) {
            return tile.pattern;
        } else {
            return null;
        }
    }

    @SoftImplement("forge")
    public class_1799 getCloneItemStack(class_2680 state, class_239 target, class_1922 level, class_2338 pos,
        class_1657 player) {
        class_2586 be = level.method_8321(pos);
        if (be instanceof BlockEntitySlate slate) {
            class_1799 stack = new class_1799(HexItems.SLATE);
            if (slate.pattern != null) {
                HexItems.SLATE.writeDatum(stack, SpellDatum.make(slate.pattern));
            }
            return stack;
        }

        return new class_1799(this);
    }

    @Override
    public class_2350 normalDir(class_2338 pos, class_2680 bs, class_1937 world, int recursionLeft) {
        return switch (bs.getValue(ATTACH_FACE)) {
            case FLOOR -> Direction.UP;
            case CEILING -> Direction.DOWN;
            case WALL -> bs.getValue(FACING);
        };
    }

    @Override
    public float particleHeight(class_2338 pos, class_2680 bs, class_1937 world) {
        return 0.5f - 15f / 16f;
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pPos, class_2680 pState) {
        return new BlockEntitySlate(pPos, pState);
    }

    @Override
    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return switch (pState.getValue(ATTACH_FACE)) {
            case FLOOR -> AABB_FLOOR;
            case CEILING -> AABB_CEILING;
            case WALL -> switch (pState.getValue(FACING)) {
                case NORTH -> AABB_NORTH_WALL;
                case EAST -> AABB_EAST_WALL;
                case SOUTH -> AABB_SOUTH_WALL;
                // NORTH; up and down don't happen (but we need branches for them)
                default -> AABB_WEST_WALL;
            };
        };
    }

    @Override
    public class_3619 method_9527(class_2680 pState) {
        return class_3619.field_15971;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(FACING, ATTACH_FACE, WATERLOGGED);
    }

    @Override
    @Nullable
    public class_2680 method_9605(class_1750 pContext) {
        class_3610 fluidState = pContext.method_8045().method_8316(pContext.method_8037());

        for (class_2350 direction : pContext.method_7718()) {
            class_2680 blockstate;
            if (direction.method_10166() == class_2350.class_2351.field_11052) {
                blockstate = this.method_9564()
                    .method_11657(ATTACH_FACE, direction == class_2350.field_11036 ? class_2738.field_12473 : class_2738.field_12475)
                    .method_11657(FACING, pContext.method_8042().method_10153());
            } else {
                blockstate = this.method_9564()
                    .method_11657(ATTACH_FACE, class_2738.field_12471)
                    .method_11657(FACING, direction.method_10153());
            }
            blockstate = blockstate.method_11657(WATERLOGGED,
                fluidState.method_15767(class_3486.field_15517) && fluidState.method_15761() == 8);

            if (blockstate.method_26184(pContext.method_8045(), pContext.method_8037())) {
                return blockstate;
            }
        }

        return null;
    }

    // i do as the FaceAttachedHorizontalDirectionBlock.java guides
    @Override
    public boolean method_9558(class_2680 pState, class_4538 pLevel, class_2338 pPos) {
        return canAttach(pLevel, pPos, getConnectedDirection(pState).method_10153());
    }

    @Override
    public class_2680 method_9559(class_2680 pState, class_2350 pFacing, class_2680 pFacingState, class_1936 pLevel,
        class_2338 pCurrentPos, class_2338 pFacingPos) {
        if (pState.method_11654(WATERLOGGED)) {
            pLevel.method_39281(pCurrentPos, class_3612.field_15910, class_3612.field_15910.method_15789(pLevel));
        }

        return getConnectedDirection(pState).method_10153() == pFacing
            && !pState.method_26184(pLevel, pCurrentPos) ?
            pState.method_26227().method_15759()
            : super.method_9559(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public static boolean canAttach(class_4538 pReader, class_2338 pPos, class_2350 pDirection) {
        class_2338 blockpos = pPos.method_10093(pDirection);
        return pReader.method_8320(blockpos).method_26206(pReader, blockpos, pDirection.method_10153());
    }

    protected static class_2350 getConnectedDirection(class_2680 pState) {
        return switch (pState.getValue(ATTACH_FACE)) {
            case CEILING -> Direction.DOWN;
            case FLOOR -> Direction.UP;
            default -> pState.getValue(FACING);
        };
    }
}
