package at.petrak.hexcasting.common.blocks.akashic;

import at.petrak.hexcasting.api.block.HexBlockEntity;
import at.petrak.hexcasting.api.spell.DatumType;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.math.HexDir;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.common.lib.HexBlockEntities;
import org.jetbrains.annotations.Nullable;
import record;
import var;
import java.util.*;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class BlockEntityAkashicRecord extends HexBlockEntity {
    public static final String TAG_LOOKUP = "lookup",
        TAG_POS = "pos",
        TAG_DATUM = "datum",
        TAG_DIR = "dir";

    // Hex pattern signatures to pos and iota.
    // Note this is NOT a record of the entire floodfill! Just bookshelves.

    private final Map<String, Entry> entries = new HashMap<>();

    public BlockEntityAkashicRecord(class_2338 pWorldPosition, class_2680 pBlockState) {
        super(HexBlockEntities.AKASHIC_RECORD_TILE, pWorldPosition, pBlockState);
    }

    public void removeFloodfillerAt(class_2338 pos) {
        // lmao just recalc everything
        this.revalidateAllBookshelves();
    }

    /**
     * @return the block position of the place it gets stored, or null if there was no room.
     * <p>
     * Will never clobber anything.
     */
    public @Nullable
    class_2338 addNewDatum(HexPattern key, SpellDatum<?> datum) {
        String entryKey = getKey(key);
        if (this.entries.containsKey(entryKey)) {
            return null; // would clobber
        }

        var openPos = BlockAkashicFloodfiller.floodFillFor(this.field_11867, this.field_11863,
            (pos, bs, world) -> world.method_8321(pos) instanceof BlockEntityAkashicBookshelf tile
                && tile.getPattern() == null);
        if (openPos != null) {
            var tile = (BlockEntityAkashicBookshelf) this.field_11863.method_8321(openPos);
            tile.setNewData(this.method_11016(), key, datum.getType());

            this.entries.put(entryKey, new Entry(openPos, key.getStartDir(), datum.serializeToNBT()));
            this.sync();

            return openPos;
        } else {
            return null;
        }
    }

    private String getKey(HexPattern key) {
        String angles = key.anglesSignature();
        if (angles.isEmpty()) {
            return "empty"; // contains non-angle characters, so can't occur any way other than this
        }
        return angles;
    }

    public @Nullable
    SpellDatum<?> lookupPattern(HexPattern key, class_3218 slevel) {
        var entry = this.entries.get(getKey(key));
        if (entry == null) {
            return null;
        } else {
            return SpellDatum.fromNBT(entry.datum, slevel);
        }
    }

    public class_2561 getDisplayAt(HexPattern key) {
        var entry = this.entries.get(getKey(key));
        if (entry != null) {
            return SpellDatum.displayFromNBT(entry.datum);
        } else {
            return new class_2588("hexcasting.spelldata.akashic.nopos").method_27692(class_124.field_1061);
        }
    }

    public int getCount() {
        return this.entries.size();
    }

    public void revalidateAllBookshelves() {
        // floodfill for all known positions
        var validPoses = new HashSet<class_2338>();
        {
            var seen = new HashSet<class_2338>();
            var todo = new ArrayDeque<class_2338>();
            todo.add(this.field_11867);
            // we do NOT add this position to the valid positions, because the record
            // isn't flood-fillable through.
            while (!todo.isEmpty()) {
                var here = todo.remove();

                for (var dir : class_2350.values()) {
                    var neighbor = here.relative(dir);
                    if (seen.add(neighbor)) {
                        var bs = this.field_11863.method_8320(neighbor);
                        if (BlockAkashicFloodfiller.canItBeFloodedThrough(neighbor, bs, this.field_11863)) {
                            todo.add(neighbor);
                            if (this.field_11863.method_8321(neighbor) instanceof BlockEntityAkashicBookshelf &&
                                bs.hasProperty(BlockAkashicBookshelf.DATUM_TYPE) &&
                                bs.getValue(BlockAkashicBookshelf.DATUM_TYPE) != DatumType.EMPTY) {
                                validPoses.add(neighbor);
                            }
                        }
                    }
                }
            }
        }

        var sigs = new ArrayList<>(this.entries.keySet());
        for (var sig : sigs) {
            var entry = this.entries.get(sig);
            if (!validPoses.contains(entry.pos)) {
                // oh no!
                this.entries.remove(sig);

                if (this.field_11863.method_8321(entry.pos) instanceof BlockEntityAkashicBookshelf shelf) {
                    shelf.setNewData(null, null, DatumType.EMPTY);
                }
            }
        }

        this.sync();
    }


    @Override
    protected void saveModData(class_2487 compoundTag) {
        var lookupTag = new class_2487();
        this.entries.forEach((sig, entry) -> {
            var t = new CompoundTag();
            t.put(TAG_POS, NbtUtils.writeBlockPos(entry.pos));
            t.put(TAG_DATUM, entry.datum);
            t.putByte(TAG_DIR, (byte) entry.startDir.ordinal());
            lookupTag.put(sig, t);
        });
        compoundTag.method_10566(TAG_LOOKUP, lookupTag);
    }

    @Override
    protected void loadModData(class_2487 compoundTag) {
        var lookupTag = compoundTag.method_10562(TAG_LOOKUP);

        this.entries.clear();
        var sigs = lookupTag.getAllKeys();
        for (var sig : sigs) {
            var entryTag = lookupTag.getCompound(sig);
            var pos = class_2512.method_10691(entryTag.getCompound(TAG_POS));
            var dir = HexDir.values()[entryTag.getByte(TAG_DIR)];
            var datum = entryTag.getCompound(TAG_DATUM);
            this.entries.put(sig, new Entry(pos, dir, datum));
        }
    }

    private record Entry(class_2338 pos, HexDir startDir, class_2487 datum) {
    }

}
