package at.petrak.hexcasting.common.blocks.akashic;

import at.petrak.hexcasting.api.block.HexBlockEntity;
import at.petrak.hexcasting.api.spell.DatumType;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.common.lib.HexBlockEntities;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import var;

public class BlockEntityAkashicBookshelf extends HexBlockEntity {
    public static final String TAG_RECORD_POS = "record_pos";
    public static final String TAG_PATTERN = "pattern";

    // This might actually be inaccurate! It's a best-guess
    private class_2338 recordPos = null;
    // This is only not null if this stores any data.
    private HexPattern pattern = null;

    public BlockEntityAkashicBookshelf(class_2338 pWorldPosition, class_2680 pBlockState) {
        super(HexBlockEntities.AKASHIC_BOOKSHELF_TILE, pWorldPosition, pBlockState);
    }

    @Nullable
    public class_2338 getRecordPos() {
        return recordPos;
    }

    @Nullable
    public HexPattern getPattern() {
        return pattern;
    }


    public void setNewData(class_2338 recordPos, HexPattern pattern, DatumType type) {
        this.recordPos = recordPos;
        this.pattern = pattern;

        this.method_5431();

        class_2680 worldBs = this.field_11863.method_8320(this.method_11016());
        var oldBs = this.method_11010();

        if (worldBs.method_26204() == oldBs.getBlock()) {
            var newBs = oldBs.setValue(BlockAkashicBookshelf.DATUM_TYPE, type);
            this.field_11863.method_8652(this.method_11016(), newBs, 3);
            this.field_11863.method_8413(this.method_11016(), oldBs, newBs, 3);
        }
    }

    @Override
    protected void saveModData(class_2487 compoundTag) {
        compoundTag.method_10566(TAG_RECORD_POS,
            this.recordPos == null ? new class_2487() : class_2512.method_10692(this.recordPos));
        compoundTag.method_10566(TAG_PATTERN, this.pattern == null ? new class_2487() : this.pattern.serializeToNBT());
    }

    @Override
    protected void loadModData(class_2487 compoundTag) {
        class_2487 recordPos = compoundTag.method_10562(TAG_RECORD_POS);
        class_2487 pattern = compoundTag.method_10562(TAG_PATTERN);

        if (recordPos.method_10573("X", class_2520.field_33263) &&
            recordPos.method_10573("Y", class_2520.field_33263) &&
            recordPos.method_10573("Z", class_2520.field_33263)) {
            this.recordPos = class_2512.method_10691(recordPos);
        } else {
            this.recordPos = null;
        }
        if (HexPattern.isPattern(pattern)) {
            this.pattern = HexPattern.fromNBT(pattern);
        } else {
            this.pattern = null;
        }
    }

}
