package at.petrak.hexcasting.common.blocks.akashic;

import at.petrak.hexcasting.api.spell.DatumType;
import org.jetbrains.annotations.Nullable;
import var;
import java.util.ArrayDeque;
import java.util.HashSet;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class BlockAkashicRecord extends class_2248 implements class_2343 {
    public BlockAkashicRecord(class_2251 p_49795_) {
        super(p_49795_);
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pPos, class_2680 pState) {
        return new BlockEntityAkashicRecord(pPos, pState);
    }

    @Override
    public boolean method_9498(class_2680 pState) {
        return true;
    }

    @Override
    public int method_9572(class_2680 pState, class_1937 pLevel, class_2338 pPos) {
        class_2586 be = pLevel.method_8321(pPos);
        if (be instanceof BlockEntityAkashicRecord record) {
            return Math.min(15, record.getCount());
        }
        return 0;
    }

    @Override
    public void method_9536(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2680 pNewState, boolean pIsMoving) {
        var seen = new HashSet<class_2338>();
        var todo = new ArrayDeque<class_2338>();
        todo.add(pPos);
        // we do NOT add this position to the valid positions, because the record
        // isn't flood-fillable through.
        while (!todo.isEmpty()) {
            var here = todo.remove();

            for (var dir : class_2350.values()) {
                var neighbor = here.relative(dir);
                if (seen.add(neighbor)) {
                    var bs = pLevel.method_8320(neighbor);
                    if (BlockAkashicFloodfiller.canItBeFloodedThrough(neighbor, bs, pLevel)) {
                        todo.add(neighbor);
                    }
                    if (pLevel.method_8321(neighbor) instanceof BlockEntityAkashicBookshelf shelf) {
                        shelf.setNewData(null, null, DatumType.EMPTY);
                    }
                }
            }
        }
        super.method_9536(pState, pLevel, pPos, pNewState, pIsMoving);
    }
}
