package at.petrak.hexcasting.common.blocks.akashic;

import at.petrak.hexcasting.api.misc.TriPredicate;
import at.petrak.hexcasting.common.lib.HexBlocks;
import org.jetbrains.annotations.Nullable;
import var;
import java.util.ArrayDeque;
import java.util.HashSet;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;

public class BlockAkashicFloodfiller extends class_2248 {
    public BlockAkashicFloodfiller(class_2251 p_49795_) {
        super(p_49795_);
    }

    public @Nullable
    class_2338 getRecordPosition(class_2338 here, class_2680 state, class_1937 world) {
        return floodFillFor(here, world,
            (pos, bs, level) -> bs.method_27852(HexBlocks.AKASHIC_RECORD));
    }

    @Override
    public void method_9536(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2680 pNewState, boolean pIsMoving) {
        var recordPos = this.getRecordPosition(pPos, pState, pLevel);
        if (recordPos != null && pLevel.method_8321(recordPos) instanceof BlockEntityAkashicRecord akashic) {
            akashic.removeFloodfillerAt(pPos);
        }

        super.method_9536(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public boolean canBeFloodedThrough(class_2338 pos, class_2680 state, class_1937 world) {
        return true;
    }


    public static @Nullable
    class_2338 floodFillFor(class_2338 start, class_1937 world,
        TriPredicate<class_2338, class_2680, class_1937> isValid, TriPredicate<class_2338, class_2680, class_1937> isTarget) {
        var seenBlocks = new HashSet<class_2338>();
        var todo = new ArrayDeque<class_2338>();
        todo.add(start);

        while (!todo.isEmpty()) {
            var here = todo.remove();

            for (var dir : class_2350.values()) {
                var neighbor = here.relative(dir);
                if (seenBlocks.add(neighbor)) {
                    var bs = world.method_8320(neighbor);
                    if (isTarget.test(neighbor, bs, world)) {
                        return neighbor;
                    } else if (isValid.test(neighbor, bs, world)) {
                        todo.add(neighbor);
                    }
                }
            }
        }

        return null;
    }

    public static @Nullable
    class_2338 floodFillFor(class_2338 start, class_1937 world,
        TriPredicate<class_2338, class_2680, class_1937> isTarget) {
        return floodFillFor(start, world, BlockAkashicFloodfiller::canItBeFloodedThrough, isTarget);
    }

    public static boolean canItBeFloodedThrough(class_2338 pos, class_2680 state, class_1937 world) {
        if (!(state.method_26204() instanceof BlockAkashicFloodfiller flooder)) {
            return false;
        }

        return flooder.canBeFloodedThrough(pos, state, world);
    }
}
