package at.petrak.hexcasting.common.blocks.akashic;

import at.petrak.hexcasting.annotations.SoftImplement;
import at.petrak.hexcasting.api.spell.DatumType;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.common.items.ItemScroll;
import at.petrak.hexcasting.common.lib.HexBlocks;
import at.petrak.hexcasting.common.lib.HexSounds;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import org.jetbrains.annotations.Nullable;
import var;

public class BlockAkashicBookshelf extends BlockAkashicFloodfiller implements class_2343 {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2754<DatumType> DATUM_TYPE = class_2754.method_11850("datum_type", DatumType.class);

    public BlockAkashicBookshelf(class_2251 p_49795_) {
        super(p_49795_);
        this.method_9590(this.method_9595().method_11664()
            .method_11657(FACING, class_2350.field_11043)
            .method_11657(DATUM_TYPE, DatumType.EMPTY));
    }

    @Override
    public @Nullable
    class_2338 getRecordPosition(class_2338 herePos, class_2680 state, class_1937 world) {
        // time saving measure?
        if (world.method_8321(herePos) instanceof BlockEntityAkashicBookshelf tile &&
            tile.getRecordPos() != null && world.method_8321(
            tile.getRecordPos()) instanceof BlockEntityAkashicRecord) {
            return tile.getRecordPos();
        }
        return super.getRecordPosition(herePos, state, world);
    }

    @Override
    public class_1269 method_9534(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_1657 pPlayer, class_1268 pHand,
        class_3965 pHit) {
        if (pLevel.method_8321(pPos) instanceof BlockEntityAkashicBookshelf shelf) {
            var stack = pPlayer.method_5998(pHand);
            if (stack.getItem() instanceof ItemScroll scroll) {
                if (!pLevel.method_8608()) {
                    scroll.writeDatum(stack, SpellDatum.make(shelf.getPattern()));
                }
                pLevel.method_8396(pPlayer, pPos, HexSounds.SCROLL_SCRIBBLE, class_3419.field_15245, 1f, 1f);
                return class_1269.method_29236(pLevel.field_9236);
            } else if (pPlayer.method_21751() && pHand == class_1268.field_5808 && stack.isEmpty()) {
                if (!pLevel.method_8608()) {
                    shelf.setNewData(null, null, DatumType.EMPTY);

                    var recordPos = HexBlocks.AKASHIC_BOOKSHELF.getRecordPosition(pPos, pState, pLevel);
                    if (recordPos != null &&
                        pLevel.method_8321(recordPos) instanceof BlockEntityAkashicRecord record) {
                        record.revalidateAllBookshelves();
                    }
                }

                pLevel.method_8396(pPlayer, pPos, HexSounds.SCROLL_SCRIBBLE, class_3419.field_15245,
                    1f, 0.8f);
                return class_1269.method_29236(pLevel.field_9236);
            }
        }

        return class_1269.field_5811;
    }

    @Override
    public void method_9615(class_2680 pState, class_1937 world, class_2338 pos, class_2680 pOldState, boolean pIsMoving) {
        if (world.method_8321(pos) instanceof BlockEntityAkashicBookshelf tile) {
            var recordPos = BlockAkashicFloodfiller.floodFillFor(pos, world,
                (here, bs, level) -> bs.method_27852(HexBlocks.AKASHIC_RECORD));
            if (pOldState.method_26204() != pState.method_26204()) {
                tile.setNewData(recordPos, recordPos == null ? null : tile.getPattern(),
                    recordPos == null ? DatumType.EMPTY : pState.method_11654(DATUM_TYPE));
            }
        }
    }

    @Override
    public void method_9612(class_2680 pState, class_1937 world, class_2338 pos, class_2248 pBlock, class_2338 pFromPos,
        boolean pIsMoving) {
        if (world.method_8321(pos) instanceof BlockEntityAkashicBookshelf tile) {
            var recordPos = BlockAkashicFloodfiller.floodFillFor(pos, world,
                (here, bs, level) -> bs.method_27852(HexBlocks.AKASHIC_RECORD));
            tile.setNewData(recordPos, recordPos == null ? null : tile.getPattern(),
                recordPos == null ? DatumType.EMPTY : pState.method_11654(DATUM_TYPE));
        }
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING, DATUM_TYPE);
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564().method_11657(FACING, ctx.method_8042().method_10153());
    }

    // TODO: fabric
    @SoftImplement("Forge")
    public float getEnchantPowerBonus(class_2680 state, class_4538 level, class_2338 pos) {
        return 1;
    }

    @Override
    public boolean method_9498(class_2680 pState) {
        return true;
    }

    @Override
    public int method_9572(class_2680 pState, class_1937 pLevel, class_2338 pPos) {
        return pState.method_11654(DATUM_TYPE).ordinal();
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pPos, class_2680 pState) {
        return new BlockEntityAkashicBookshelf(pPos, pState);
    }

    public class_2680 method_9598(class_2680 pState, class_2470 pRot) {
        return pState.method_11657(FACING, pRot.method_10503(pState.method_11654(FACING)));
    }

    public class_2680 method_9569(class_2680 pState, class_2415 pMirror) {
        return pState.method_26186(pMirror.method_10345(pState.method_11654(FACING)));
    }
}
