package at.petrak.hexcasting.client.particles;

import ConjureRenderType;
import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.common.particles.ConjureParticleOptions;
import at.petrak.hexcasting.xplat.IClientXplatAbstractions;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1059;
import net.minecraft.class_1060;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_5253;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.client.particle.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import record;
import var;
import java.util.Random;

public class ConjureParticle extends class_4003 {
    private static final Random RANDOM = new Random();

    private final class_4002 sprites;
    private final boolean light;

    ConjureParticle(class_638 pLevel, double x, double y, double z, double dx, double dy, double dz,
        class_4002 pSprites, int color, boolean light) {
        super(pLevel, x, y, z, dx, dy, dz);
        this.light = light;
        this.field_17867 *= light ? 0.9f : 0.75f;
        this.method_34753(dx, dy, dz);

        var lightness = light ? 0.3f : 1.0f;
        var r = class_5253.class_5254.method_27765(color);
        var g = class_5253.class_5254.method_27766(color);
        var b = class_5253.class_5254.method_27767(color);
        var a = class_5253.class_5254.method_27762(color);
        this.method_3084(r / 255f * lightness, g / 255f * lightness, b / 255f * lightness);
        this.method_3083(a / 255f * lightness);

        this.field_28786 = 0.96F;
        this.field_3844 = light && dy != 0 && dx != 0 && dz != 0 ? -0.01F : 0F;
        this.field_28787 = true;
        this.sprites = pSprites;

        this.field_3839 = RANDOM.nextFloat(360);
        this.field_3857 = this.field_3839;

        this.field_3847 = (int) ((light ? 64.0D : 32.0D) / ((Math.random() + 3f) * 0.25f));
        this.field_3862 = false;
        this.method_18142(pSprites);
    }

    public @NotNull class_3999 method_18122() {
        return this.light ? LIGHT_RENDER_TYPE : CONJURE_RENDER_TYPE;
    }

    public void method_3070() {
        super.method_3070();
        this.method_18142(this.sprites);
        this.field_3841 = 1.0f - ((float) this.field_3866 / (float) this.field_3847);
        if (light) {
            this.field_17867 *= 0.96f;
        }
    }

    public void method_18142(@NotNull class_4002 pSprite) {
        if (!this.field_3843) {
            int age = this.field_3866 * 4;
            if (age > this.field_3847) {
                age /= 4;
            }
            this.method_18141(pSprite.method_18138(age, this.field_3847));
        }
    }

    public static class Provider implements class_707<ConjureParticleOptions> {
        private final class_4002 sprite;

        public Provider(class_4002 pSprites) {
            this.sprite = pSprites;
        }

        @Nullable
        @Override
        public class_703 createParticle(ConjureParticleOptions type, class_638 level,
            double pX, double pY, double pZ,
            double pXSpeed, double pYSpeed, double pZSpeed) {
            return new ConjureParticle(level, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed, this.sprite, type.color(),
                type.isLight());
        }
    }

    // https://github.com/VazkiiMods/Botania/blob/db85d778ab23f44c11181209319066d1f04a9e3d/Xplat/src/main/java/vazkii/botania/client/fx/FXWisp.java
    private record ConjureRenderType(boolean light) implements ParticleRenderType {
        @Override
        public void begin(class_287 buf, class_1060 texMan) {
            class_310.method_1551().field_1773.method_22974().method_3316();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask(false);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE);

            RenderSystem.setShaderTexture(0, class_1059.field_17898);
            var tex = texMan.method_4619(class_1059.field_17898);
            IClientXplatAbstractions.INSTANCE.setFilterSave(tex, this.light, false);
            buf.method_1328(class_293.class_5596.field_27382, class_290.field_1584);
        }

        @Override
        public void end(class_289 tess) {
            tess.method_1350();
            IClientXplatAbstractions.INSTANCE.restoreLastFilter(
                class_310.method_1551().method_1531().method_4619(class_1059.field_17898)
            );
            RenderSystem.disableBlend();
            RenderSystem.depthMask(true);
        }

        @Override
        public String toString() {
            return HexAPI.MOD_ID + (light ? ":light" : ":conjure");
        }
    }

    public static final ConjureRenderType CONJURE_RENDER_TYPE = new ConjureRenderType(false);
    public static final ConjureRenderType LIGHT_RENDER_TYPE = new ConjureRenderType(true);
}
