package at.petrak.hexcasting.client.gui;

import at.petrak.hexcasting.client.ClientTickCounter;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.client.RenderLib;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1159;
import net.minecraft.class_241;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_757;
import net.minecraft.class_918;
import var;

// https://github.com/VazkiiMods/Quark/blob/master/src/main/java/vazkii/quark/content/client/tooltip/MapTooltips.java
// yoink
public class PatternTooltipGreeble implements class_5684, class_5632 {
    public static final class_2960 PRISTINE_BG = new class_2960(
        "hexcasting:textures/gui/scroll.png");
    public static final class_2960 ANCIENT_BG = new class_2960(
        "hexcasting:textures/gui/scroll_ancient.png");
    public static final class_2960 SLATE_BG = new class_2960(
        "hexcasting:textures/gui/slate.png");

    private static final float SIZE = 72f;

    private final HexPattern pattern;
    private final List<class_241> zappyPoints;
    private final List<class_241> pathfinderDots;
    private final float scale;
    private final class_2960 background;

    public PatternTooltipGreeble(HexPattern pattern, class_2960 background) {
        this.pattern = pattern;
        this.background = background;

        var pair = RenderLib.getCenteredPattern(pattern, SIZE, SIZE, 8f);
        this.scale = pair.getFirst();
        var dots = pair.getSecond();
        this.zappyPoints = RenderLib.makeZappy(dots, 10f, 0.8f, 0f, 0f);
        this.pathfinderDots = dots.stream().distinct().collect(Collectors.toList());
    }

    @Override
    public void method_32666(class_327 font, int mouseX, int mouseY, class_4587 ps, class_918 pItemRenderer,
        int pBlitOffset) {
        var width = this.method_32664(font);
        var height = this.method_32661();

        // far as i can tell "mouseX" and "mouseY" are actually the positions of the corner of the tooltip
        ps.method_22903();
        ps.method_22904(mouseX, mouseY, 500);
        RenderSystem.enableBlend();
        renderBG(ps, this.background);

        // renderText happens *before* renderImage for some asinine reason
//                RenderSystem.disableBlend();
        ps.method_22904(0, 0, 100);

        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.disableCull();
        RenderSystem.blendFunc(GlStateManager.class_4535.SRC_ALPHA,
            GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        ps.method_22904(width / 2f, height / 2f, 1);

        var mat = ps.method_23760().method_23761();
        var outer = 0xff_d2c8c8;
        var innerLight = 0xc8_aba2a2;
        var innerDark = 0xc8_322b33;
        RenderLib.drawLineSeq(mat, this.zappyPoints, 5f, 0,
            outer, outer, null);
        RenderLib.drawLineSeq(mat, this.zappyPoints, 2f, 0,
            innerDark, innerLight,
            ClientTickCounter.total / 40f);
        RenderLib.drawSpot(mat, this.zappyPoints.get(0), 2.5f, 1f, 0.1f, 0.15f, 0.6f);

        for (var dot : this.pathfinderDots) {
            RenderLib.drawSpot(mat, dot, 1.5f, 0.82f, 0.8f, 0.8f, 0.5f);
        }

        ps.method_22909();
    }

    private static void renderBG(class_4587 ps, class_2960 background) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor(1f, 1f, 1f, 1f);
        RenderSystem.setShaderTexture(0, background);


        // i wish i liked mobius front enough ot get to the TIS puzzles
        class_287 buffer = class_289.method_1348().method_1349();
        class_1159 neo = ps.method_23760().method_23761();

        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        buffer.method_22918(neo, 0, 0, 0.0F).method_22913(0.0F, 0.0F).method_1344();
        buffer.method_22918(neo, 0, SIZE, 0.0F).method_22913(0.0F, 1.0f).method_1344();
        buffer.method_22918(neo, SIZE, SIZE, 0.0F).method_22913(1.0F, 1.0f).method_1344();
        buffer.method_22918(neo, SIZE, 0, 0.0F).method_22913(1.0F, 0.0F).method_1344();
        buffer.method_1326();
        class_286.method_1309(buffer);


    }

    @Override
    public int method_32664(class_327 pFont) {
        return (int) SIZE;
    }

    @Override
    public int method_32661() {
        return (int) SIZE;
    }
}
