package at.petrak.hexcasting.client.entity;

import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.common.entities.EntityWallScroll;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1921;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_897;
import var;

import static at.petrak.hexcasting.api.HexAPI.modLoc;

public class WallScrollRenderer extends class_897<EntityWallScroll> {
    private static final class_2960 PRISTINE_BG = modLoc("textures/entity/scroll.png");
    private static final class_2960 ANCIENT_BG = modLoc("textures/entity/scroll_ancient.png");
    private static final class_2960 WHITE = modLoc("textures/entity/white.png");

    public WallScrollRenderer(class_5617.class_5618 p_174008_) {
        super(p_174008_);
    }

    // I do as the PaintingRenderer guides
    @Override
    public void render(EntityWallScroll wallScroll, float yaw, float partialTicks, class_4587 ps,
        class_4597 bufSource, int packedLight) {
        
        RenderSystem.setShader(class_757::method_34542);

        ps.method_22903();

        ps.method_22907(class_1160.field_20705.method_23214(180f - yaw));
        ps.method_22907(class_1160.field_20707.method_23214(180f));

        int light = class_761.method_23794(wallScroll.field_6002, wallScroll.method_6896());

        {
            ps.method_22903();
            // X is right, Y is down, Z is *in*
            // Our origin will be the lower-left corner of the scroll touching the wall
            // (so it has "negative" thickness)
            ps.method_22904(-1.5, -1.5, 1f / 32f);

            float dx = 3f, dy = 3f, dz = -1f / 16f;
            float margin = 1f / 48f;
            var last = ps.method_23760();
            var mat = last.pose();
            var norm = last.normal();

            var verts = bufSource.getBuffer(class_1921.method_23576(this.getTextureLocation(wallScroll)));
            // Remember: CCW
            // Front face
            vertex(mat, norm, light, verts, 0, 0, dz, 0, 0, 0, 0, -1);
            vertex(mat, norm, light, verts, 0, dy, dz, 0, 1, 0, 0, -1);
            vertex(mat, norm, light, verts, dx, dy, dz, 1, 1, 0, 0, -1);
            vertex(mat, norm, light, verts, dx, 0, dz, 1, 0, 0, 0, -1);
            // Back face
            vertex(mat, norm, light, verts, 0, 0, 0, 0, 0, 0, 0, 1);
            vertex(mat, norm, light, verts, dx, 0, 0, 1, 0, 0, 0, 1);
            vertex(mat, norm, light, verts, dx, dy, 0, 1, 1, 0, 0, 1);
            vertex(mat, norm, light, verts, 0, dy, 0, 0, 1, 0, 0, 1);
            // Top face
            vertex(mat, norm, light, verts, 0, 0, 0, 0, 0, 0, -1, 0);
            vertex(mat, norm, light, verts, 0, 0, dz, 0, margin, 0, -1, 0);
            vertex(mat, norm, light, verts, dx, 0, dz, 1, margin, 0, -1, 0);
            vertex(mat, norm, light, verts, dx, 0, 0, 1, 0, 0, -1, 0);
            // Left face
            vertex(mat, norm, light, verts, 0, 0, 0, 0, 0, -1, 0, 0);
            vertex(mat, norm, light, verts, 0, dy, 0, 0, 1, -1, 0, 0);
            vertex(mat, norm, light, verts, 0, dy, dz, margin, 1, -1, 0, 0);
            vertex(mat, norm, light, verts, 0, 0, dz, margin, 0, -1, 0, 0);
            // Right face
            vertex(mat, norm, light, verts, dx, 0, dz, 1 - margin, 0, 1, 0, 0);
            vertex(mat, norm, light, verts, dx, dy, dz, 1 - margin, 1, 1, 0, 0);
            vertex(mat, norm, light, verts, dx, dy, 0, 1, 1, 1, 0, 0);
            vertex(mat, norm, light, verts, dx, 0, 0, 1, 0, 1, 0, 0);
            // Bottom face
            vertex(mat, norm, light, verts, 0, dy, dz, 0, 1 - margin, 0, 1, 0);
            vertex(mat, norm, light, verts, 0, dy, 0, 0, 1, 0, 1, 0);
            vertex(mat, norm, light, verts, dx, dy, 0, 1, 1, 0, 1, 0);
            vertex(mat, norm, light, verts, dx, dy, dz, 1, 1 - margin, 0, 1, 0);

            ps.method_22909();
        }

        if (wallScroll.zappyPoints != null) {
            var points = wallScroll.zappyPoints;
            ps.method_22903();

            ps.method_22907(class_1160.field_20705.method_23214(180f));
            ps.method_22904(0, 0, 1.1f / 16f);
            float scale = 1f / 40f;
            ps.method_22905(scale, scale, scale);

            var last = ps.method_23760();
            var mat = last.pose();
            var norm = last.normal();
            var outer = 0xff_d2c8c8;
            var inner = 0xc8_322b33;
            var verts = bufSource.getBuffer(class_1921.method_23576(WHITE));
            theCoolerDrawLineSeq(mat, norm, light, verts, points, 5, outer);
            ps.method_22904(0, 0, 0.01);
            theCoolerDrawLineSeq(mat, norm, light, verts, points, 2, inner);

            if (wallScroll.getShowsStrokeOrder()) {
                var animTime = wallScroll.field_6012;
                var pointCircuit =
                    (animTime * HexConfig.client().patternPointSpeedMultiplier()) % (points.size() + 10);
                if (pointCircuit < points.size() - 1) {
                    var pointMacro = class_3532.method_15375(pointCircuit);
                    var pointMicro = pointCircuit - pointMacro;

                    var p1 = points.get(pointMacro);
                    var p2 = points.get((pointMacro + 1) % points.size());
                    var drawPos = new class_241(
                        (float) (p1.x + (p2.x - p1.x) * pointMicro),
                        (float) (p1.y + (p2.y - p1.y) * pointMicro)
                    );

                    ps.method_22904(0, 0, 0.01);
                    theCoolerDrawSpot(mat, norm, light, verts, drawPos, 2.6666f, 0xff_cfa0f3);
                    ps.method_22904(0, 0, 0.01);
                    theCoolerDrawSpot(mat, norm, light, verts, drawPos, 2f, 0xff_8d6acc);
                } else {
                    ps.method_22904(0, 0, 0.02);
                }

                ps.method_22904(0, 0, 0.01);
                theCoolerDrawSpot(mat, norm, light, verts, points.get(0), 3f, 0xff_4946d3);
                ps.method_22904(0, 0, 0.01);
                theCoolerDrawSpot(mat, norm, light, verts, points.get(0), 2f, 0xff_5b7bd7);
            }

            ps.method_22909();
        }

        ps.method_22909();
        super.method_3936(wallScroll, yaw, partialTicks, ps, bufSource, packedLight);
    }

    @Override
    public class_2960 getTextureLocation(EntityWallScroll wallScroll) {
        if (wallScroll.isAncient) {
            return ANCIENT_BG;
        } else {
            return PRISTINE_BG;
        }
    }

    private static void vertex(class_1159 mat, class_4581 normal, int light, class_4588 verts, float x, float y,
        float z, float u,
        float v, float nx, float ny, float nz) {
        verts.method_22918(mat, x, y, z)
            .method_39415(0xffffffff)
            .method_22913(u, v).method_22922(class_4608.field_21444).method_22916(light)
            .method_23763(normal, nx, ny, nz)
            .method_1344();
    }

    private static void vertexCol(class_1159 mat, class_4581 normal, int light, class_4588 verts, int col, float x,
        float y) {
        verts.method_22918(mat, -x, y, 0)
            .method_39415(col)
            .method_22913(0, 0).method_22922(class_4608.field_21444).method_22916(light)
            .method_23763(normal, 0, 0, 1)
            .method_1344();
    }

    private static void theCoolerDrawLineSeq(class_1159 mat, class_4581 normal, int light, class_4588 verts,
        List<class_241> points, float width, int color
    ) {
        if (points.size() <= 1) {
            return;
        }

        float prevXHi, prevYHi, prevXLo, prevYLo;
        {
            var p1 = points.get(0);
            var p2 = points.get(1);

            var dx = p2.x - p1.x;
            var dy = p2.y - p1.y;
            var nx = -dy;
            var ny = dx;
            var tlen = class_3532.method_15355(nx * nx + ny * ny) / (width * 0.5f);
            var tx = nx / tlen;
            var ty = ny / tlen;

            prevXHi = p1.x - tx;
            prevYHi = p1.y - ty;
            prevXLo = p1.x + tx;
            prevYLo = p1.y + ty;
        }

        for (var i = 0; i < points.size() - 1; i++) {
            var p1 = points.get(i);
            var p2 = points.get(i + 1);

            var dx = p2.x - p1.x;
            var dy = p2.y - p1.y;
            var nx = -dy;
            var ny = dx;
            var tlen = class_3532.method_15355(nx * nx + ny * ny) / (width * 0.5f);
            var tx = nx / tlen;
            var ty = ny / tlen;

            var xHi = p2.x - tx;
            var yHi = p2.y - ty;
            var xLo = p2.x + tx;
            var yLo = p2.y + ty;
            vertexCol(mat, normal, light, verts, color, prevXHi, prevYHi);
            vertexCol(mat, normal, light, verts, color, prevXLo, prevYLo);
            vertexCol(mat, normal, light, verts, color, xLo, yLo);
            vertexCol(mat, normal, light, verts, color, xHi, yHi);

            prevXHi = xHi;
            prevYHi = yHi;
            prevXLo = xLo;
            prevYLo = yLo;
        }
    }

    private static void theCoolerDrawSpot(class_1159 mat, class_4581 normal, int light, class_4588 verts,
        class_241 point, float radius, int color) {
        var fracOfCircle = 6;
        for (int i = 0; i < fracOfCircle; i++) {
            // We do need rects, irritatingly
            // so we do fake triangles
            vertexCol(mat, normal, light, verts, color, point.field_1343, point.field_1342);
            vertexCol(mat, normal, light, verts, color, point.field_1343, point.field_1342);
            for (int j = 0; j <= 1; j++) {
                var theta = (i - j) / (float) fracOfCircle * class_3532.field_29846;
                var rx = class_3532.method_15362(theta) * radius + point.field_1343;
                var ry = class_3532.method_15374(theta) * radius + point.field_1342;
                vertexCol(mat, normal, light, verts, color, rx, ry);
            }
        }
    }
}
