package at.petrak.hexcasting.client.be;

import at.petrak.hexcasting.client.RenderLib;
import at.petrak.hexcasting.common.blocks.circles.BlockEntitySlate;
import at.petrak.hexcasting.common.blocks.circles.BlockSlate;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_241;
import net.minecraft.class_2738;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_757;
import net.minecraft.class_827;
import var;

public class BlockEntitySlateRenderer implements class_827<BlockEntitySlate> {
    public BlockEntitySlateRenderer(class_5614.class_5615 ctx) {
        // NO-OP
    }

    @Override
    public void render(BlockEntitySlate tile, float pPartialTick, class_4587 ps,
        class_4597 buffer, int light, int overlay) {
        if (tile.pattern == null) {
            return;
        }

        var bs = tile.method_11010();

        var oldShader = RenderSystem.getShader();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.enableDepthTest();

        ps.method_22903();

        ps.method_22904(0.5, 0.5, 0.5);
        var attchFace = bs.getValue(BlockSlate.ATTACH_FACE);
        if (attchFace == class_2738.field_12471) {
            var quarters = (-bs.getValue(BlockSlate.FACING).get2DDataValue()) % 4;
            ps.method_22907(new class_1158(class_1160.field_20705, class_3532.field_29845 * quarters, false));
            ps.method_22907(new class_1158(class_1160.field_20707, class_3532.field_29844, false));
        } else {
            var neg = attchFace == class_2738.field_12475 ? -1 : 1;
            ps.method_22907(new class_1158(
                class_1160.field_20703,
                neg * class_3532.field_29845,
                false));
            var quarters = (bs.getValue(BlockSlate.FACING).get2DDataValue() + 2) % 4;
            ps.method_22907(new class_1158(class_1160.field_20707, neg * class_3532.field_29845 * quarters, false));
        }

        // and now Z is out?
        ps.method_22904(0, 0, -0.5);
        ps.method_22905(1 / 16f, 1 / 16f, 1 / 16f);
        ps.method_22904(0, 0, 1.01);

        // yoink code from the pattern greeble
        // Do two passes: one with a random size to find a good COM and one with the real calculation
        var com1 = tile.pattern.getCenter(1);
        var lines1 = tile.pattern.toLines(1, class_241.field_1340);

        var maxDx = -1f;
        var maxDy = -1f;
        for (var dot : lines1) {
            var dx = class_3532.method_15379(dot.x - com1.x);
            if (dx > maxDx) {
                maxDx = dx;
            }
            var dy = class_3532.method_15379(dot.y - com1.y);
            if (dy > maxDy) {
                maxDy = dy;
            }
        }
        var scale = Math.min(3.8f, Math.min(16 / 2.5f / maxDx, 16 / 2.5f / maxDy));

        var com2 = tile.pattern.getCenter(scale);
        var lines2 = tile.pattern.toLines(scale, com2.negated());
        // For some reason it is mirrored left to right and i can't seem to posestack-fu it into shape
        for (int i = 0; i < lines2.size(); i++) {
            var v = lines2.get(i);
            lines2.set(i, new class_241(-v.x, v.y));
        }

        var isLit = bs.getValue(BlockSlate.ENERGIZED);
        var zappy = RenderLib.makeZappy(lines2, 10f, isLit ? 2.5f : 0.5f, isLit ? 0.1f : 0f, 0.2f);

        int outer = isLit ? 0xff_64c8ff : 0xff_d2c8c8;
        int inner = isLit ? RenderLib.screenCol(outer) : 0xc8_322b33;
        RenderLib.drawLineSeq(ps.method_23760().method_23761(), zappy, 1f, 0f, outer, outer);
        RenderLib.drawLineSeq(ps.method_23760().method_23761(), zappy, 0.4f, 0.01f, inner, inner);

        ps.method_22909();
        RenderSystem.setShader(() -> oldShader);
    }
}
