package at.petrak.hexcasting.client.be;

import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.client.RenderLib;
import at.petrak.hexcasting.common.blocks.akashic.BlockAkashicBookshelf;
import at.petrak.hexcasting.common.blocks.akashic.BlockEntityAkashicBookshelf;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_241;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_757;
import net.minecraft.class_827;
import var;

public class BlockEntityAkashicBookshelfRenderer implements class_827<BlockEntityAkashicBookshelf> {
    public BlockEntityAkashicBookshelfRenderer(class_5614.class_5615 ctx) {
        // NO-OP
    }

    @Override
    public void render(BlockEntityAkashicBookshelf tile, float pPartialTick, class_4587 ps,
        class_4597 buffer, int light, int overlay) {
        HexPattern pattern = tile.getPattern();
        if (pattern == null) {
            return;
        }

        var bs = tile.method_11010();

        var oldShader = RenderSystem.getShader();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.enableDepthTest();

        ps.method_22903();

        ps.method_22904(0.5, 0.5, 0.5);
        var quarters = (-bs.getValue(BlockAkashicBookshelf.FACING).get2DDataValue()) % 4;
        ps.method_22907(new class_1158(class_1160.field_20705, class_3532.field_29845 * quarters, false));
        ps.method_22907(new class_1158(class_1160.field_20707, class_3532.field_29844, false));

        // and now Z is out?
        ps.method_22904(0, 0, 0.5);
        ps.method_22905(1 / 16f, 1 / 16f, 1 / 16f);
        ps.method_22904(0, 0, 0.01);

        // yoink code from the pattern greeble
        // Do two passes: one with a random size to find a good COM and one with the real calculation
        var com1 = pattern.getCenter(1);
        var lines1 = pattern.toLines(1, class_241.field_1340);

        var maxDx = -1f;
        var maxDy = -1f;
        for (var dot : lines1) {
            var dx = class_3532.method_15379(dot.x - com1.x);
            if (dx > maxDx) {
                maxDx = dx;
            }
            var dy = class_3532.method_15379(dot.y - com1.y);
            if (dy > maxDy) {
                maxDy = dy;
            }
        }
        var scale = Math.min(3.8f, Math.min(16 / 2.5f / maxDx, 16 / 2.5f / maxDy));

        var com2 = pattern.getCenter(scale);
        var lines2 = pattern.toLines(scale, com2.negated());
        // For some reason it is mirrored left to right and i can't seem to posestack-fu it into shape
        for (int j = 0; j < lines2.size(); j++) {
            var v = lines2.get(j);
            lines2.set(j, new class_241(-v.x, v.y));
        }

        var zappy = RenderLib.makeZappy(lines2, 10f, 0.5f, 0f, 0f);

        int outer = 0xff_d2c8c8;
        int inner = 0xc8_322b33;
        RenderLib.drawLineSeq(ps.method_23760().method_23761(), zappy, 1f, 0f, outer, outer);
        RenderLib.drawLineSeq(ps.method_23760().method_23761(), zappy, 0.4f, 0.01f, inner, inner);

        ps.method_22909();
        RenderSystem.setShader(() -> oldShader);
    }
}
