package at.petrak.hexcasting.client;

import at.petrak.hexcasting.api.block.circle.BlockAbstractImpetus;
import at.petrak.hexcasting.api.block.circle.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.client.ScryingLensOverlayRegistry;
import at.petrak.hexcasting.api.item.DataHolderItem;
import at.petrak.hexcasting.api.item.ManaHolderItem;
import at.petrak.hexcasting.api.misc.ManaConstants;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.Widget;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.client.be.BlockEntityAkashicBookshelfRenderer;
import at.petrak.hexcasting.client.be.BlockEntitySlateRenderer;
import at.petrak.hexcasting.client.entity.WallScrollRenderer;
import at.petrak.hexcasting.client.particles.ConjureParticle;
import at.petrak.hexcasting.common.blocks.akashic.BlockEntityAkashicBookshelf;
import at.petrak.hexcasting.common.blocks.akashic.BlockEntityAkashicRecord;
import at.petrak.hexcasting.common.entities.HexEntities;
import at.petrak.hexcasting.common.items.ItemFocus;
import at.petrak.hexcasting.common.items.ItemScroll;
import at.petrak.hexcasting.common.items.ItemSlate;
import at.petrak.hexcasting.common.items.ItemWand;
import at.petrak.hexcasting.common.items.magic.ItemManaBattery;
import at.petrak.hexcasting.common.items.magic.ItemPackagedHex;
import at.petrak.hexcasting.common.lib.HexBlockEntities;
import at.petrak.hexcasting.common.lib.HexBlocks;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.lib.HexParticles;
import at.petrak.hexcasting.xplat.IClientXplatAbstractions;
import com.mojang.datafixers.util.Pair;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2286;
import net.minecraft.class_2350;
import net.minecraft.class_2428;
import net.minecraft.class_2457;
import net.minecraft.class_2462;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2591;
import net.minecraft.class_2747;
import net.minecraft.class_2766;
import net.minecraft.class_3532;
import net.minecraft.class_5251;
import net.minecraft.class_5614;
import net.minecraft.world.level.block.*;
import org.jetbrains.annotations.NotNull;
import var;
import java.util.Locale;
import java.util.function.UnaryOperator;

public class RegisterClientStuff {
    public static void init() {
        registerDataHolderOverrides(HexItems.FOCUS);
        registerDataHolderOverrides(HexItems.SPELLBOOK);

        registerPackagedSpellOverrides(HexItems.CYPHER);
        registerPackagedSpellOverrides(HexItems.TRINKET);
        registerPackagedSpellOverrides(HexItems.ARTIFACT);

        var x = IClientXplatAbstractions.INSTANCE;
        x.registerItemProperty(HexItems.BATTERY, ItemManaBattery.MANA_PREDICATE,
            (stack, level, holder, holderID) -> {
                var item = (ManaHolderItem) stack.getItem();
                return item.getManaFullness(stack);
            });
        x.registerItemProperty(HexItems.BATTERY, ItemManaBattery.MAX_MANA_PREDICATE,
            (stack, level, holder, holderID) -> {
                var item = (ItemManaBattery) stack.getItem();
                var max = item.getMaxMana(stack);
                return (float) Math.sqrt((float) max / ManaConstants.CRYSTAL_UNIT / 10);
            });

        x.registerItemProperty(HexItems.SCROLL, ItemScroll.ANCIENT_PREDICATE,
            (stack, level, holder, holderID) -> NBTHelper.hasString(stack, ItemScroll.TAG_OP_ID) ? 1f : 0f);

        x.registerItemProperty(HexItems.SLATE, ItemSlate.WRITTEN_PRED,
            (stack, level, holder, holderID) -> ItemSlate.hasPattern(stack) ? 1f : 0f);

        registerWandOverrides(HexItems.WAND_OAK);
        registerWandOverrides(HexItems.WAND_BIRCH);
        registerWandOverrides(HexItems.WAND_SPRUCE);
        registerWandOverrides(HexItems.WAND_JUNGLE);
        registerWandOverrides(HexItems.WAND_DARK_OAK);
        registerWandOverrides(HexItems.WAND_ACACIA);
        registerWandOverrides(HexItems.WAND_AKASHIC);

        HexTooltips.init();

        x.setRenderLayer(HexBlocks.CONJURED_LIGHT, class_1921.method_23581());
        x.setRenderLayer(HexBlocks.CONJURED_BLOCK, class_1921.method_23581());
        x.setRenderLayer(HexBlocks.AKASHIC_DOOR, class_1921.method_23581());
        x.setRenderLayer(HexBlocks.AKASHIC_TRAPDOOR, class_1921.method_23581());
        x.setRenderLayer(HexBlocks.SCONCE, class_1921.method_23581());

        x.setRenderLayer(HexBlocks.AKASHIC_LEAVES1, class_1921.method_23579());
        x.setRenderLayer(HexBlocks.AKASHIC_LEAVES2, class_1921.method_23579());
        x.setRenderLayer(HexBlocks.AKASHIC_LEAVES3, class_1921.method_23579());

        x.setRenderLayer(HexBlocks.AKASHIC_RECORD, class_1921.method_23583());

        x.registerEntityRenderer(HexEntities.WALL_SCROLL, WallScrollRenderer::new);

        addScryingLensStuff();
    }

    private static void addScryingLensStuff() {
        ScryingLensOverlayRegistry.addPredicateDisplayer(
            (state, pos, observer, world, direction, lensHand) -> state.method_26204() instanceof BlockAbstractImpetus,
            (lines, state, pos, observer, world, direction, lensHand) -> {
                if (world.method_8321(pos) instanceof BlockEntityAbstractImpetus beai) {
                    beai.applyScryingLensOverlay(lines, state, pos, observer, world, direction, lensHand);
                }
            });

        ScryingLensOverlayRegistry.addDisplayer(class_2246.field_10179,
            (lines, state, pos, observer, world, direction, lensHand) -> {
                int note = state.method_11654(class_2428.field_11324);

                float rCol = Math.max(0.0F, class_3532.method_15374((note / 24F + 0.0F) * class_3532.field_29846) * 0.65F + 0.35F);
                float gCol = Math.max(0.0F, class_3532.method_15374((note / 24F + 0.33333334F) * class_3532.field_29846) * 0.65F + 0.35F);
                float bCol = Math.max(0.0F, class_3532.method_15374((note / 24F + 0.6666667F) * class_3532.field_29846) * 0.65F + 0.35F);

                int noteColor = 0xFF_000000 | class_3532.method_15353(rCol, gCol, bCol);

                var instrument = state.method_11654(class_2428.field_11325);

                lines.add(new Pair<>(
                    new class_1799(class_1802.field_8623),
                    new class_2585(String.valueOf(instrument.ordinal()))
                        .method_27694(color(instrumentColor(instrument)))));
                lines.add(new Pair<>(
                    new class_1799(class_1802.field_8643),
                    new class_2585(String.valueOf(note))
                        .method_27694(color(noteColor))));
            });

        ScryingLensOverlayRegistry.addDisplayer(HexBlocks.AKASHIC_BOOKSHELF,
            (lines, state, pos, observer, world, direction, lensHand) -> {
                if (world.method_8321(pos) instanceof BlockEntityAkashicBookshelf tile) {
                    var recordPos = tile.getRecordPos();
                    var pattern = tile.getPattern();
                    if (recordPos != null && pattern != null) {
                        lines.add(new Pair<>(new class_1799(HexBlocks.AKASHIC_RECORD), new class_2588(
                            "hexcasting.tooltip.lens.akashic.bookshelf.location",
                            recordPos.toShortString()
                        )));
                        if (world.method_8321(recordPos) instanceof BlockEntityAkashicRecord record) {
                            lines.add(new Pair<>(new class_1799(class_1802.field_8529), record.getDisplayAt(pattern)));
                        }
                    }
                }
            });

        ScryingLensOverlayRegistry.addDisplayer(HexBlocks.AKASHIC_RECORD,
            (lines, state, pos, observer, world, direction, lensHand) -> {
                if (world.method_8321(pos) instanceof BlockEntityAkashicRecord tile) {
                    int count = tile.getCount();

                    lines.add(new Pair<>(new class_1799(HexBlocks.AKASHIC_BOOKSHELF), new class_2588(
                        "hexcasting.tooltip.lens.akashic.record.count" + (count == 1 ? ".single" : ""),
                        count
                    )));
                }
            });

        ScryingLensOverlayRegistry.addDisplayer(class_2246.field_10377,
            (lines, state, pos, observer, world, direction, lensHand) -> {
                int comparatorValue = ScryingLensOverlayRegistry.getComparatorValue(true);
                lines.add(new Pair<>(
                    new class_1799(class_1802.field_8725),
                    new class_2585(comparatorValue == -1 ? "" : String.valueOf(comparatorValue))
                        .method_27694(redstoneColor(comparatorValue))));

                boolean compare = state.method_11654(class_2286.field_10789) == class_2747.field_12576;

                lines.add(new Pair<>(
                    new class_1799(class_1802.field_8530),
                    new class_2585(
                        compare ? ">=" : "-")
                        .method_27694(redstoneColor(compare ? 0 : 15))));
            });

        ScryingLensOverlayRegistry.addDisplayer(class_2246.field_10450,
            (lines, state, pos, observer, world, direction, lensHand) -> lines.add(new Pair<>(
                new class_1799(class_1802.field_8557),
                new class_2585(String.valueOf(state.method_11654(class_2462.field_11451)))
                    .method_27692(class_124.field_1054))));

        ScryingLensOverlayRegistry.addPredicateDisplayer(
            (state, pos, observer, world, direction, lensHand) -> state.method_26219() && !state.method_27852(
                class_2246.field_10377),
            (lines, state, pos, observer, world, direction, lensHand) -> {
                int signalStrength = 0;
                if (state.method_26204() instanceof class_2457) {
                    signalStrength = state.method_11654(class_2457.field_11432);
                } else {
                    for (class_2350 dir : class_2350.values()) {
                        signalStrength = Math.max(signalStrength, state.method_26195(world, pos, dir));
                    }
                }

                lines.add(0, new Pair<>(
                    new class_1799(class_1802.field_8725),
                    new class_2585(String.valueOf(signalStrength))
                        .method_27694(redstoneColor(signalStrength))));
            });

        ScryingLensOverlayRegistry.addPredicateDisplayer(
            (state, pos, observer, world, direction, lensHand) -> state.method_26221(),
            (lines, state, pos, observer, world, direction, lensHand) -> {
                int comparatorValue = ScryingLensOverlayRegistry.getComparatorValue(false);
                lines.add(
                    new Pair<>(
                        new class_1799(class_1802.field_8857),
                        new class_2585(comparatorValue == -1 ? "" : String.valueOf(comparatorValue))
                            .method_27694(redstoneColor(comparatorValue))));
            });
    }

    private static UnaryOperator<class_2583> color(int color) {
        return (style) -> style.method_27703(class_5251.method_27717(color));
    }

    private static UnaryOperator<class_2583> redstoneColor(int power) {
        return color(class_2457.method_10487(class_3532.method_15340(power, 0, 15)));
    }

    private static int instrumentColor(class_2766 instrument) {
        return switch(instrument) {
            case BASEDRUM -> MaterialColor.STONE.col;
            case SNARE, XYLOPHONE, PLING -> MaterialColor.SAND.col;
            case HAT -> MaterialColor.QUARTZ.col;
            case BASS -> MaterialColor.WOOD.col;
            case FLUTE -> MaterialColor.CLAY.col;
            case BELL -> MaterialColor.GOLD.col;
            case GUITAR -> MaterialColor.WOOL.col;
            case CHIME -> MaterialColor.ICE.col;
            case IRON_XYLOPHONE -> MaterialColor.METAL.col;
            case COW_BELL -> MaterialColor.COLOR_BROWN.col;
            case DIDGERIDOO -> MaterialColor.COLOR_ORANGE.col;
            case BIT -> MaterialColor.EMERALD.col;
            case BANJO -> MaterialColor.COLOR_YELLOW.col;
            default -> -1;
        };
    }

    private static void registerDataHolderOverrides(DataHolderItem item) {
        IClientXplatAbstractions.INSTANCE.registerItemProperty((class_1792) item, ItemFocus.DATATYPE_PRED,
            (stack, level, holder, holderID) -> {
                var datum = item.readDatumTag(stack);
                String override = NBTHelper.getString(stack, DataHolderItem.TAG_OVERRIDE_VISUALLY);
                String typename = null;
                if (override != null) {
                    typename = override;
                } else if (datum != null) {
                    typename = datum.getAllKeys().iterator().next();
                }

                return typename == null ? 0f : switch (typename) {
                    case SpellDatum.TAG_ENTITY -> 1f;
                    case SpellDatum.TAG_DOUBLE -> 2f;
                    case SpellDatum.TAG_VEC3 -> 3f;
                    case SpellDatum.TAG_WIDGET -> 4f;
                    case SpellDatum.TAG_LIST -> 5f;
                    case SpellDatum.TAG_PATTERN -> 6f;
                    default -> 0f; // uh oh
                };
            });
        IClientXplatAbstractions.INSTANCE.registerItemProperty((class_1792) item, ItemFocus.SEALED_PRED,
            (stack, level, holder, holderID) -> item.canWrite(stack, SpellDatum.make(Widget.NULL)) ? 0f : 1f);
    }

    private static void registerPackagedSpellOverrides(ItemPackagedHex item) {
        IClientXplatAbstractions.INSTANCE.registerItemProperty(item, ItemPackagedHex.HAS_PATTERNS_PRED,
            (stack, level, holder, holderID) ->
                item.hasHex(stack) ? 1f : 0f
        );
    }

    private static void registerWandOverrides(ItemWand item) {
        IClientXplatAbstractions.INSTANCE.registerItemProperty(item, ItemWand.FUNNY_LEVEL_PREDICATE,
            (stack, level, holder, holderID) -> {
                var name = stack.method_7964().getString().toLowerCase(Locale.ROOT);
                if (name.contains("old")) {
                    return 1f;
                } else if (name.contains("wand of the forest")) {
                    return 2f;
                } else {
                    return 0f;
                }
            });
    }

    public static void registerParticles() {
        // rip particle man
        IClientXplatAbstractions.INSTANCE.registerParticleType(HexParticles.LIGHT_PARTICLE,
            ConjureParticle.Provider::new);
        IClientXplatAbstractions.INSTANCE.registerParticleType(HexParticles.CONJURE_PARTICLE,
            ConjureParticle.Provider::new);
    }

    public static void registerBlockEntityRenderers(@NotNull BlockEntityRendererRegisterererer registerer) {
        registerer.registerBlockEntityRenderer(HexBlockEntities.SLATE_TILE, BlockEntitySlateRenderer::new);
        registerer.registerBlockEntityRenderer(HexBlockEntities.AKASHIC_BOOKSHELF_TILE,
            BlockEntityAkashicBookshelfRenderer::new);
    }

    @FunctionalInterface
    public interface BlockEntityRendererRegisterererer {
        <T extends class_2586> void registerBlockEntityRenderer(class_2591<T> type,
            class_5614<? super T> berp);
    }
}
