package at.petrak.hexcasting.client;

import at.petrak.hexcasting.api.client.ScryingLensOverlayRegistry;
import at.petrak.hexcasting.api.player.Sentinel;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2477;
import net.minecraft.class_2583;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_757;
import var;

public class HexAdditionalRenderers {
    public static void overlayLevel(class_4587 ps, float partialTick) {
        var player = class_310.method_1551().field_1724;
        if (player != null) {
            var sentinel = IXplatAbstractions.INSTANCE.getSentinel(player);
            if (sentinel.hasSentinel() && player.getLevel().dimension().equals(sentinel.dimension())) {
                renderSentinel(sentinel, player, ps, partialTick);
            }
        }
    }

    public static void overlayGui(class_4587 ps, float partialTicks) {
        tryRenderScryingLensOverlay(ps, partialTicks);
    }

    private static void renderSentinel(Sentinel sentinel, class_746 owner,
        class_4587 ps, float partialTicks) {
        ps.method_22903();

        // zero vector is the player
        var mc = class_310.method_1551();
        var camera = mc.gameRenderer.getMainCamera();
        var playerPos = camera.getPosition();
        ps.method_22904(
            sentinel.position().field_1352 - playerPos.x,
            sentinel.position().field_1351 - playerPos.y,
            sentinel.position().field_1350 - playerPos.z);

        var time = ClientTickCounter.total / 2;
        var bobSpeed = 1f / 20;
        var magnitude = 0.1f;
        ps.method_22904(0, class_3532.method_15374(bobSpeed * time) * magnitude, 0);
        var spinSpeed = 1f / 30;
        ps.method_22907(class_1158.method_35826(new class_1160(0, spinSpeed * time, 0)));
        if (sentinel.extendsRange()) {
            ps.method_22907(class_1158.method_35826(new class_1160(spinSpeed * time / 8f, 0, 0)));
        }

        float scale = 0.5f;
        ps.method_22905(scale, scale, scale);


        var tess = class_289.method_1348();
        var buf = tess.getBuilder();
        var neo = ps.method_23760().method_23761();
        RenderSystem.enableBlend();
        RenderSystem.setShader(class_757::method_34535);
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.lineWidth(5f);

        var colorizer = IXplatAbstractions.INSTANCE.getColorizer(owner);
        BiConsumer<float[], float[]> v = (l, r) -> {
            int lcolor = colorizer.getColor(time, new class_243(l[0], l[1], l[2])),
                rcolor = colorizer.getColor(time, new class_243(r[0], r[1], r[2]));
            var normal = new class_1160(r[0] - l[0], r[1] - l[1], r[2] - l[2]);
            normal.normalize();
            buf.vertex(neo, l[0], l[1], l[2])
                .color(lcolor)
                .normal(ps.method_23760().method_23762(), normal.x(), normal.y(), normal.z())
                .endVertex();
            buf.vertex(neo, r[0], r[1], r[2])
                .color(rcolor)
                .normal(ps.method_23760().method_23762(), -normal.x(), -normal.y(), -normal.z())
                .endVertex();
        };

        // Icosahedron inscribed inside the unit sphere
        buf.begin(class_293.class_5596.field_27377, class_290.field_29337);
        for (int side = 0; side <= 1; side++) {
            var ring = (side == 0) ? Icos.BOTTOM_RING : Icos.TOP_RING;
            var apex = (side == 0) ? Icos.BOTTOM : Icos.TOP;

            // top & bottom spider
            for (int i = 0; i < 5; i++) {
                v.accept(apex, ring[i]);
            }

            // ring around
            for (int i = 0; i < 5; i++) {
                v.accept(ring[i % 5], ring[(i + 1) % 5]);
            }
        }
        // center band
        for (int i = 0; i < 5; i++) {
            var bottom = Icos.BOTTOM_RING[i];
            v.accept(Icos.TOP_RING[(i + 2) % 5], bottom);
            v.accept(bottom, Icos.TOP_RING[(i + 3) % 5]);
        }
        tess.end();

        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        ps.method_22909();
    }

    private static class Icos {
        public static float[] TOP = {0, 1, 0};
        public static float[] BOTTOM = {0, -1, 0};
        public static float[][] TOP_RING = new float[5][];
        public static float[][] BOTTOM_RING = new float[5][];

        static {
            var theta = (float) class_3532.method_15349(0.5, 1);
            for (int i = 0; i < 5; i++) {
                var phi = (float) i / 5f * class_3532.field_29846;
                var x = class_3532.method_15362(theta) * class_3532.method_15362(phi);
                var y = class_3532.method_15374(theta);
                var z = class_3532.method_15362(theta) * class_3532.method_15374(phi);
                TOP_RING[i] = new float[]{x, y, z};
                BOTTOM_RING[i] = new float[]{-x, -y, -z};
            }
        }
    }

    private static void tryRenderScryingLensOverlay(class_4587 ps, float partialTicks) {
        var mc = class_310.method_1551();

        class_746 player = mc.player;
        class_638 level = mc.level;
        if (player == null || level == null) {
            return;
        }

        boolean foundLens = false;
        class_1268 lensHand = null;
        for (var hand : class_1268.values()) {
            if (player.method_5998(hand).is(HexItems.SCRYING_LENS)) {
                lensHand = hand;
                foundLens = true;
                break;
            }
        }
        if (!foundLens && player.method_6118(class_1304.field_6169).method_31574(HexItems.SCRYING_LENS)) {
            foundLens = true;
        }

        if (!foundLens) {
            return;
        }

        var hitRes = mc.hitResult;
        if (hitRes != null && hitRes.getType() == class_239.class_240.field_1332) {
            var bhr = (class_3965) hitRes;
            var pos = bhr.getBlockPos();
            var bs = level.method_8320(pos);

            var lines = ScryingLensOverlayRegistry.getLines(bs, pos, player, level, bhr.getDirection(), lensHand);

            int totalHeight = 8;
            List<Pair<class_1799, List<class_5348>>> actualLines = Lists.newArrayList();

            var window = mc.getWindow();
            var maxWidth = (int) (window.getGuiScaledWidth() / 2f * 0.8f);

            for (var pair : lines) {
                totalHeight += mc.font.lineHeight + 6;
                var text = pair.getSecond();
                var textLines = mc.font.getSplitter().splitLines(text, maxWidth, class_2583.field_24360);

                actualLines.add(Pair.of(pair.getFirst(), textLines));

                if (textLines.size() > 1) {
                    totalHeight += mc.font.lineHeight * (textLines.size() - 1);
                }
            }

            if (!lines.isEmpty()) {
                var x = window.getGuiScaledWidth() / 2f + 8f;
                var y = window.getGuiScaledHeight() / 2f - totalHeight;
                ps.method_22903();
                ps.method_22904(x, y, 0);

                for (var pair : actualLines) {
                    var stack = pair.getFirst();
                    if (!stack.isEmpty()) {
                        // this draws centered in the Y ...
                        RenderLib.renderItemStackInGui(ps, pair.getFirst(), 0, 0);
                    }
                    float tx = stack.isEmpty() ? 0 : 18;
                    float ty = 5;
                    // but this draws where y=0 is the baseline
                    var text = pair.getSecond();

                    for (var line : text) {
                        var actualLine = class_2477.method_10517().method_30934(line);
                        mc.font.drawShadow(ps, actualLine, tx, ty, 0xffffffff);
                        ps.method_22904(0, mc.font.lineHeight, 0);
                    }
                    if (text.isEmpty()) {
                        ps.method_22904(0, mc.font.lineHeight, 0);
                    }
                    ps.method_22904(0, 6, 0);
                }

                ps.method_22909();
            }
        }
    }
}
