package at.petrak.hexcasting.api.item;

import net.minecraft.class_1799;
import var;

public interface ManaHolderItem {
    int getMana(class_1799 stack);

    int getMaxMana(class_1799 stack);

    void setMana(class_1799 stack, int mana);

    boolean manaProvider(class_1799 stack);

    boolean canRecharge(class_1799 stack);

    default float getManaFullness(class_1799 stack) {
        int max = getMaxMana(stack);
		if (max == 0) {
			return 0;
		}
        return (float) getMana(stack) / (float) max;
    }

    default int withdrawMana(class_1799 stack, int cost, boolean simulate) {
        var manaHere = getMana(stack);
		if (cost < 0) {
			cost = manaHere;
		}
        if (!simulate) {
            var manaLeft = manaHere - cost;
            setMana(stack, manaLeft);
        }
        return Math.min(cost, manaHere);
    }
}
