package at.petrak.hexcasting.api.item;

import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.utils.NBTHelper;
import org.jetbrains.annotations.Nullable;
import var;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3218;

public interface DataHolderItem {
    String TAG_OVERRIDE_VISUALLY = "VisualOverride";

    @Nullable class_2487 readDatumTag(class_1799 stack);

    @Nullable
    default SpellDatum<?> readDatum(class_1799 stack, class_3218 world) {
        var tag = readDatumTag(stack);
        if (tag != null) {
            return SpellDatum.fromNBT(tag, world);
        } else {
            return null;
        }
    }

    @Nullable
    default SpellDatum<?> emptyDatum(class_1799 stack) {
        return null;
    }

    boolean canWrite(class_1799 stack, @Nullable SpellDatum<?> datum);

    void writeDatum(class_1799 stack, @Nullable SpellDatum<?> datum);

    static void appendHoverText(DataHolderItem self, class_1799 pStack, List<class_2561> pTooltipComponents,
                                class_1836 pIsAdvanced) {
        var datumTag = self.readDatumTag(pStack);
        if (datumTag != null) {
            var component = SpellDatum.displayFromNBT(datumTag);
            pTooltipComponents.add(new class_2588("hexcasting.spelldata.onitem", component));

            if (pIsAdvanced.method_8035()) {
                pTooltipComponents.add(new class_2585("").method_10852(class_2512.method_32270(datumTag)));
            }
        } else if (NBTHelper.hasString(pStack, DataHolderItem.TAG_OVERRIDE_VISUALLY)) {
            pTooltipComponents.add(new class_2588("hexcasting.spelldata.onitem",
                new class_2588("hexcasting.spelldata.anything").method_27692(class_124.field_1076)));

        }
    }
}
