package at.petrak.hexcasting.api.client;

import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import var;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.minecraft.class_746;

/**
 * Use this to make things display when the player looks at things with a Scrying Lens.
 * <p>
 * Client-side only.
 */
public final class ScryingLensOverlayRegistry {
    private static final ConcurrentMap<class_2960, OverlayBuilder> ID_LOOKUP = new ConcurrentHashMap<>();
    // vectors are thread-safe!
    private static final List<Pair<OverlayPredicate, OverlayBuilder>> PREDICATE_LOOKUP = new Vector<>();

    // implemented as a map to allow for weak dereferencing
    private static final Map<class_746, Pair<class_2338, Integer>> comparatorData = new WeakHashMap<>();

    public static void receiveComparatorValue(class_2338 pos, int value) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            if (pos == null || value == -1) {
                comparatorData.remove(player);
            } else {
                comparatorData.put(player, new Pair<>(pos, value));
            }
        }
    }

    public static int getComparatorValue(boolean onlyRealComparators) {
        var mc = class_310.method_1551();
        var player = mc.player;
        var level = mc.level;
        var result = mc.hitResult;

        if (player == null || level == null || result == null || result.getType() != class_239.class_240.field_1332) {
            return -1;
        }

        var comparatorValue = comparatorData.get(player);
        if (comparatorValue == null) {
            return -1;
        }

        var pos = ((class_3965) result).method_17777();
        if (!pos.equals(comparatorValue.getFirst())) {
            return -1;
        }

        var state = mc.level.getBlockState(pos);
        if ((onlyRealComparators && !state.is(
            class_2246.field_10377)) || (!onlyRealComparators && !state.hasAnalogOutputSignal())) {
            return -1;
        }

        return comparatorValue.getSecond();
    }

    /**
     * Add the block to display things when the player is holding a lens and looking at it.
     *
     * @throws IllegalArgumentException if the block is already registered.
     */
    public static void addDisplayer(class_2248 block, OverlayBuilder displayer) {
        addDisplayer(IXplatAbstractions.INSTANCE.getID(block), displayer);
    }

    /**
     * Add the block to display things when the player is holding a lens and looking at it.
     *
     * @throws IllegalArgumentException if the block ID is already registered.
     */
    public static void addDisplayer(class_2960 blockID, OverlayBuilder displayer) {
        if (ID_LOOKUP.containsKey(blockID)) {
            throw new IllegalArgumentException("Already have a displayer for " + blockID);
        }
        ID_LOOKUP.put(blockID, displayer);
    }

    /**
     * Display things when the player is holding a lens and looking at some block via a predicate.
     * <p>
     * These have a lower priority than the standard ID-based displays, so if an ID and predicate both match,
     * this won't be displayed.
     */
    public static void addPredicateDisplayer(OverlayPredicate predicate, OverlayBuilder displayer) {
        PREDICATE_LOOKUP.add(new Pair<>(predicate, displayer));
    }

    /**
     * Internal use only.
     */
    public static @NotNull List<Pair<class_1799, class_2561>> getLines(class_2680 state, class_2338 pos,
        class_746 observer, class_638 world,
        class_2350 hitFace, @Nullable class_1268 lensHand) {
        List<Pair<class_1799, class_2561>> lines = Lists.newArrayList();
        var idLookedup = ID_LOOKUP.get(IXplatAbstractions.INSTANCE.getID(state.method_26204()));
        if (idLookedup != null) {
            idLookedup.addLines(lines, state, pos, observer, world, hitFace, lensHand);
        }

        for (var pair : PREDICATE_LOOKUP) {
            if (pair.getFirst().test(state, pos, observer, world, hitFace, lensHand)) {
                pair.getSecond().addLines(lines, state, pos, observer, world, hitFace, lensHand);
            }
        }

        return lines;
    }

    /**
     * Return the lines displayed by the cursor: an item and some text.
     * <p>
     * The ItemStack can be empty; if it is, the text isn't shifted over for it.
     */
    @FunctionalInterface
    public interface OverlayBuilder {
        void addLines(List<Pair<class_1799, class_2561>> lines,
            class_2680 state, class_2338 pos, class_746 observer,
            class_638 world,
            class_2350 hitFace, @Nullable class_1268 lensHand);
    }

    /**
     * Predicate for matching on a block state.
     */
    @FunctionalInterface
    public interface OverlayPredicate {
        boolean test(class_2680 state, class_2338 pos, class_746 observer,
            class_638 world,
            class_2350 hitFace, @Nullable class_1268 lensHand);
    }
}
