package at.petrak.hexcasting.api.block.circle;

import at.petrak.hexcasting.api.block.HexBlockEntity;
import at.petrak.hexcasting.api.misc.FrozenColorizer;
import at.petrak.hexcasting.api.misc.ManaConstants;
import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.api.spell.ParticleSpray;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.casting.CastingContext;
import at.petrak.hexcasting.api.spell.casting.CastingHarness;
import at.petrak.hexcasting.api.spell.casting.SpellCircleContext;
import at.petrak.hexcasting.api.utils.ManaHelper;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.lib.HexSounds;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.mojang.datafixers.util.Pair;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import var;
import java.util.*;
import net.minecraft.class_1268;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_746;

public abstract class BlockEntityAbstractImpetus extends HexBlockEntity implements class_1278 {
    public static final String
        TAG_ACTIVATOR = "activator",
        TAG_COLORIZER = "colorizer",
        TAG_NEXT_BLOCK = "next_block",
        TAG_TRACKED_BLOCKS = "tracked_blocks",
        TAG_FOUND_ALL = "found_all",
        TAG_MANA = "mana",
        TAG_LAST_MISHAP = "last_mishap";

    @Nullable
    private UUID activator = null;
    @Nullable
    private FrozenColorizer colorizer = null;
    @Nullable
    private class_2338 nextBlock = null;
    @Nullable
    private List<class_2338> trackedBlocks = null;
    private transient Set<class_2338> knownBlocks = null;
    private boolean foundAll = false;
    @Nullable
    private class_2561 lastMishap = null;

    private int mana = 0;

    public BlockEntityAbstractImpetus(class_2591<?> pType, class_2338 pWorldPosition, class_2680 pBlockState) {
        super(pType, pWorldPosition, pBlockState);
    }

    abstract public boolean activatorAlwaysInRange();

    public int getMana() {
        return this.mana;
    }

    public void setMana(int mana) {
        this.mana = mana;
    }

    @Nullable
    public class_2561 getLastMishap() {
        return lastMishap;
    }

    public void setLastMishap(@Nullable class_2561 lastMishap) {
        this.lastMishap = lastMishap;
    }

    public void activateSpellCircle(class_3222 activator) {
        if (this.nextBlock != null) {
            return;
        }
        this.field_11863.method_39279(this.method_11016(), this.method_11010().method_26204(), this.getTickSpeed());

        this.activator = activator.method_5667();
        this.nextBlock = this.method_11016();
        this.trackedBlocks = new ArrayList<>();
        this.knownBlocks = new HashSet<>();
        this.colorizer = IXplatAbstractions.INSTANCE.getColorizer(activator);

        this.field_11863.method_8501(this.method_11016(),
            this.method_11010().method_11657(BlockAbstractImpetus.ENERGIZED, true));
        this.stepCircle();
    }

    public void applyScryingLensOverlay(List<Pair<class_1799, class_2561>> lines,
        class_2680 state, class_2338 pos,
        class_746 observer, class_638 world,
        class_2350 hitFace, class_1268 lensHand) {
        if (world.method_8321(pos) instanceof BlockEntityAbstractImpetus beai) {
            var dustCount = (float) beai.getMana() / (float) ManaConstants.DUST_UNIT;
            var dustCmp = new class_2588("hexcasting.tooltip.lens.impetus.mana",
                String.format("%.2f", dustCount));
            lines.add(new Pair<>(new class_1799(HexItems.AMETHYST_DUST), dustCmp));

            var mishap = this.getLastMishap();
            if (mishap != null) {
                lines.add(new Pair<>(new class_1799(class_1802.field_8731), mishap));
            }
        }
    }

    @Override
    protected void saveModData(class_2487 tag) {
        if (this.activator != null && this.colorizer != null && this.nextBlock != null && this.trackedBlocks != null) {
            tag.method_25927(TAG_ACTIVATOR, this.activator);
            tag.method_10566(TAG_NEXT_BLOCK, class_2512.method_10692(this.nextBlock));
            tag.method_10566(TAG_COLORIZER, this.colorizer.serializeToNBT());
            tag.method_10556(TAG_FOUND_ALL, this.foundAll);

            var trackeds = new class_2499();
            for (var tracked : this.trackedBlocks) {
                trackeds.add(class_2512.method_10692(tracked));
            }
            tag.method_10566(TAG_TRACKED_BLOCKS, trackeds);
        }

        tag.method_10569(TAG_MANA, this.mana);
        if (this.lastMishap != null) {
            tag.method_10582(TAG_LAST_MISHAP, class_2561.class_2562.method_10867(this.lastMishap));
        }
    }

    @Override
    protected void loadModData(class_2487 tag) {
        if (tag.method_10573(TAG_ACTIVATOR, class_2520.field_33261) &&
            tag.method_10573(TAG_COLORIZER, class_2520.field_33260) &&
            tag.method_10573(TAG_NEXT_BLOCK, class_2520.field_33260) &&
            tag.method_10573(TAG_TRACKED_BLOCKS, class_2520.field_33259)) {
            this.activator = tag.method_25926(TAG_ACTIVATOR);
            this.colorizer = FrozenColorizer.fromNBT(tag.method_10562(TAG_COLORIZER));
            this.nextBlock = class_2512.method_10691(tag.method_10562(TAG_NEXT_BLOCK));
            this.foundAll = tag.method_10577(TAG_FOUND_ALL);
            var trackeds = tag.method_10554(TAG_TRACKED_BLOCKS, class_2520.field_33260);
            this.trackedBlocks = new ArrayList<>(trackeds.size());
            this.knownBlocks = new HashSet<>();
            for (var tracked : trackeds) {
                var pos = class_2512.method_10691((class_2487) tracked);
                this.trackedBlocks.add(pos);
                this.knownBlocks.add(pos);
            }
        } else {
            this.activator = null;
            this.colorizer = null;
            this.nextBlock = null;
            this.foundAll = false;
            this.trackedBlocks = new ArrayList<>();
            this.knownBlocks = new HashSet<>();
        }

        this.mana = tag.method_10550(TAG_MANA);
        if (tag.method_10573(TAG_LAST_MISHAP, class_2520.field_33258)) {
            this.lastMishap = class_2561.class_2562.method_10877(tag.method_10558(TAG_LAST_MISHAP));
        } else {
            this.lastMishap = null;
        }
    }

    void stepCircle() {
        this.method_5431();

        // haha which silly idiot would have done something like this
        if (this.activator == null || this.colorizer == null || this.nextBlock == null || this.trackedBlocks == null) {
            return;
        }

        var possibleErrorPos = this.checkEverythingOk();
        if (possibleErrorPos != null) {
            this.sfx(possibleErrorPos, false);
            this.stopCasting();
            return;
        }

        if (this.foundAll) {
            this.clearEnergized();
            this.castSpell();
            this.stopCasting();
            return;
        }

        // This should only fail if we remove blocks halfway through casting
        var bsHere = this.field_11863.method_8320(this.nextBlock);
        if (!this.trackedBlocks.isEmpty() && bsHere.getBlock() instanceof BlockAbstractImpetus) {
            // no two impetuses!
            this.sfx(this.nextBlock, false);
            this.stopCasting();
            return;
        }
        var blockHere = bsHere.getBlock();
        if (!(blockHere instanceof BlockCircleComponent cc)) {
            this.sfx(this.nextBlock, false);
            this.stopCasting();
            return;
        }
        // Awesome we know this block is OK
        var thisNormal = cc.normalDir(this.nextBlock, bsHere, this.field_11863);
        var possibleExits = cc.exitDirections(this.nextBlock, bsHere, this.field_11863);
        class_2338 foundPos = null;
        for (var exit : possibleExits) {
            var neighborPos = this.nextBlock.method_10093(exit);
            var blockThere = this.field_11863.method_8320(neighborPos);
            // at this point, we haven't actually added nextBlock to trackedBlocks
            // so, in the smallest circle case (a 2x2), this will have a size of 3 (with this block being the 4th).
            var closedLoop = (this.trackedBlocks.size() >= 3 && this.trackedBlocks.get(0).equals(neighborPos));
            var mightBeOkThere = closedLoop
                || this.trackedBlocks.isEmpty()
                || !this.trackedBlocks.get(this.trackedBlocks.size() - 1).equals(neighborPos);
            if (mightBeOkThere
                && blockThere.getBlock() instanceof BlockCircleComponent cc2
                && cc2.canEnterFromDirection(exit.getOpposite(), thisNormal, neighborPos, blockThere, this.field_11863)
                // another good use for the implies operator 😩
                && (!blockThere.getValue(BlockCircleComponent.ENERGIZED) || this.knownBlocks.contains(neighborPos))) {
                if (foundPos == null) {
                    foundPos = neighborPos;
                    this.foundAll |= closedLoop;
                } else {
                    // uh oh, fork in the road
                    this.sfx(this.nextBlock, false);
                    this.stopCasting();
                    return;
                }
            }
        }
        if (foundPos != null) {
            // pog
            this.trackedBlocks.add(this.nextBlock);
            this.knownBlocks.add(this.nextBlock);
            this.nextBlock = foundPos;
        } else {
            // end of the line
            this.sfx(this.nextBlock, false);
            this.stopCasting();
            return;
        }

        var lastPos = this.trackedBlocks.get(this.trackedBlocks.size() - 1);
        var justTrackedBlock = this.field_11863.method_8320(lastPos);
        this.field_11863.method_8501(lastPos, justTrackedBlock.setValue(BlockCircleComponent.ENERGIZED, true));
        this.sfx(lastPos, true);

        this.field_11863.method_39279(this.method_11016(), this.method_11010().method_26204(), this.getTickSpeed());
    }

    private void castSpell() {
        var player = this.getPlayer();

        if (player instanceof class_3222 splayer) {
            var bounds = getBounds(this.trackedBlocks);

            var ctx = new CastingContext(splayer, class_1268.field_5808,
                new SpellCircleContext(this.method_11016(), bounds, this.activatorAlwaysInRange()));
            var harness = new CastingHarness(ctx);

            var makeSound = false;
            class_2338 erroredPos = null;
            for (var tracked : this.trackedBlocks) {
                var bs = this.field_11863.method_8320(tracked);
                if (bs.getBlock() instanceof BlockCircleComponent cc) {
                    var newPattern = cc.getPattern(tracked, bs, this.field_11863);
                    if (newPattern != null) {
                        var info = harness.executeIota(SpellDatum.make(newPattern), splayer.method_14220());
                        if (info.getMakesCastSound()) {
                            makeSound = true;
                        }
                        if (!info.getResolutionType().getSuccess()) {
                            erroredPos = tracked;
                            break;
                        }
                    }
                }
            }

            if (makeSound) {
                this.field_11863.method_8396(null, this.method_11016(), HexSounds.SPELL_CIRCLE_CAST, class_3419.field_15245,
                    2f, 1f);
            }

            if (erroredPos != null) {
                this.sfx(erroredPos, false);
            } else {
                this.setLastMishap(null);
            }

            this.method_5431();
        }
    }

    @Contract(pure = true)
    private static class_238 getBounds(List<class_2338> poses) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;

        for (var pos : poses) {
            if (pos.getX() < minX) {
                minX = pos.getX();
            }
            if (pos.getY() < minY) {
                minY = pos.getY();
            }
            if (pos.getZ() < minZ) {
                minZ = pos.getZ();
            }
            if (pos.getX() > maxX) {
                maxX = pos.getX();
            }
            if (pos.getY() > maxY) {
                maxY = pos.getY();
            }
            if (pos.getZ() > maxZ) {
                maxZ = pos.getZ();
            }
        }

        return new class_238(minX, minY, minZ, maxX + 1, maxY + 1, maxZ + 1);
    }

    @Nullable
    private class_2338 checkEverythingOk() {
        // if they logged out or changed dimensions or something
        if (this.getPlayer() == null) {
            return this.method_11016();
        }

        for (var pos : this.trackedBlocks) {
            if (!(this.field_11863.method_8320(pos).getBlock() instanceof BlockCircleComponent)) {
                return pos;
            }
        }

        if (this.trackedBlocks.size() > HexConfig.server().maxSpellCircleLength()) {
            return this.trackedBlocks.get(this.trackedBlocks.size() - 1);
        }

        return null;
    }

    private void sfx(class_2338 pos, boolean success) {
        class_243 vpos;
        class_243 vecOutDir;

        var bs = this.field_11863.method_8320(pos);
        if (bs.getBlock() instanceof BlockCircleComponent bcc) {
            var outDir = bcc.normalDir(pos, bs, this.field_11863);
            var height = bcc.particleHeight(pos, bs, this.field_11863);
            vecOutDir = new class_243(outDir.step());
            vpos = class_243.method_24953(pos).method_1019(vecOutDir.method_1021(height));
        } else {
            // we probably are doing this because it's an error and we removed a block
            vpos = class_243.method_24953(pos);
            vecOutDir = new class_243(0, 0, 0);
        }

        if (this.field_11863 instanceof class_3218 serverLevel) {
            var spray = new ParticleSpray(vpos, vecOutDir.method_1021(success ? 1.0 : 1.5), success ? 0.1 : 0.5,
                class_3532.field_29844 / (success ? 4 : 2), success ? 30 : 100);
            spray.sprayParticles(serverLevel,
                success ? this.colorizer : new FrozenColorizer(new class_1799(HexItems.DYE_COLORIZERS.get(class_1767.field_7964)),
                    this.activator));
        }

        var pitch = 1f;
        var sound = HexSounds.SPELL_CIRCLE_FAIL;
        if (success) {
            sound = HexSounds.SPELL_CIRCLE_FIND_BLOCK;
            // This is a good use of my time
            var note = this.trackedBlocks.size() - 1;
            var semitone = this.semitoneFromScale(note);
            pitch = (float) Math.pow(2.0, (semitone - 8) / 12d);
        }
        field_11863.method_8465(null, vpos.field_1352, vpos.field_1351, vpos.field_1350, sound, class_3419.field_15245, 1f, pitch);
    }

    protected void clearEnergized() {
        if (this.trackedBlocks != null) {
            for (var tracked : this.trackedBlocks) {
                var bs = this.field_11863.method_8320(tracked);
                if (bs.getBlock() instanceof BlockCircleComponent) {
                    this.field_11863.method_8501(tracked, bs.setValue(BlockCircleComponent.ENERGIZED, false));
                }
            }
        }
    }

    protected void stopCasting() {
        clearEnergized();

        this.activator = null;
        this.nextBlock = null;
        this.trackedBlocks = null;
        this.foundAll = false;

        // without this check, breaking the block will just immediately replace it with
        // the new unenergized state
        if (this.field_11863.method_8320(this.method_11016()).method_26204() instanceof BlockAbstractImpetus) {
            this.field_11863.method_8501(this.method_11016(),
                this.method_11010().method_11657(BlockCircleComponent.ENERGIZED, false));
        }
    }

    @Nullable
    protected class_1657 getPlayer() {
        return this.field_11863.method_18470(this.activator);
    }

    protected int getTickSpeed() {
        if (this.trackedBlocks == null) {
            return 10;
        } else {
            return Math.max(2, 10 - trackedBlocks.size() / 3);
        }
    }

    protected int semitoneFromScale(int note) {
        var blockBelow = this.field_11863.method_8320(this.method_11016().method_10074());
        var scale = MAJOR_SCALE;
        if (blockBelow.is(class_2246.field_22423)) {
            scale = MINOR_SCALE;
        } else if (blockBelow.is(class_3481.field_15495) || blockBelow.is(class_3481.field_15487)) {
            scale = DORIAN_SCALE;
        } else if (blockBelow.is(class_2246.field_10560) || blockBelow.is(class_2246.field_10615)) {
            scale = MIXOLYDIAN_SCALE;
        } else if (blockBelow.is(class_2246.field_10514)
            || blockBelow.is(class_2246.field_10011) || blockBelow.is(class_2246.field_10456)
            || blockBelow.is(class_2246.field_10409) || blockBelow.is(class_2246.field_10550)
            || blockBelow.is(class_2246.field_10060) || blockBelow.is(class_2246.field_9982)) {
            scale = BLUES_SCALE;
        } else if (blockBelow.is(class_2246.field_10166)) {
            scale = BAD_TIME;
        } else if (blockBelow.is(class_2246.field_17563)) {
            scale = SUSSY_BAKA;
        }

        note = class_3532.method_15340(note, 0, scale.length - 1);
        return scale[note];
    }

    // this is a good use of my time
    private static final int[] MAJOR_SCALE = {0, 2, 4, 5, 7, 9, 11, 12};
    private static final int[] MINOR_SCALE = {0, 2, 3, 5, 7, 8, 11, 12};
    private static final int[] DORIAN_SCALE = {0, 2, 3, 5, 7, 9, 10, 12};
    private static final int[] MIXOLYDIAN_SCALE = {0, 2, 4, 5, 7, 9, 10, 12};
    private static final int[] BLUES_SCALE = {0, 3, 5, 6, 7, 10, 12};
    private static final int[] BAD_TIME = {0, 0, 12, 7, 6, 5, 3, 0, 3, 5};
    private static final int[] SUSSY_BAKA = {5, 8, 10, 11, 10, 8, 5, 3, 7, 5};

    private static final int[] SLOTS = {0};

    @Override
    public int[] method_5494(class_2350 var1) {
        return SLOTS;
    }

    @Override
    public boolean method_5492(int index, class_1799 stack, @Nullable class_2350 dir) {
        return this.method_5437(index, stack);
    }

    @Override
    public boolean method_5493(int var1, class_1799 var2, class_2350 var3) {
        return false;
    }

    @Override
    public int method_5439() {
        return 1;
    }

    @Override
    public boolean method_5442() {
        return true;
    }

    @Override
    public class_1799 method_5438(int index) {
        return class_1799.field_8037.method_7972();
    }

    @Override
    public class_1799 method_5434(int index, int count) {
        return class_1799.field_8037.method_7972();
    }

    @Override
    public class_1799 method_5441(int index) {
        return class_1799.field_8037.method_7972();

    }

    @Override
    public void method_5447(int index, class_1799 stack) {
        var manamount = ManaHelper.extractMana(stack, -1, true, false);
        if (manamount > 0) {
            this.mana += manamount;
            this.sync();
        }
    }

    @Override
    public boolean method_5443(class_1657 player) {
        return false;
    }

    @Override
    public boolean method_5437(int index, class_1799 stack) {
        var manamount = ManaHelper.extractMana(stack, -1, true, true);
        return manamount > 0;
    }

    @Override
    public void method_5448() {
        this.mana = 0;
        this.stopCasting();
        this.sync();
    }
}
