package at.petrak.hexcasting.api.block.circle;

import at.petrak.hexcasting.api.spell.math.HexPattern;
import org.jetbrains.annotations.Nullable;
import var;
import java.util.EnumSet;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;

public abstract class BlockCircleComponent extends class_2248 {
    public static final class_2746 ENERGIZED = class_2746.method_11825("energized");

    public BlockCircleComponent(class_2251 p_49795_) {
        super(p_49795_);
    }

    /**
     * Can this component get transferred to from a block coming in from that direction, with the given normal?
     */
    abstract public boolean canEnterFromDirection(class_2350 enterDir, class_2350 normalDir, class_2338 pos,
        class_2680 bs, class_1937 world);

    abstract public EnumSet<class_2350> exitDirections(class_2338 pos, class_2680 bs, class_1937 world);

    @Nullable
    abstract public HexPattern getPattern(class_2338 pos, class_2680 bs, class_1937 world);

    /**
     * Which direction points "up" or "out" for this block?
     * This is used for {@link BlockCircleComponent#canEnterFromDirection(class_2350, class_2350, class_2338, class_2680, class_1937)}
     * as well as particles.
     */
    public class_2350 normalDir(class_2338 pos, class_2680 bs, class_1937 world) {
        return normalDir(pos, bs, world, 16);
    }

    abstract public class_2350 normalDir(class_2338 pos, class_2680 bs, class_1937 world, int recursionLeft);

    public static class_2350 normalDirOfOther(class_2338 other, class_1937 world, int recursionLeft) {
        if (recursionLeft <= 0) {
            return class_2350.field_11036;
        }

        var stateThere = world.method_8320(other);
        if (stateThere.getBlock() instanceof BlockCircleComponent bcc) {
            return bcc.normalDir(other, stateThere, world, recursionLeft - 1);
        } else {
            return class_2350.field_11036;
        }
    }

    /**
     * How many blocks in the {@link BlockCircleComponent#normalDir(class_2338, class_2680, class_1937)} from the center
     * particles should be spawned in
     */
    abstract public float particleHeight(class_2338 pos, class_2680 bs, class_1937 world);

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        pBuilder.method_11667(ENERGIZED);
    }

    @Override
    public boolean method_9498(class_2680 pState) {
        return true;
    }

    @Override
    public int method_9572(class_2680 pState, class_1937 pLevel, class_2338 pPos) {
        return pState.method_11654(ENERGIZED) ? 15 : 0;
    }
}
