package at.petrak.hexcasting.api.block.circle;

import at.petrak.hexcasting.api.spell.math.HexPattern;
import org.jetbrains.annotations.Nullable;

import java.util.EnumSet;
import java.util.Random;
import net.minecraft.class_1750;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_3218;

// Facing dir is the direction it starts searching for slates in to start
public abstract class BlockAbstractImpetus extends BlockCircleComponent implements class_2343 {
    public static final class_2753 FACING = class_2741.field_12525;

    public BlockAbstractImpetus(class_2251 p_49795_) {
        super(p_49795_);
        this.method_9590(
            this.field_10647.method_11664().method_11657(ENERGIZED, false).method_11657(FACING, class_2350.field_11043));
    }

    @Override
    public boolean canEnterFromDirection(class_2350 enterDir, class_2350 normalDir, class_2338 pos, class_2680 bs,
        class_1937 world) {
        return enterDir != bs.method_11654(FACING);
    }

    @Override
    public EnumSet<class_2350> exitDirections(class_2338 pos, class_2680 bs, class_1937 world) {
        return EnumSet.of(bs.method_11654(FACING));
    }

    @Override
    public @Nullable HexPattern getPattern(class_2338 pos, class_2680 bs, class_1937 world) {
        return null;
    }

    @Override
    public class_2350 normalDir(class_2338 pos, class_2680 bs, class_1937 world, int recursionLeft) {
        return normalDirOfOther(pos.method_10093(bs.method_11654(FACING)), world, recursionLeft);
    }

    @Override
    public float particleHeight(class_2338 pos, class_2680 bs, class_1937 world) {
        return 0.5f;
    }

    @Override
    public void method_9588(class_2680 pState, class_3218 pLevel, class_2338 pPos, Random pRandom) {
        if (pLevel.method_8321(pPos) instanceof BlockEntityAbstractImpetus tile && pState.method_11654(ENERGIZED)) {
            tile.stepCircle();
        }
    }

    @Override
    public void method_9536(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2680 pNewState, boolean pIsMoving) {
        if (!pNewState.method_27852(pState.method_26204())
            && pLevel.method_8321(pPos) instanceof BlockEntityAbstractImpetus impetus) {
            impetus.stopCasting();
        }
        super.method_9536(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(FACING);
    }

    @Override
    public class_2680 method_9605(class_1750 pContext) {
        return this.method_9564().method_11657(FACING, pContext.method_7715());
    }

    @Override
    public class_2680 method_9598(class_2680 pState, class_2470 pRot) {
        return pState.method_11657(FACING, pRot.method_10503(pState.method_11654(FACING)));
    }

    @Override
    public class_2680 method_9569(class_2680 pState, class_2415 pMirror) {
        return pState.method_26186(pMirror.method_10345(pState.method_11654(FACING)));
    }
}
