package at.petrak.hexcasting.api.advancements;

import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.*;
import net.minecraft.class_195;
import net.minecraft.class_2048;
import net.minecraft.class_2096;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5257;
import net.minecraft.class_5267;

public class SpendManaTrigger extends class_4558<SpendManaTrigger.Instance> {
    private static final class_2960 ID = new class_2960("hexcasting", "spend_mana");

    private static final String TAG_MANA_SPENT = "mana_spent";
    private static final String TAG_MANA_WASTED = "mana_wasted";

    @Override
    public class_2960 method_794() {
        return ID;
    }

    @Override
    protected Instance method_27854(JsonObject json, class_2048.class_5258 predicate,
        class_5257 pContext) {
        return new Instance(predicate,
            class_2096.class_2100.method_9056(json.get(TAG_MANA_SPENT)),
            class_2096.class_2100.method_9056(json.get(TAG_MANA_WASTED)));
    }

    public void trigger(class_3222 player, int manaSpent, int manaWasted) {
        super.method_22510(player, inst -> inst.test(manaSpent, manaWasted));
    }

    public static class Instance extends class_195 {
        protected final class_2096.class_2100 manaSpent;
        protected final class_2096.class_2100 manaWasted;

        public Instance(class_2048.class_5258 predicate, class_2096.class_2100 manaSpent,
            class_2096.class_2100 manaWasted) {
            super(SpendManaTrigger.ID, predicate);
            this.manaSpent = manaSpent;
            this.manaWasted = manaWasted;
        }

        @Override
        public class_2960 method_806() {
            return ID;
        }

        @Override
        public JsonObject method_807(class_5267 ctx) {
            JsonObject json = super.method_807(ctx);
            if (!this.manaSpent.method_9041()) {
                json.add(TAG_MANA_SPENT, this.manaSpent.method_9036());
            }
            if (!this.manaWasted.method_9041()) {
                json.add(TAG_MANA_WASTED, this.manaWasted.method_9036());
            }
            return json;
        }

        private boolean test(int manaSpentIn, int manaWastedIn) {
            return this.manaSpent.method_9054(manaSpentIn) && this.manaWasted.method_9054(manaWastedIn);
        }
    }
}
