package at.petrak.hexcasting.api.advancements;

import at.petrak.hexcasting.api.mod.HexConfig;
import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.*;
import net.minecraft.class_195;
import net.minecraft.class_2048;
import net.minecraft.class_2096;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5257;
import net.minecraft.class_5267;
import var;

// https://github.com/TelepathicGrunt/Bumblezone/blob/latest-released/src/main/java/com/telepathicgrunt/the_bumblezone/advancements/CleanupStickyHoneyResidueTrigger.java
// https://github.com/VazkiiMods/Botania/blob/b8706e2e0bba20f67f1e103559a4ce39d63d48f9/src/main/java/vazkii/botania/common/advancements/CorporeaRequestTrigger.java

public class OvercastTrigger extends class_4558<OvercastTrigger.Instance> {
    private static final class_2960 ID = new class_2960("hexcasting", "overcast");

    private static final String TAG_MANA_GENERATED = "mana_generated";
    private static final String TAG_HEALTH_USED = "health_used";
    // HEY KIDS DID YOYU KNOW THERE'S NOT A CRITERIA FOR HOW MUCH ***HEALTH*** AN ENTITY HAS
    private static final String TAG_HEALTH_LEFT = "mojang_i_am_begging_and_crying_please_add_an_entity_health_criterion";

    @Override
    public class_2960 method_794() {
        return ID;
    }

    @Override
    protected Instance method_27854(JsonObject json, class_2048.class_5258 predicate,
        class_5257 pContext) {
        return new Instance(predicate,
            class_2096.class_2100.method_9056(json.get(TAG_MANA_GENERATED)),
            class_2096.class_2099.method_9051(json.get(TAG_HEALTH_USED)),
            class_2096.class_2099.method_9051(json.get(TAG_HEALTH_LEFT)));
    }

    public void trigger(class_3222 player, int manaGenerated) {
        super.method_22510(player, inst -> {
            var manaToHealth = HexConfig.common().manaToHealthRate();
            var healthUsed = manaGenerated / manaToHealth;
            return inst.test(manaGenerated, healthUsed / player.method_6063(), player.method_6032() - (float) healthUsed);
        });
    }

    public static class Instance extends class_195 {
        protected final class_2096.class_2100 manaGenerated;
        protected final class_2096.class_2099 healthUsed;
        // DID YOU KNOW THERES ONE TO CHECK THE WORLD TIME, BUT NOT THE HEALTH!?
        protected final class_2096.class_2099 healthLeft;

        public Instance(class_2048.class_5258 predicate, class_2096.class_2100 manaGenerated,
            class_2096.class_2099 healthUsed, class_2096.class_2099 healthLeft) {
            super(OvercastTrigger.ID, predicate);
            this.manaGenerated = manaGenerated;
            this.healthUsed = healthUsed;
            // DID YOU KNOW THERE'S ONE TO CHECK THE FUCKING C A T T Y P E BUT NOT THE HEALTH
            this.healthLeft = healthLeft;
        }

        @Override
        public class_2960 method_806() {
            return ID;
        }

        @Override
        public JsonObject method_807(class_5267 ctx) {
            JsonObject json = super.method_807(ctx);
            if (!this.manaGenerated.method_9041()) {
                json.add(TAG_MANA_GENERATED, this.manaGenerated.method_9036());
            }
            if (!this.healthUsed.method_9041()) {
                json.add(TAG_HEALTH_USED, this.healthUsed.method_9036());
            }
            if (!this.healthLeft.method_9041()) {
                json.add(TAG_HEALTH_LEFT, this.healthLeft.method_9036());
            }
            return json;
        }

        private boolean test(int manaGeneratedIn, double healthUsedIn, float healthLeftIn) {
            return this.manaGenerated.method_9054(manaGeneratedIn)
                && this.healthUsed.method_9047(healthUsedIn)
                // DID YOU KNOW ALL THE ENEITYT PREDICATES ARE HARD-CODED AND YOU CANT MAKE NEW ONES
                && this.healthLeft.method_9047(healthLeftIn);
        }
    }
}
