package at.petrak.hexcasting.api.addldata;

import at.petrak.hexcasting.api.spell.SpellDatum;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import var;

public interface DataHolder {
    @Nullable
    class_2487 readRawDatum();

    @Nullable
    default SpellDatum<?> readDatum(class_3218 world) {
        var tag = readRawDatum();
        if (tag != null) {
            return SpellDatum.fromNBT(tag, world);
        } else {
            return null;
        }
    }

    @Nullable
    default SpellDatum<?> emptyDatum() {
        return null;
    }

    boolean writeDatum(@Nullable SpellDatum<?> datum, boolean simulate);
}
