package at.petrak.hexcasting.api.addldata;

import java.util.UUID;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5253;
import var;

public interface Colorizer {
    int color(UUID owner, float time, class_243 position);

    static int morphBetweenColors(int[] colors, class_243 gradientDir, float time, class_243 position) {
        float fIdx = class_3532.method_15341(time + (float) gradientDir.method_1026(position), 1f) * colors.length;

        int baseIdx = class_3532.method_15375(fIdx);
        float tRaw = fIdx - baseIdx;
        float t = tRaw < 0.5 ? 4 * tRaw * tRaw * tRaw : (float) (1 - Math.pow(-2 * tRaw + 2, 3) / 2);
        int start = colors[baseIdx % colors.length];
        int end = colors[(baseIdx + 1) % colors.length];

        var r1 = class_5253.class_5254.method_27765(start);
        var g1 = class_5253.class_5254.method_27766(start);
        var b1 = class_5253.class_5254.method_27767(start);
        var a1 = class_5253.class_5254.method_27762(start);
        var r2 = class_5253.class_5254.method_27765(end);
        var g2 = class_5253.class_5254.method_27766(end);
        var b2 = class_5253.class_5254.method_27767(end);
        var a2 = class_5253.class_5254.method_27762(end);

        var r = class_3532.method_16439(t, r1, r2);
        var g = class_3532.method_16439(t, g1, g2);
        var b = class_3532.method_16439(t, b1, b2);
        var a = class_3532.method_16439(t, a1, a2);

        return class_5253.class_5254.method_27764((int) a, (int) r, (int) g, (int) b);
    }
}
