/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.mixin;

import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.loot.AddPerWorldPatternToScrollFunc;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WanderingTrader.class})
public class MixinWanderingTrader {
    @Inject(method={"updateTrades"}, at={@At(value="RETURN")})
    private void addNewTrades(CallbackInfo ci) {
        WanderingTrader self = (WanderingTrader)this;
        MerchantOffers offerList = self.getOffers();
        if (offerList == null) {
            return;
        }
        RandomSource rand = self.getRandom();
        if ((double)rand.nextFloat() < HexConfig.server().traderScrollChance() && self.getServer() != null) {
            ItemStack scroll = new ItemStack((ItemLike)HexItems.SCROLL_LARGE);
            AddPerWorldPatternToScrollFunc.doStatic(scroll, rand, self.getServer().overworld());
            NBTHelper.putBoolean(scroll, "needs_purchase", true);
            offerList.set(5, (Object)new MerchantOffer(new ItemStack((ItemLike)Items.EMERALD, 12), scroll, 1, 1, 1.0f));
        }
    }
}

