/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.datagen.recipe;

import at.petrak.hexcasting.api.advancements.OvercastTrigger;
import at.petrak.hexcasting.api.mod.HexTags;
import at.petrak.hexcasting.common.blocks.decoration.BlockAkashicLog;
import at.petrak.hexcasting.common.items.ItemStaff;
import at.petrak.hexcasting.common.items.pigment.ItemDyePigment;
import at.petrak.hexcasting.common.items.pigment.ItemPridePigment;
import at.petrak.hexcasting.common.lib.HexBlocks;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.recipe.SealThingsRecipe;
import at.petrak.hexcasting.common.recipe.ingredient.StateIngredientHelper;
import at.petrak.hexcasting.common.recipe.ingredient.brainsweep.EntityTypeIngredient;
import at.petrak.hexcasting.common.recipe.ingredient.brainsweep.VillagerIngredient;
import at.petrak.hexcasting.datagen.HexAdvancements;
import at.petrak.hexcasting.datagen.IXplatConditionsBuilder;
import at.petrak.hexcasting.datagen.IXplatIngredients;
import at.petrak.hexcasting.datagen.recipe.builders.BrainsweepRecipeBuilder;
import at.petrak.hexcasting.datagen.recipe.builders.CompatIngredientValue;
import at.petrak.hexcasting.datagen.recipe.builders.CreateCrushingRecipeBuilder;
import at.petrak.hexcasting.datagen.recipe.builders.FarmersDelightCuttingRecipeBuilder;
import at.petrak.paucal.api.datagen.PaucalRecipeProvider;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class HexplatRecipes
extends PaucalRecipeProvider {
    private final IXplatIngredients ingredients;
    private final Function<RecipeBuilder, IXplatConditionsBuilder> conditions;
    private final List<BlockAkashicLog> EDIFIED_LOGS = List.of(HexBlocks.EDIFIED_LOG, HexBlocks.EDIFIED_LOG_AMETHYST, HexBlocks.EDIFIED_LOG_AVENTURINE, HexBlocks.EDIFIED_LOG_CITRINE, HexBlocks.EDIFIED_LOG_PURPLE);
    private final Map<BlockAkashicLog, BlockAkashicLog> EDIFIED_LOG_TO_WOOD = Map.ofEntries(Map.entry(HexBlocks.EDIFIED_LOG, HexBlocks.EDIFIED_WOOD), Map.entry(HexBlocks.STRIPPED_EDIFIED_LOG, HexBlocks.STRIPPED_EDIFIED_WOOD));

    public HexplatRecipes(PackOutput output, IXplatIngredients ingredients, Function<RecipeBuilder, IXplatConditionsBuilder> conditions) {
        super(output, "hexcasting");
        this.ingredients = ingredients;
        this.conditions = conditions;
    }

    public void buildRecipes(Consumer<FinishedRecipe> recipes) {
        this.specialRecipe(recipes, SealThingsRecipe.FOCUS_SERIALIZER);
        this.specialRecipe(recipes, SealThingsRecipe.SPELLBOOK_SERIALIZER);
        this.staffRecipe(recipes, HexItems.STAFF_OAK, Items.OAK_PLANKS);
        this.staffRecipe(recipes, HexItems.STAFF_BIRCH, Items.BIRCH_PLANKS);
        this.staffRecipe(recipes, HexItems.STAFF_SPRUCE, Items.SPRUCE_PLANKS);
        this.staffRecipe(recipes, HexItems.STAFF_JUNGLE, Items.JUNGLE_PLANKS);
        this.staffRecipe(recipes, HexItems.STAFF_DARK_OAK, Items.DARK_OAK_PLANKS);
        this.staffRecipe(recipes, HexItems.STAFF_ACACIA, Items.ACACIA_PLANKS);
        this.staffRecipe(recipes, HexItems.STAFF_CRIMSON, Items.CRIMSON_PLANKS);
        this.staffRecipe(recipes, HexItems.STAFF_WARPED, Items.WARPED_PLANKS);
        this.staffRecipe(recipes, HexItems.STAFF_MANGROVE, Items.MANGROVE_PLANKS);
        this.staffRecipe(recipes, HexItems.STAFF_CHERRY, Items.CHERRY_PLANKS);
        this.staffRecipe(recipes, HexItems.STAFF_BAMBOO, Items.BAMBOO_PLANKS);
        this.staffRecipe(recipes, HexItems.STAFF_EDIFIED, HexBlocks.EDIFIED_PLANKS.asItem());
        this.staffRecipe(recipes, HexItems.STAFF_QUENCHED, HexItems.QUENCHED_SHARD);
        this.staffRecipe(recipes, HexItems.STAFF_MINDSPLICE, Ingredient.of(HexTags.Items.MINDFLAYED_CIRCLE_COMPONENTS));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)HexItems.THOUGHT_KNOT).requires((ItemLike)HexItems.AMETHYST_DUST).requires((ItemLike)Items.STRING).unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem(HexTags.Items.STAVES)).save(recipes);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)HexItems.FOCUS).define(Character.valueOf('G'), this.ingredients.glowstoneDust()).define(Character.valueOf('L'), this.ingredients.leather()).define(Character.valueOf('P'), (ItemLike)Items.PAPER).define(Character.valueOf('A'), (ItemLike)HexItems.CHARGED_AMETHYST).pattern("GLG").pattern("PAP").pattern("GLG").unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem(HexTags.Items.STAVES)).save(recipes);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)HexItems.FOCUS).define(Character.valueOf('G'), this.ingredients.glowstoneDust()).define(Character.valueOf('L'), this.ingredients.leather()).define(Character.valueOf('P'), (ItemLike)Items.PAPER).define(Character.valueOf('A'), (ItemLike)HexItems.CHARGED_AMETHYST).pattern("GPG").pattern("LAL").pattern("GPG").unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem(HexTags.Items.STAVES)).save(recipes, this.modLoc("focus_rotated"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)HexItems.SPELLBOOK).define(Character.valueOf('N'), this.ingredients.goldNugget()).define(Character.valueOf('B'), (ItemLike)Items.WRITABLE_BOOK).define(Character.valueOf('A'), (ItemLike)HexItems.CHARGED_AMETHYST).define(Character.valueOf('F'), (ItemLike)Items.CHORUS_FRUIT).pattern("NBA").pattern("NFA").pattern("NBA").unlockedBy("has_focus", (CriterionTriggerInstance)HexplatRecipes.hasItem((ItemLike)HexItems.FOCUS)).unlockedBy("has_chorus", (CriterionTriggerInstance)HexplatRecipes.hasItem((ItemLike)Items.CHORUS_FRUIT)).save(recipes);
        this.ringCornerless(RecipeCategory.TOOLS, (ItemLike)HexItems.CYPHER, 1, this.ingredients.copperIngot(), Ingredient.of((ItemLike[])new ItemLike[]{HexItems.AMETHYST_DUST})).unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem(HexTags.Items.STAVES)).save(recipes);
        this.ringCornerless(RecipeCategory.TOOLS, (ItemLike)HexItems.TRINKET, 1, this.ingredients.ironIngot(), Ingredient.of((ItemLike[])new ItemLike[]{Items.AMETHYST_SHARD})).unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem(HexTags.Items.STAVES)).save(recipes);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)HexItems.ARTIFACT).define(Character.valueOf('F'), this.ingredients.goldIngot()).define(Character.valueOf('A'), (ItemLike)HexItems.CHARGED_AMETHYST).define(Character.valueOf('D'), ItemTags.MUSIC_DISCS).pattern(" F ").pattern("FAF").pattern(" D ").unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem(HexTags.Items.STAVES)).save(recipes);
        this.ringCornerless(RecipeCategory.TOOLS, (ItemLike)HexItems.SCRYING_LENS, 1, (ItemLike)Items.GLASS, (ItemLike)HexItems.AMETHYST_DUST).unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem(HexTags.Items.STAVES)).save(recipes);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)HexItems.ABACUS).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('A'), (ItemLike)Items.AMETHYST_SHARD).define(Character.valueOf('W'), ItemTags.PLANKS).pattern("WAW").pattern("SAS").pattern("WAW").unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem(HexTags.Items.STAVES)).save(recipes);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)HexItems.SUBMARINE_SANDWICH).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('A'), (ItemLike)Items.AMETHYST_SHARD).define(Character.valueOf('C'), (ItemLike)Items.COOKED_BEEF).define(Character.valueOf('B'), (ItemLike)Items.BREAD).pattern(" SA").pattern(" C ").pattern(" B ").unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem((ItemLike)Items.AMETHYST_SHARD)).save(recipes);
        for (DyeColor dye : DyeColor.values()) {
            ItemDyePigment item = HexItems.DYE_PIGMENTS.get(dye);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)item).define(Character.valueOf('D'), (ItemLike)HexItems.AMETHYST_DUST).define(Character.valueOf('C'), (ItemLike)DyeItem.byColor((DyeColor)dye)).pattern(" D ").pattern("DCD").pattern(" D ").unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem((ItemLike)HexItems.AMETHYST_DUST)).save(recipes);
        }
        this.gayRecipe(recipes, ItemPridePigment.Type.AGENDER, Ingredient.of((ItemLike[])new ItemLike[]{Items.GLASS}));
        this.gayRecipe(recipes, ItemPridePigment.Type.AROACE, Ingredient.of((ItemLike[])new ItemLike[]{Items.WHEAT_SEEDS}));
        this.gayRecipe(recipes, ItemPridePigment.Type.AROMANTIC, Ingredient.of((ItemLike[])new ItemLike[]{Items.ARROW}));
        this.gayRecipe(recipes, ItemPridePigment.Type.ASEXUAL, Ingredient.of((ItemLike[])new ItemLike[]{Items.BREAD}));
        this.gayRecipe(recipes, ItemPridePigment.Type.BISEXUAL, Ingredient.of((ItemLike[])new ItemLike[]{Items.WHEAT}));
        this.gayRecipe(recipes, ItemPridePigment.Type.DEMIBOY, Ingredient.of((ItemLike[])new ItemLike[]{Items.RAW_IRON}));
        this.gayRecipe(recipes, ItemPridePigment.Type.DEMIGIRL, Ingredient.of((ItemLike[])new ItemLike[]{Items.RAW_COPPER}));
        this.gayRecipe(recipes, ItemPridePigment.Type.GAY, Ingredient.of((ItemLike[])new ItemLike[]{Items.STONE_BRICK_WALL}));
        this.gayRecipe(recipes, ItemPridePigment.Type.GENDERFLUID, Ingredient.of((ItemLike[])new ItemLike[]{Items.WATER_BUCKET}));
        this.gayRecipe(recipes, ItemPridePigment.Type.GENDERQUEER, Ingredient.of((ItemLike[])new ItemLike[]{Items.GLASS_BOTTLE}));
        this.gayRecipe(recipes, ItemPridePigment.Type.INTERSEX, Ingredient.of((ItemLike[])new ItemLike[]{Items.AZALEA}));
        this.gayRecipe(recipes, ItemPridePigment.Type.LESBIAN, Ingredient.of((ItemLike[])new ItemLike[]{Items.HONEYCOMB}));
        this.gayRecipe(recipes, ItemPridePigment.Type.NONBINARY, Ingredient.of((ItemLike[])new ItemLike[]{Items.MOSS_BLOCK}));
        this.gayRecipe(recipes, ItemPridePigment.Type.PANSEXUAL, this.ingredients.whenModIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.CARROT}), "farmersdelight", CompatIngredientValue.of("farmersdelight:skillet")));
        this.gayRecipe(recipes, ItemPridePigment.Type.PLURAL, Ingredient.of((ItemLike[])new ItemLike[]{Items.REPEATER}));
        this.gayRecipe(recipes, ItemPridePigment.Type.TRANSGENDER, Ingredient.of((ItemLike[])new ItemLike[]{Items.EGG}));
        this.ring(RecipeCategory.MISC, (ItemLike)HexItems.UUID_PIGMENT, 1, (ItemLike)HexItems.AMETHYST_DUST, (ItemLike)Items.AMETHYST_SHARD).unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem((ItemLike)HexItems.AMETHYST_DUST)).save(recipes);
        this.ringCornerless(RecipeCategory.MISC, (ItemLike)HexItems.DEFAULT_PIGMENT, 1, (ItemLike)HexItems.AMETHYST_DUST, (ItemLike)Items.AMETHYST_SHARD).unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem((ItemLike)HexItems.AMETHYST_DUST)).save(recipes);
        this.ringCornerless(RecipeCategory.MISC, (ItemLike)HexItems.ANCIENT_PIGMENT, 1, (ItemLike)HexItems.AMETHYST_DUST, (ItemLike)Items.COPPER_INGOT).unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem((ItemLike)HexItems.AMETHYST_DUST)).save(recipes);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)HexItems.SCROLL_SMOL).define(Character.valueOf('P'), (ItemLike)Items.PAPER).define(Character.valueOf('A'), (ItemLike)HexItems.AMETHYST_DUST).pattern(" A").pattern("P ").unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem(HexTags.Items.STAVES)).save(recipes);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)HexItems.SCROLL_MEDIUM).define(Character.valueOf('P'), (ItemLike)Items.PAPER).define(Character.valueOf('A'), (ItemLike)HexItems.AMETHYST_DUST).pattern("  A").pattern("PP ").pattern("PP ").unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem(HexTags.Items.STAVES)).save(recipes);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)HexItems.SCROLL_LARGE).define(Character.valueOf('P'), (ItemLike)Items.PAPER).define(Character.valueOf('A'), (ItemLike)HexItems.AMETHYST_DUST).pattern("PPA").pattern("PPP").pattern("PPP").unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem(HexTags.Items.STAVES)).save(recipes);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)HexItems.SLATE, (int)6).define(Character.valueOf('S'), (ItemLike)Items.DEEPSLATE).define(Character.valueOf('A'), (ItemLike)HexItems.AMETHYST_DUST).pattern(" A ").pattern("SSS").unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem((ItemLike)HexItems.AMETHYST_DUST)).save(recipes);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)HexItems.JEWELER_HAMMER).define(Character.valueOf('I'), this.ingredients.ironIngot()).define(Character.valueOf('N'), this.ingredients.ironNugget()).define(Character.valueOf('A'), (ItemLike)Items.AMETHYST_SHARD).define(Character.valueOf('S'), this.ingredients.stick()).pattern("IAN").pattern(" S ").pattern(" S ").unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem((ItemLike)Items.AMETHYST_SHARD)).save(recipes);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)HexItems.AMETHYST_DUST, (int)31).requires((ItemLike)HexItems.QUENCHED_SHARD).requires((ItemLike)HexItems.AMETHYST_DUST).unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem((ItemLike)HexItems.QUENCHED_SHARD)).save(recipes, this.modLoc("decompose_quenched_shard/dust"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.AMETHYST_SHARD, (int)7).requires((ItemLike)HexItems.QUENCHED_SHARD).requires((ItemLike)Items.AMETHYST_SHARD).unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem((ItemLike)HexItems.QUENCHED_SHARD)).save(recipes, this.modLoc("decompose_quenched_shard/shard"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)HexItems.CHARGED_AMETHYST, (int)4).requires((ItemLike)HexItems.QUENCHED_SHARD).requires((ItemLike)HexItems.CHARGED_AMETHYST).unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem((ItemLike)HexItems.QUENCHED_SHARD)).save(recipes, this.modLoc("decompose_quenched_shard/charged"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)HexBlocks.SLATE_BLOCK).define(Character.valueOf('S'), (ItemLike)HexItems.SLATE).pattern("S").pattern("S").unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem((ItemLike)HexItems.SLATE)).save(recipes, this.modLoc("slate_block_from_slates"));
        this.ringAll(RecipeCategory.BUILDING_BLOCKS, (ItemLike)HexBlocks.SLATE_BLOCK, 8, (ItemLike)Blocks.DEEPSLATE, (ItemLike)HexItems.AMETHYST_DUST).unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem((ItemLike)HexItems.SLATE)).save(recipes);
        this.packing(RecipeCategory.BUILDING_BLOCKS, (ItemLike)HexItems.AMETHYST_DUST, (ItemLike)HexBlocks.AMETHYST_DUST_BLOCK.asItem(), "amethyst_dust", false, recipes);
        this.ringAll(RecipeCategory.BUILDING_BLOCKS, (ItemLike)HexBlocks.SCROLL_PAPER, 8, (ItemLike)Items.PAPER, (ItemLike)Items.AMETHYST_SHARD).unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem((ItemLike)Items.AMETHYST_SHARD)).save(recipes);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)HexBlocks.ANCIENT_SCROLL_PAPER, (int)8).requires(this.ingredients.dyes().get(DyeColor.BROWN)).requires((ItemLike)HexBlocks.SCROLL_PAPER, 8).unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem((ItemLike)HexBlocks.SCROLL_PAPER)).save(recipes);
        this.stack(RecipeCategory.DECORATIONS, (ItemLike)HexBlocks.SCROLL_PAPER_LANTERN, 1, (ItemLike)HexBlocks.SCROLL_PAPER, (ItemLike)Items.TORCH).unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem((ItemLike)HexBlocks.SCROLL_PAPER)).save(recipes);
        this.stack(RecipeCategory.DECORATIONS, (ItemLike)HexBlocks.ANCIENT_SCROLL_PAPER_LANTERN, 1, (ItemLike)HexBlocks.ANCIENT_SCROLL_PAPER, (ItemLike)Items.TORCH).unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem((ItemLike)HexBlocks.ANCIENT_SCROLL_PAPER)).save(recipes);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)HexBlocks.ANCIENT_SCROLL_PAPER_LANTERN, (int)8).requires(this.ingredients.dyes().get(DyeColor.BROWN)).requires((ItemLike)HexBlocks.SCROLL_PAPER_LANTERN, 8).unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem((ItemLike)HexBlocks.SCROLL_PAPER_LANTERN)).save(recipes, this.modLoc("ageing_scroll_paper_lantern"));
        this.stack(RecipeCategory.DECORATIONS, (ItemLike)HexBlocks.SCONCE, 4, Ingredient.of((ItemLike[])new ItemLike[]{HexItems.CHARGED_AMETHYST}), this.ingredients.copperIngot()).unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem((ItemLike)HexItems.CHARGED_AMETHYST)).save(recipes);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)HexBlocks.EDIFIED_PLANKS, (int)4).requires(HexTags.Items.EDIFIED_LOGS).unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem(HexTags.Items.EDIFIED_LOGS)).save(recipes);
        for (Map.Entry entry : this.EDIFIED_LOG_TO_WOOD.entrySet()) {
            BlockAkashicLog log = (BlockAkashicLog)((Object)entry.getKey());
            BlockAkashicLog wood = (BlockAkashicLog)((Object)entry.getValue());
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wood, (int)3).define(Character.valueOf('W'), (ItemLike)log).pattern("WW").pattern("WW").unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem((ItemLike)log)).save(recipes);
        }
        this.ring(RecipeCategory.BUILDING_BLOCKS, (ItemLike)HexBlocks.EDIFIED_PANEL, 8, HexTags.Items.EDIFIED_PLANKS, null).unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem(HexTags.Items.EDIFIED_PLANKS)).save(recipes);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)HexBlocks.EDIFIED_TILE, (int)6).define(Character.valueOf('W'), HexTags.Items.EDIFIED_PLANKS).pattern("WW ").pattern("W W").pattern(" WW").unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem(HexTags.Items.EDIFIED_PLANKS)).save(recipes);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)HexBlocks.EDIFIED_DOOR, (int)3).define(Character.valueOf('W'), HexTags.Items.EDIFIED_PLANKS).pattern("WW").pattern("WW").pattern("WW").unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem(HexTags.Items.EDIFIED_PLANKS)).save(recipes);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)HexBlocks.EDIFIED_TRAPDOOR, (int)2).define(Character.valueOf('W'), HexTags.Items.EDIFIED_PLANKS).pattern("WWW").pattern("WWW").unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem(HexTags.Items.EDIFIED_PLANKS)).save(recipes);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)HexBlocks.EDIFIED_STAIRS, (int)4).define(Character.valueOf('W'), HexTags.Items.EDIFIED_PLANKS).pattern("W  ").pattern("WW ").pattern("WWW").unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem(HexTags.Items.EDIFIED_PLANKS)).save(recipes);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)HexBlocks.EDIFIED_FENCE, (int)3).define(Character.valueOf('W'), HexTags.Items.EDIFIED_PLANKS).define(Character.valueOf('S'), (ItemLike)Items.STICK).pattern("WSW").pattern("WSW").unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem(HexTags.Items.EDIFIED_PLANKS)).save(recipes);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)HexBlocks.EDIFIED_FENCE_GATE, (int)1).define(Character.valueOf('W'), HexTags.Items.EDIFIED_PLANKS).define(Character.valueOf('S'), (ItemLike)Items.STICK).pattern("SWS").pattern("SWS").unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem(HexTags.Items.EDIFIED_PLANKS)).save(recipes);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)HexBlocks.EDIFIED_SLAB, (int)6).define(Character.valueOf('W'), HexTags.Items.EDIFIED_PLANKS).pattern("WWW").unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem(HexTags.Items.EDIFIED_PLANKS)).save(recipes);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)HexBlocks.EDIFIED_PRESSURE_PLATE, (int)1).define(Character.valueOf('W'), HexTags.Items.EDIFIED_PLANKS).pattern("WW").unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem(HexTags.Items.EDIFIED_PLANKS)).save(recipes);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)HexBlocks.EDIFIED_BUTTON).requires(HexTags.Items.EDIFIED_PLANKS).unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem(HexTags.Items.EDIFIED_PLANKS)).save(recipes);
        OvercastTrigger.Instance enlightenment = HexAdvancements.ENLIGHTEN;
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)HexBlocks.IMPETUS_EMPTY).define(Character.valueOf('B'), (ItemLike)Items.IRON_BARS).define(Character.valueOf('A'), (ItemLike)HexItems.CHARGED_AMETHYST).define(Character.valueOf('S'), (ItemLike)HexBlocks.SLATE_BLOCK).define(Character.valueOf('P'), (ItemLike)Items.PURPUR_BLOCK).pattern("PSS").pattern("BAB").pattern("SSP").unlockedBy("enlightenment", (CriterionTriggerInstance)enlightenment).save(recipes);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)HexBlocks.EMPTY_DIRECTRIX).define(Character.valueOf('C'), (ItemLike)Items.COMPARATOR).define(Character.valueOf('O'), (ItemLike)Items.OBSERVER).define(Character.valueOf('A'), (ItemLike)HexItems.CHARGED_AMETHYST).define(Character.valueOf('S'), (ItemLike)HexBlocks.SLATE_BLOCK).pattern("CSS").pattern("OAO").pattern("SSC").unlockedBy("enlightenment", (CriterionTriggerInstance)enlightenment).save(recipes);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)HexBlocks.AKASHIC_BOOKSHELF).define(Character.valueOf('L'), HexTags.Items.EDIFIED_LOGS).define(Character.valueOf('P'), HexTags.Items.EDIFIED_PLANKS).define(Character.valueOf('C'), (ItemLike)Items.BOOK).pattern("LPL").pattern("CCC").pattern("LPL").unlockedBy("enlightenment", (CriterionTriggerInstance)enlightenment).save(recipes);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)HexBlocks.AKASHIC_LIGATURE, (int)4).define(Character.valueOf('L'), HexTags.Items.EDIFIED_LOGS).define(Character.valueOf('P'), HexTags.Items.EDIFIED_PLANKS).define(Character.valueOf('1'), (ItemLike)HexItems.AMETHYST_DUST).define(Character.valueOf('2'), (ItemLike)Items.AMETHYST_SHARD).define(Character.valueOf('3'), (ItemLike)HexItems.CHARGED_AMETHYST).pattern("LPL").pattern("123").pattern("LPL").unlockedBy("enlightenment", (CriterionTriggerInstance)enlightenment).save(recipes);
        this.stoneSet(recipes, HexBlocks.SLATE_BLOCK.asItem(), HexBlocks.SLATE_BRICKS.asItem(), HexBlocks.SLATE_BRICKS_SMALL.asItem(), HexBlocks.SLATE_TILES.asItem(), HexBlocks.SLATE_PILLAR.asItem());
        this.stoneSet(recipes, Blocks.AMETHYST_BLOCK.asItem(), HexBlocks.AMETHYST_BRICKS.asItem(), HexBlocks.AMETHYST_BRICKS_SMALL.asItem(), HexBlocks.AMETHYST_TILES.asItem(), HexBlocks.AMETHYST_PILLAR.asItem());
        this.stoneSet(recipes, HexBlocks.QUENCHED_ALLAY.asItem(), HexBlocks.QUENCHED_ALLAY_BRICKS.asItem(), HexBlocks.QUENCHED_ALLAY_BRICKS_SMALL.asItem(), HexBlocks.QUENCHED_ALLAY_TILES.asItem(), null);
        this.stoneCutterFromTag(recipes, HexTags.Items.SLATE_BLOCKS, HexBlocks.SLATE_BRICKS.asItem(), HexBlocks.SLATE_BRICKS_SMALL.asItem(), HexBlocks.SLATE_TILES.asItem(), HexBlocks.SLATE_PILLAR.asItem());
        this.stoneCutterFromTag(recipes, HexTags.Items.AMETHYST_BLOCKS, HexBlocks.AMETHYST_BRICKS.asItem(), HexBlocks.AMETHYST_BRICKS_SMALL.asItem(), HexBlocks.AMETHYST_TILES.asItem(), HexBlocks.AMETHYST_PILLAR.asItem());
        this.stoneCutterFromTag(recipes, HexTags.Items.QUENCHED_ALLAY_BLOCKS, HexBlocks.QUENCHED_ALLAY_BRICKS.asItem(), HexBlocks.QUENCHED_ALLAY_BRICKS_SMALL.asItem(), HexBlocks.QUENCHED_ALLAY_TILES.asItem());
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)HexBlocks.SLATE_AMETHYST_BRICKS.asItem(), (int)2).requires((ItemLike)HexBlocks.SLATE_BRICKS).requires((ItemLike)HexBlocks.AMETHYST_BRICKS).unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.has((ItemLike)HexBlocks.SLATE)).save(recipes);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)HexBlocks.SLATE_AMETHYST_BRICKS_SMALL.asItem(), (int)2).requires((ItemLike)HexBlocks.SLATE_BRICKS_SMALL).requires((ItemLike)HexBlocks.AMETHYST_BRICKS_SMALL).unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.has((ItemLike)HexBlocks.SLATE)).save(recipes);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)HexBlocks.SLATE_AMETHYST_TILES.asItem(), (int)2).requires((ItemLike)HexBlocks.SLATE_TILES).requires((ItemLike)HexBlocks.AMETHYST_TILES).unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.has((ItemLike)HexBlocks.SLATE)).save(recipes);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)HexBlocks.SLATE_AMETHYST_PILLAR.asItem(), (int)2).requires((ItemLike)HexBlocks.SLATE_PILLAR).requires((ItemLike)HexBlocks.AMETHYST_PILLAR).unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.has((ItemLike)HexBlocks.SLATE)).save(recipes);
        new BrainsweepRecipeBuilder(StateIngredientHelper.of(Blocks.AMETHYST_BLOCK), new VillagerIngredient(null, null, 3), Blocks.BUDDING_AMETHYST.defaultBlockState(), 1000000L).unlockedBy("enlightenment", (CriterionTriggerInstance)enlightenment).save(recipes, this.modLoc("brainsweep/budding_amethyst"));
        new BrainsweepRecipeBuilder(StateIngredientHelper.of(HexBlocks.IMPETUS_EMPTY), new VillagerIngredient(VillagerProfession.TOOLSMITH, null, 2), HexBlocks.IMPETUS_RIGHTCLICK.defaultBlockState(), 1000000L).unlockedBy("enlightenment", (CriterionTriggerInstance)enlightenment).save(recipes, this.modLoc("brainsweep/impetus_rightclick"));
        new BrainsweepRecipeBuilder(StateIngredientHelper.of(HexBlocks.IMPETUS_EMPTY), new VillagerIngredient(VillagerProfession.FLETCHER, null, 2), HexBlocks.IMPETUS_LOOK.defaultBlockState(), 1000000L).unlockedBy("enlightenment", (CriterionTriggerInstance)enlightenment).save(recipes, this.modLoc("brainsweep/impetus_look"));
        new BrainsweepRecipeBuilder(StateIngredientHelper.of(HexBlocks.IMPETUS_EMPTY), new VillagerIngredient(VillagerProfession.CLERIC, null, 2), HexBlocks.IMPETUS_REDSTONE.defaultBlockState(), 1000000L).unlockedBy("enlightenment", (CriterionTriggerInstance)enlightenment).save(recipes, this.modLoc("brainsweep/impetus_storedplayer"));
        new BrainsweepRecipeBuilder(StateIngredientHelper.of(HexBlocks.EMPTY_DIRECTRIX), new VillagerIngredient(VillagerProfession.MASON, null, 1), HexBlocks.DIRECTRIX_REDSTONE.defaultBlockState(), 1000000L).unlockedBy("enlightenment", (CriterionTriggerInstance)enlightenment).save(recipes, this.modLoc("brainsweep/directrix_redstone"));
        new BrainsweepRecipeBuilder(StateIngredientHelper.of(HexBlocks.EMPTY_DIRECTRIX), new VillagerIngredient(VillagerProfession.SHEPHERD, null, 1), HexBlocks.DIRECTRIX_BOOLEAN.defaultBlockState(), 1000000L).unlockedBy("enlightenment", (CriterionTriggerInstance)enlightenment).save(recipes, this.modLoc("brainsweep/directrix_boolean"));
        new BrainsweepRecipeBuilder(StateIngredientHelper.of(HexBlocks.AKASHIC_LIGATURE), new VillagerIngredient(VillagerProfession.LIBRARIAN, null, 5), HexBlocks.AKASHIC_RECORD.defaultBlockState(), 1000000L).unlockedBy("enlightenment", (CriterionTriggerInstance)enlightenment).save(recipes, this.modLoc("brainsweep/akashic_record"));
        new BrainsweepRecipeBuilder(StateIngredientHelper.of(Blocks.AMETHYST_BLOCK), new EntityTypeIngredient(EntityType.ALLAY), HexBlocks.QUENCHED_ALLAY.defaultBlockState(), 100000L).unlockedBy("enlightenment", (CriterionTriggerInstance)enlightenment).save(recipes, this.modLoc("brainsweep/quench_allay"));
        this.conditions.apply(new CreateCrushingRecipeBuilder().withInput((ItemLike)Blocks.AMETHYST_CLUSTER).duration(150).withOutput((ItemLike)Items.AMETHYST_SHARD, 7).withOutput((ItemLike)HexItems.AMETHYST_DUST, 5).withOutput(0.25f, (ItemLike)HexItems.CHARGED_AMETHYST)).whenModLoaded("create").save(recipes, new ResourceLocation("create", "crushing/amethyst_cluster"));
        this.conditions.apply(new CreateCrushingRecipeBuilder().withInput((ItemLike)Blocks.AMETHYST_BLOCK).duration(150).withOutput((ItemLike)Items.AMETHYST_SHARD, 3).withOutput(0.5f, (ItemLike)HexItems.AMETHYST_DUST, 4)).whenModLoaded("create").save(recipes, new ResourceLocation("create", "crushing/amethyst_block"));
        this.conditions.apply(new CreateCrushingRecipeBuilder().withInput((ItemLike)Items.AMETHYST_SHARD).duration(150).withOutput((ItemLike)HexItems.AMETHYST_DUST, 4).withOutput(0.5f, (ItemLike)HexItems.AMETHYST_DUST)).whenModLoaded("create").save(recipes, this.modLoc("compat/create/crushing/amethyst_shard"));
        for (BlockAkashicLog log : this.EDIFIED_LOGS) {
            this.conditions.apply(new FarmersDelightCuttingRecipeBuilder().withInput((ItemLike)log).withTool(this.ingredients.axeStrip()).withOutput((ItemLike)HexBlocks.STRIPPED_EDIFIED_LOG).withOutput("farmersdelight:tree_bark").withSound(SoundEvents.AXE_STRIP)).whenModLoaded("farmersdelight").save(recipes, this.modLoc("compat/farmersdelight/cutting/" + BuiltInRegistries.BLOCK.getKey((Object)log).getPath()));
        }
        this.conditions.apply(new FarmersDelightCuttingRecipeBuilder().withInput((ItemLike)HexBlocks.EDIFIED_WOOD).withTool(this.ingredients.axeStrip()).withOutput((ItemLike)HexBlocks.STRIPPED_EDIFIED_WOOD).withOutput("farmersdelight:tree_bark").withSound(SoundEvents.AXE_STRIP)).whenModLoaded("farmersdelight").save(recipes, this.modLoc("compat/farmersdelight/cutting/akashic_wood"));
        this.conditions.apply(new FarmersDelightCuttingRecipeBuilder().withInput((ItemLike)HexBlocks.EDIFIED_TRAPDOOR).withTool(this.ingredients.axeDig()).withOutput((ItemLike)HexBlocks.EDIFIED_PLANKS)).whenModLoaded("farmersdelight").save(recipes, this.modLoc("compat/farmersdelight/cutting/akashic_trapdoor"));
        this.conditions.apply(new FarmersDelightCuttingRecipeBuilder().withInput((ItemLike)HexBlocks.EDIFIED_DOOR).withTool(this.ingredients.axeDig()).withOutput((ItemLike)HexBlocks.EDIFIED_PLANKS)).whenModLoaded("farmersdelight").save(recipes, this.modLoc("compat/farmersdelight/cutting/akashic_door"));
    }

    private void staffRecipe(Consumer<FinishedRecipe> recipes, ItemStaff staff, Item plank) {
        this.staffRecipe(recipes, staff, Ingredient.of((ItemLike[])new ItemLike[]{plank}));
    }

    private void staffRecipe(Consumer<FinishedRecipe> recipes, ItemStaff staff, Ingredient plank) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)staff).define(Character.valueOf('W'), plank).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('A'), (ItemLike)HexItems.CHARGED_AMETHYST).pattern(" SA").pattern(" WS").pattern("S  ").unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem((ItemLike)HexItems.CHARGED_AMETHYST)).save(recipes);
    }

    private void gayRecipe(Consumer<FinishedRecipe> recipes, ItemPridePigment.Type type, Ingredient material) {
        ItemPridePigment colorizer = HexItems.PRIDE_PIGMENTS.get((Object)type);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)colorizer).define(Character.valueOf('D'), (ItemLike)HexItems.AMETHYST_DUST).define(Character.valueOf('C'), material).pattern(" D ").pattern("DCD").pattern(" D ").unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem((ItemLike)HexItems.AMETHYST_DUST)).save(recipes);
    }

    private void specialRecipe(Consumer<FinishedRecipe> consumer, SimpleCraftingRecipeSerializer<?> serializer) {
        ResourceLocation name = BuiltInRegistries.RECIPE_SERIALIZER.getKey(serializer);
        SpecialRecipeBuilder.special(serializer).save(consumer, "hexcasting:dynamic" + name.getPath());
    }

    private void stoneSet(Consumer<FinishedRecipe> recipes, Item base, Item bricks, Item smallBricks, Item tiles, @Nullable Item pillar) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)bricks, (int)4).define(Character.valueOf('#'), (ItemLike)base).pattern("##").pattern("##").unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem((ItemLike)base)).save(recipes);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)bricks).requires((ItemLike)smallBricks).unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem((ItemLike)base)).save(recipes, this.modLoc(bricks + "_from_" + smallBricks));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)smallBricks).requires((ItemLike)bricks).unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem((ItemLike)base)).save(recipes, this.modLoc(smallBricks + "_from_" + bricks));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)tiles, (int)4).define(Character.valueOf('#'), (ItemLike)bricks).pattern("##").pattern("##").unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem((ItemLike)base)).save(recipes);
        if (pillar != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)pillar, (int)2).define(Character.valueOf('#'), (ItemLike)base).pattern("#").pattern("#").unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem((ItemLike)base)).save(recipes);
        }
    }

    private void stoneCutterFromTag(Consumer<FinishedRecipe> recipes, TagKey<Item> tagKey, Item ... results) {
        for (Item result : results) {
            SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of(tagKey), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result).unlockedBy("has_item", (CriterionTriggerInstance)HexplatRecipes.hasItem(tagKey)).save(recipes, this.modLoc("stonecutting/" + result));
        }
    }
}

