/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.recipe;

import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.items.storage.ItemSpellbook;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class SealSpellbookRecipe
extends ShapelessRecipe {
    public static final SimpleCraftingRecipeSerializer<SealSpellbookRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(SealSpellbookRecipe::new);

    private static ItemStack getSealedStack() {
        ItemStack output = new ItemStack((ItemLike)HexItems.SPELLBOOK);
        ItemSpellbook.setSealed(output, true);
        NBTHelper.putString(output, "VisualOverride", "any");
        return output;
    }

    private static NonNullList<Ingredient> createIngredients() {
        NonNullList ingredients = NonNullList.createWithCapacity((int)2);
        ingredients.add((Object)IXplatAbstractions.INSTANCE.getUnsealedIngredient(new ItemStack((ItemLike)HexItems.SPELLBOOK)));
        ingredients.add((Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.HONEYCOMB}));
        return ingredients;
    }

    public SealSpellbookRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, "", category, SealSpellbookRecipe.getSealedStack(), SealSpellbookRecipe.createIngredients());
    }

    @NotNull
    public ItemStack assemble(CraftingContainer inv, RegistryAccess access) {
        ItemStack out = ItemStack.EMPTY;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (!stack.is((Item)HexItems.SPELLBOOK)) continue;
            out = stack.copy();
            break;
        }
        if (!out.isEmpty()) {
            ItemSpellbook.setSealed(out, true);
            out.setCount(1);
        }
        return out;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }
}

