/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.particles;

import at.petrak.hexcasting.common.lib.HexParticles;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;

public record ConjureParticleOptions(int color) implements ParticleOptions
{
    public static final ParticleOptions.Deserializer<ConjureParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<ConjureParticleOptions>(){

        public ConjureParticleOptions fromCommand(ParticleType<ConjureParticleOptions> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int color = reader.readInt();
            return new ConjureParticleOptions(color);
        }

        public ConjureParticleOptions fromNetwork(ParticleType<ConjureParticleOptions> type, FriendlyByteBuf buf) {
            int col = buf.readInt();
            return new ConjureParticleOptions(col);
        }
    };

    public ParticleType<?> getType() {
        return HexParticles.CONJURE_PARTICLE;
    }

    public void writeToNetwork(FriendlyByteBuf buf) {
        buf.writeInt(this.color);
    }

    public String writeToString() {
        return String.format(Locale.ROOT, "%s %s", this.color);
    }

    public static class Type
    extends ParticleType<ConjureParticleOptions> {
        public static final Codec<ConjureParticleOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("color").forGetter(o -> o.color)).apply((Applicative)instance, ConjureParticleOptions::new));

        public Type(boolean pOverrideLimiter) {
            super(pOverrideLimiter, DESERIALIZER);
        }

        public Codec<ConjureParticleOptions> codec() {
            return CODEC;
        }
    }
}

