/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.msgs;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.common.entities.EntityWallScroll;
import at.petrak.hexcasting.common.msgs.IMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;

public record MsgNewWallScrollS2C(ClientboundAddEntityPacket inner, BlockPos pos, Direction dir, ItemStack scrollItem, boolean showsStrokeOrder, int blockSize) implements IMessage
{
    public static final ResourceLocation ID = HexAPI.modLoc("wallscr");

    @Override
    public ResourceLocation getFabricId() {
        return ID;
    }

    @Override
    public void serialize(FriendlyByteBuf buf) {
        this.inner.write(buf);
        buf.writeBlockPos(this.pos);
        buf.writeByte(this.dir.ordinal());
        buf.writeItem(this.scrollItem);
        buf.writeBoolean(this.showsStrokeOrder);
        buf.writeVarInt(this.blockSize);
    }

    public static MsgNewWallScrollS2C deserialize(FriendlyByteBuf buf) {
        ClientboundAddEntityPacket inner = new ClientboundAddEntityPacket(buf);
        BlockPos pos = buf.readBlockPos();
        Direction dir = (Direction)HexUtils.getSafe((Enum[])Direction.values(), (byte)buf.readByte());
        ItemStack scroll = buf.readItem();
        boolean strokeOrder = buf.readBoolean();
        int blockSize = buf.readVarInt();
        return new MsgNewWallScrollS2C(inner, pos, dir, scroll, strokeOrder, blockSize);
    }

    public static void handle(final MsgNewWallScrollS2C self) {
        Minecraft.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                LocalPlayer player = Minecraft.getInstance().player;
                if (player != null) {
                    player.connection.handleAddEntity(self.inner);
                    Entity e = player.level().getEntity(self.inner.getId());
                    if (e instanceof EntityWallScroll) {
                        EntityWallScroll scroll = (EntityWallScroll)e;
                        scroll.readSpawnData(self.pos, self.dir, self.scrollItem, self.showsStrokeOrder, self.blockSize);
                    }
                }
            }
        });
    }
}

