/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.loot;

import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.iota.PatternIota;
import at.petrak.hexcasting.api.casting.math.HexDir;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.common.lib.HexLootFunctions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class AddHexToAncientCypherFunc
extends LootItemConditionalFunction {
    private static final List<Pair<String, String[]>> LOOT_HEXES = List.of(new Pair((Object)"hexcasting.loot_hex.shatter", (Object)new String[]{"NORTH_EAST qaq", "EAST aa", "NORTH_EAST qaq", "NORTH_EAST wa", "EAST wqaawdd", "EAST qaqqqqq"}), new Pair((Object)"hexcasting.loot_hex.kindle", (Object)new String[]{"NORTH_EAST qaq", "EAST aa", "NORTH_EAST qaq", "NORTH_EAST wa", "EAST wqaawdd", "SOUTH_EAST aaqawawa"}), new Pair((Object)"hexcasting.loot_hex.illuminate", (Object)new String[]{"NORTH_EAST qaq", "EAST aa", "NORTH_EAST qaq", "NORTH_EAST wa", "EAST aadadaaw", "EAST wqaawdd", "NORTH_EAST ddqdd", "EAST weddwaa", "NORTH_EAST waaw", "NORTH_EAST qqd"}), new Pair((Object)"hexcasting.loot_hex.growth", (Object)new String[]{"NORTH_EAST qaq", "EAST aa", "NORTH_EAST qaq", "NORTH_EAST wa", "EAST aadadaaw", "EAST wqaawdd", "NORTH_EAST ddqdd", "EAST weddwaa", "NORTH_EAST waaw", "SOUTH_EAST aqaaedwd", "EAST aadaadaa", "NORTH_EAST wqaqwawqaqw", "NORTH_EAST wqaqwawqaqw", "NORTH_EAST wqaqwawqaqw"}), new Pair((Object)"hexcasting.loot_hex.lunge", (Object)new String[]{"NORTH_EAST qaq", "EAST aadaa", "NORTH_EAST wa", "SOUTH_EAST aqaawa", "SOUTH_EAST waqaw", "SOUTH_WEST awqqqwaqw"}), new Pair((Object)"hexcasting.loot_hex.sidestep", (Object)new String[]{"NORTH_EAST qaq", "EAST aadaa", "NORTH_EAST wa", "NORTH_WEST eqqq", "SOUTH_EAST aqaawd", "SOUTH_EAST e", "NORTH_WEST qqqqqew", "SOUTH_WEST eeeeeqw", "SOUTH_EAST awdd", "NORTH_EAST wdedw", "SOUTH_WEST awqqqwaqw"}), new Pair((Object)"hexcasting.loot_hex.ascend", (Object)new String[]{"NORTH_EAST qaq", "SOUTH_EAST aqaae", "WEST qqqqqawwawawd"}), new Pair((Object)"hexcasting.loot_hex.blink", (Object)new String[]{"NORTH_EAST qaq", "EAST aadaa", "EAST aa", "NORTH_EAST qaq", "NORTH_EAST wa", "EAST wqaawdd", "NORTH_EAST qaq", "EAST aa", "NORTH_WEST wddw", "NORTH_EAST wqaqw", "SOUTH_EAST aqaaw", "NORTH_WEST wddw", "SOUTH_WEST awqqqwaq"}), new Pair((Object)"hexcasting.loot_hex.blastoff", (Object)new String[]{"NORTH_EAST qaq", "NORTH_WEST qqqqqew", "SOUTH_EAST aqaawaa", "SOUTH_EAST waqaw", "SOUTH_WEST awqqqwaqw"}), new Pair((Object)"hexcasting.loot_hex.radar", (Object)new String[]{"WEST qqq", "EAST aadaa", "EAST aa", "SOUTH_EAST aqaawa", "SOUTH_WEST ewdqdwe", "NORTH_EAST de", "EAST eee", "NORTH_EAST qaq", "EAST aa", "SOUTH_EAST aqaaeaqq", "SOUTH_EAST qqqqqwdeddwd", "NORTH_EAST dadad"}), new Pair((Object)"hexcasting.loot_hex.beckon", (Object)new String[]{"NORTH_EAST qaq", "EAST aa", "NORTH_EAST qaq", "NORTH_EAST wa", "EAST weaqa", "EAST aadaa", "EAST dd", "NORTH_EAST qaq", "EAST aa", "EAST aawdd", "NORTH_WEST wddw", "EAST aadaa", "NORTH_EAST wqaqw", "NORTH_EAST wdedw", "SOUTH_EAST aqaawa", "SOUTH_EAST waqaw", "SOUTH_WEST awqqqwaqw"}), new Pair((Object)"hexcasting.loot_hex.detonate", (Object)new String[]{"NORTH_EAST qaq", "EAST aa", "SOUTH_EAST aqaaedwd", "EAST ddwddwdd"}), new Pair((Object)"hexcasting.loot_hex.shockwave", (Object)new String[]{"NORTH_EAST qaq", "EAST aa", "SOUTH_EAST aqaawaa", "EAST aadaadaa", "SOUTH_EAST aqawqadaq", "SOUTH_EAST aqaaedwd", "EAST aawaawaa", "NORTH_EAST qqa", "EAST qaqqqqq"}), new Pair((Object)"hexcasting.loot_hex.heat_wave", (Object)new String[]{"WEST qqq", "SOUTH_EAST aaqawawa", "EAST eee", "NORTH_EAST qaq", "EAST aa", "SOUTH_EAST aqaae", "SOUTH_EAST qqqqqwded", "SOUTH_WEST aaqwqaa", "SOUTH_EAST a", "NORTH_EAST dadad"}), new Pair((Object)"hexcasting.loot_hex.wither_wave", (Object)new String[]{"WEST qqq", "SOUTH_EAST aqaae", "SOUTH_EAST aqaaw", "SOUTH_WEST qqqqqaewawawe", "EAST eee", "NORTH_EAST qaq", "EAST aa", "SOUTH_EAST aqaae", "SOUTH_EAST qqqqqwdeddwd", "SOUTH_WEST aaqwqaa", "SOUTH_EAST a", "NORTH_EAST dadad"}), new Pair((Object)"hexcasting.loot_hex.flight_zone", (Object)new String[]{"NORTH_EAST qaq", "SOUTH_EAST aqaaq", "SOUTH_WEST awawaawq"}));

    public AddHexToAncientCypherFunc(LootItemCondition[] lootItemConditions) {
        super(lootItemConditions);
    }

    public static ItemStack doStatic(ItemStack stack, RandomSource rand) {
        Pair<String, String[]> hex = LOOT_HEXES.get(rand.nextInt(LOOT_HEXES.size()));
        ListTag patsTag = new ListTag();
        for (String patString : (String[])hex.getSecond()) {
            String[] pieces = patString.split(" ");
            HexPattern pat = HexPattern.fromAnglesUnchecked(pieces[1], HexDir.fromString(pieces[0]));
            patsTag.add((Object)IotaType.serialize(new PatternIota(pat)));
        }
        CompoundTag tag = new CompoundTag();
        tag.putString("hex_name", (String)hex.getFirst());
        tag.put("patterns", (Tag)patsTag);
        tag.put("pigment", (Tag)FrozenPigment.ANCIENT.get().serializeToNBT());
        tag.putLong("hexcasting:media", 1600000L);
        tag.putLong("hexcasting:start_media", 1600000L);
        tag.putInt("variant", rand.nextInt(8));
        stack.getOrCreateTag().merge(tag);
        return stack;
    }

    protected ItemStack run(ItemStack stack, LootContext ctx) {
        return AddHexToAncientCypherFunc.doStatic(stack, ctx.getRandom());
    }

    public LootItemFunctionType getType() {
        return HexLootFunctions.HEX_CYPHER;
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<AddHexToAncientCypherFunc> {
        public void serialize(JsonObject json, AddHexToAncientCypherFunc value, JsonSerializationContext ctx) {
            super.serialize(json, (LootItemConditionalFunction)value, ctx);
        }

        public AddHexToAncientCypherFunc deserialize(JsonObject object, JsonDeserializationContext ctx, LootItemCondition[] conditions) {
            return new AddHexToAncientCypherFunc(conditions);
        }
    }
}

