/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.lib.hex;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.ActionRegistryEntry;
import at.petrak.hexcasting.api.casting.castables.Action;
import at.petrak.hexcasting.api.casting.castables.OperationAction;
import at.petrak.hexcasting.api.casting.iota.BooleanIota;
import at.petrak.hexcasting.api.casting.iota.DoubleIota;
import at.petrak.hexcasting.api.casting.iota.NullIota;
import at.petrak.hexcasting.api.casting.iota.Vec3Iota;
import at.petrak.hexcasting.api.casting.math.HexDir;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.common.casting.actions.akashic.OpAkashicRead;
import at.petrak.hexcasting.common.casting.actions.akashic.OpAkashicWrite;
import at.petrak.hexcasting.common.casting.actions.circles.OpCircleBounds;
import at.petrak.hexcasting.common.casting.actions.circles.OpImpetusDir;
import at.petrak.hexcasting.common.casting.actions.circles.OpImpetusPos;
import at.petrak.hexcasting.common.casting.actions.eval.OpEval;
import at.petrak.hexcasting.common.casting.actions.eval.OpEvalBreakable;
import at.petrak.hexcasting.common.casting.actions.eval.OpForEach;
import at.petrak.hexcasting.common.casting.actions.eval.OpHalt;
import at.petrak.hexcasting.common.casting.actions.eval.OpThanos;
import at.petrak.hexcasting.common.casting.actions.lists.OpEmptyList;
import at.petrak.hexcasting.common.casting.actions.lists.OpLastNToList;
import at.petrak.hexcasting.common.casting.actions.lists.OpSingleton;
import at.petrak.hexcasting.common.casting.actions.lists.OpSplat;
import at.petrak.hexcasting.common.casting.actions.local.OpPeekLocal;
import at.petrak.hexcasting.common.casting.actions.local.OpPushLocal;
import at.petrak.hexcasting.common.casting.actions.math.OpCoerceToAxial;
import at.petrak.hexcasting.common.casting.actions.math.OpRandom;
import at.petrak.hexcasting.common.casting.actions.math.logic.OpBoolIf;
import at.petrak.hexcasting.common.casting.actions.math.logic.OpCoerceToBool;
import at.petrak.hexcasting.common.casting.actions.math.logic.OpEquality;
import at.petrak.hexcasting.common.casting.actions.queryentity.OpCanEntityHexFly;
import at.petrak.hexcasting.common.casting.actions.queryentity.OpEntityHeight;
import at.petrak.hexcasting.common.casting.actions.queryentity.OpEntityLook;
import at.petrak.hexcasting.common.casting.actions.queryentity.OpEntityPos;
import at.petrak.hexcasting.common.casting.actions.queryentity.OpEntityVelocity;
import at.petrak.hexcasting.common.casting.actions.raycast.OpBlockAxisRaycast;
import at.petrak.hexcasting.common.casting.actions.raycast.OpBlockRaycast;
import at.petrak.hexcasting.common.casting.actions.raycast.OpEntityRaycast;
import at.petrak.hexcasting.common.casting.actions.rw.OpRead;
import at.petrak.hexcasting.common.casting.actions.rw.OpReadable;
import at.petrak.hexcasting.common.casting.actions.rw.OpTheCoolerRead;
import at.petrak.hexcasting.common.casting.actions.rw.OpTheCoolerReadable;
import at.petrak.hexcasting.common.casting.actions.rw.OpTheCoolerWritable;
import at.petrak.hexcasting.common.casting.actions.rw.OpTheCoolerWrite;
import at.petrak.hexcasting.common.casting.actions.rw.OpWritable;
import at.petrak.hexcasting.common.casting.actions.rw.OpWrite;
import at.petrak.hexcasting.common.casting.actions.selectors.OpGetCaster;
import at.petrak.hexcasting.common.casting.actions.selectors.OpGetEntitiesBy;
import at.petrak.hexcasting.common.casting.actions.selectors.OpGetEntityAt;
import at.petrak.hexcasting.common.casting.actions.spells.OpAddMotion;
import at.petrak.hexcasting.common.casting.actions.spells.OpBeep;
import at.petrak.hexcasting.common.casting.actions.spells.OpBlink;
import at.petrak.hexcasting.common.casting.actions.spells.OpBreakBlock;
import at.petrak.hexcasting.common.casting.actions.spells.OpColorize;
import at.petrak.hexcasting.common.casting.actions.spells.OpConjureBlock;
import at.petrak.hexcasting.common.casting.actions.spells.OpCreateFluid;
import at.petrak.hexcasting.common.casting.actions.spells.OpCycleVariant;
import at.petrak.hexcasting.common.casting.actions.spells.OpDestroyFluid;
import at.petrak.hexcasting.common.casting.actions.spells.OpEdifySapling;
import at.petrak.hexcasting.common.casting.actions.spells.OpErase;
import at.petrak.hexcasting.common.casting.actions.spells.OpExplode;
import at.petrak.hexcasting.common.casting.actions.spells.OpExtinguish;
import at.petrak.hexcasting.common.casting.actions.spells.OpFlight;
import at.petrak.hexcasting.common.casting.actions.spells.OpIgnite;
import at.petrak.hexcasting.common.casting.actions.spells.OpMakeBattery;
import at.petrak.hexcasting.common.casting.actions.spells.OpMakePackagedSpell;
import at.petrak.hexcasting.common.casting.actions.spells.OpPlaceBlock;
import at.petrak.hexcasting.common.casting.actions.spells.OpPotionEffect;
import at.petrak.hexcasting.common.casting.actions.spells.OpPrint;
import at.petrak.hexcasting.common.casting.actions.spells.OpRecharge;
import at.petrak.hexcasting.common.casting.actions.spells.OpTheOnlyReasonAnyoneDownloadedPsi;
import at.petrak.hexcasting.common.casting.actions.spells.great.OpAltiora;
import at.petrak.hexcasting.common.casting.actions.spells.great.OpBrainsweep;
import at.petrak.hexcasting.common.casting.actions.spells.great.OpLightning;
import at.petrak.hexcasting.common.casting.actions.spells.great.OpTeleport;
import at.petrak.hexcasting.common.casting.actions.spells.great.OpWeather;
import at.petrak.hexcasting.common.casting.actions.spells.sentinel.OpCreateSentinel;
import at.petrak.hexcasting.common.casting.actions.spells.sentinel.OpDestroySentinel;
import at.petrak.hexcasting.common.casting.actions.spells.sentinel.OpGetSentinelPos;
import at.petrak.hexcasting.common.casting.actions.spells.sentinel.OpGetSentinelWayfind;
import at.petrak.hexcasting.common.casting.actions.stack.OpAlwinfyHasAscendedToABeingOfPureMath;
import at.petrak.hexcasting.common.casting.actions.stack.OpDuplicateN;
import at.petrak.hexcasting.common.casting.actions.stack.OpFisherman;
import at.petrak.hexcasting.common.casting.actions.stack.OpFishermanButItCopies;
import at.petrak.hexcasting.common.casting.actions.stack.OpStackSize;
import at.petrak.hexcasting.common.casting.actions.stack.OpTwiddling;
import at.petrak.hexcasting.common.items.magic.ItemCypher;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.interop.pehkui.OpGetScale;
import at.petrak.hexcasting.interop.pehkui.OpSetScale;
import at.petrak.hexcasting.interop.pehkui.PehkuiInterop;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;

public class HexActions {
    public static final Registry<ActionRegistryEntry> REGISTRY = IXplatAbstractions.INSTANCE.getActionRegistry();
    private static final Map<ResourceLocation, ActionRegistryEntry> ACTIONS = new LinkedHashMap<ResourceLocation, ActionRegistryEntry>();
    public static final ActionRegistryEntry GET_CASTER = HexActions.make("get_caster", new ActionRegistryEntry(HexPattern.fromAngles("qaq", HexDir.NORTH_EAST), OpGetCaster.INSTANCE));
    public static final ActionRegistryEntry ENTITY_POS$EYE = HexActions.make("entity_pos/eye", new ActionRegistryEntry(HexPattern.fromAngles("aa", HexDir.EAST), new OpEntityPos(false)));
    public static final ActionRegistryEntry ENTITY_POS$FOOT = HexActions.make("entity_pos/foot", new ActionRegistryEntry(HexPattern.fromAngles("dd", HexDir.NORTH_EAST), new OpEntityPos(true)));
    public static final ActionRegistryEntry ENTITY_LOOK = HexActions.make("get_entity_look", new ActionRegistryEntry(HexPattern.fromAngles("wa", HexDir.EAST), OpEntityLook.INSTANCE));
    public static final ActionRegistryEntry ENTITY_HEIGHT = HexActions.make("get_entity_height", new ActionRegistryEntry(HexPattern.fromAngles("awq", HexDir.NORTH_EAST), OpEntityHeight.INSTANCE));
    public static final ActionRegistryEntry ENTITY_VELOCITY = HexActions.make("get_entity_velocity", new ActionRegistryEntry(HexPattern.fromAngles("wq", HexDir.EAST), OpEntityVelocity.INSTANCE));
    public static final ActionRegistryEntry RAYCAST = HexActions.make("raycast", new ActionRegistryEntry(HexPattern.fromAngles("wqaawdd", HexDir.EAST), OpBlockRaycast.INSTANCE));
    public static final ActionRegistryEntry RAYCAST_AXIS = HexActions.make("raycast/axis", new ActionRegistryEntry(HexPattern.fromAngles("weddwaa", HexDir.EAST), OpBlockAxisRaycast.INSTANCE));
    public static final ActionRegistryEntry RAYCAST_ENTITY = HexActions.make("raycast/entity", new ActionRegistryEntry(HexPattern.fromAngles("weaqa", HexDir.EAST), OpEntityRaycast.INSTANCE));
    public static final ActionRegistryEntry CIRCLE$IMPETUS_POST = HexActions.make("circle/impetus_pos", new ActionRegistryEntry(HexPattern.fromAngles("eaqwqae", HexDir.SOUTH_WEST), OpImpetusPos.INSTANCE));
    public static final ActionRegistryEntry CIRCLE$IMPETUS_DIR = HexActions.make("circle/impetus_dir", new ActionRegistryEntry(HexPattern.fromAngles("eaqwqaewede", HexDir.SOUTH_WEST), OpImpetusDir.INSTANCE));
    public static final ActionRegistryEntry CIRCLE$BOUNDS$MIN = HexActions.make("circle/bounds/min", new ActionRegistryEntry(HexPattern.fromAngles("eaqwqaewdd", HexDir.SOUTH_WEST), new OpCircleBounds(false)));
    public static final ActionRegistryEntry CIRCLE$BOUNDS$MAX = HexActions.make("circle/bounds/max", new ActionRegistryEntry(HexPattern.fromAngles("aqwqawaaqa", HexDir.WEST), new OpCircleBounds(true)));
    public static final ActionRegistryEntry SWAP = HexActions.make("swap", new ActionRegistryEntry(HexPattern.fromAngles("aawdd", HexDir.EAST), new OpTwiddling(2, new int[]{1, 0})));
    public static final ActionRegistryEntry ROTATE = HexActions.make("rotate", new ActionRegistryEntry(HexPattern.fromAngles("aaeaa", HexDir.EAST), new OpTwiddling(3, new int[]{1, 2, 0})));
    public static final ActionRegistryEntry ROTATE_REVERSE = HexActions.make("rotate_reverse", new ActionRegistryEntry(HexPattern.fromAngles("ddqdd", HexDir.NORTH_EAST), new OpTwiddling(3, new int[]{2, 0, 1})));
    public static final ActionRegistryEntry DUPLICATE = HexActions.make("duplicate", new ActionRegistryEntry(HexPattern.fromAngles("aadaa", HexDir.EAST), new OpTwiddling(1, new int[]{0, 0})));
    public static final ActionRegistryEntry OVER = HexActions.make("over", new ActionRegistryEntry(HexPattern.fromAngles("aaedd", HexDir.EAST), new OpTwiddling(2, new int[]{0, 1, 0})));
    public static final ActionRegistryEntry TUCK = HexActions.make("tuck", new ActionRegistryEntry(HexPattern.fromAngles("ddqaa", HexDir.EAST), new OpTwiddling(2, new int[]{1, 0, 1})));
    public static final ActionRegistryEntry TWO_DUP = HexActions.make("2dup", new ActionRegistryEntry(HexPattern.fromAngles("aadadaaw", HexDir.EAST), new OpTwiddling(2, new int[]{0, 1, 0, 1})));
    public static final ActionRegistryEntry STACK_LEN = HexActions.make("stack_len", new ActionRegistryEntry(HexPattern.fromAngles("qwaeawqaeaqa", HexDir.NORTH_WEST), OpStackSize.INSTANCE));
    public static final ActionRegistryEntry DUPLICATE_N = HexActions.make("duplicate_n", new ActionRegistryEntry(HexPattern.fromAngles("aadaadaa", HexDir.EAST), OpDuplicateN.INSTANCE));
    public static final ActionRegistryEntry FISHERMAN = HexActions.make("fisherman", new ActionRegistryEntry(HexPattern.fromAngles("ddad", HexDir.WEST), OpFisherman.INSTANCE));
    public static final ActionRegistryEntry FISHERMAN$COPY = HexActions.make("fisherman/copy", new ActionRegistryEntry(HexPattern.fromAngles("aada", HexDir.EAST), OpFishermanButItCopies.INSTANCE));
    public static final ActionRegistryEntry SWIZZLE = HexActions.make("swizzle", new ActionRegistryEntry(HexPattern.fromAngles("qaawdde", HexDir.SOUTH_EAST), OpAlwinfyHasAscendedToABeingOfPureMath.INSTANCE));
    public static final ActionRegistryEntry ADD = HexActions.make("add", new OperationAction(HexPattern.fromAngles("waaw", HexDir.NORTH_EAST)));
    public static final ActionRegistryEntry SUB = HexActions.make("sub", new OperationAction(HexPattern.fromAngles("wddw", HexDir.NORTH_WEST)));
    public static final ActionRegistryEntry MUL_DOT = HexActions.make("mul", new OperationAction(HexPattern.fromAngles("waqaw", HexDir.SOUTH_EAST)));
    public static final ActionRegistryEntry DIV_CROSS = HexActions.make("div", new OperationAction(HexPattern.fromAngles("wdedw", HexDir.NORTH_EAST)));
    public static final ActionRegistryEntry ABS = HexActions.make("abs", new OperationAction(HexPattern.fromAngles("wqaqw", HexDir.NORTH_EAST)));
    public static final ActionRegistryEntry POW_PROJ = HexActions.make("pow", new OperationAction(HexPattern.fromAngles("wedew", HexDir.NORTH_WEST)));
    public static final ActionRegistryEntry FLOOR = HexActions.make("floor", new OperationAction(HexPattern.fromAngles("ewq", HexDir.EAST)));
    public static final ActionRegistryEntry CEIL = HexActions.make("ceil", new OperationAction(HexPattern.fromAngles("qwe", HexDir.EAST)));
    public static final ActionRegistryEntry CONSTRUCT_VEC = HexActions.make("construct_vec", new OperationAction(HexPattern.fromAngles("eqqqqq", HexDir.EAST)));
    public static final ActionRegistryEntry DECONSTRUCT_VEC = HexActions.make("deconstruct_vec", new OperationAction(HexPattern.fromAngles("qeeeee", HexDir.EAST)));
    public static final ActionRegistryEntry COERCE_AXIAL = HexActions.make("coerce_axial", new ActionRegistryEntry(HexPattern.fromAngles("qqqqqaww", HexDir.NORTH_WEST), OpCoerceToAxial.INSTANCE));
    public static final ActionRegistryEntry AND = HexActions.make("and", new OperationAction(HexPattern.fromAngles("wdw", HexDir.NORTH_EAST)));
    public static final ActionRegistryEntry OR = HexActions.make("or", new OperationAction(HexPattern.fromAngles("waw", HexDir.SOUTH_EAST)));
    public static final ActionRegistryEntry NOT = HexActions.make("not", new OperationAction(HexPattern.fromAngles("dw", HexDir.NORTH_WEST)));
    public static final ActionRegistryEntry XOR = HexActions.make("xor", new OperationAction(HexPattern.fromAngles("dwa", HexDir.NORTH_WEST)));
    public static final ActionRegistryEntry GREATER = HexActions.make("greater", new OperationAction(HexPattern.fromAngles("e", HexDir.SOUTH_EAST)));
    public static final ActionRegistryEntry LESS = HexActions.make("less", new OperationAction(HexPattern.fromAngles("q", HexDir.SOUTH_WEST)));
    public static final ActionRegistryEntry GREATER_EQ = HexActions.make("greater_eq", new OperationAction(HexPattern.fromAngles("ee", HexDir.SOUTH_EAST)));
    public static final ActionRegistryEntry LESS_EQ = HexActions.make("less_eq", new OperationAction(HexPattern.fromAngles("qq", HexDir.SOUTH_WEST)));
    public static final ActionRegistryEntry EQUALS = HexActions.make("equals", new ActionRegistryEntry(HexPattern.fromAngles("ad", HexDir.EAST), new OpEquality(false)));
    public static final ActionRegistryEntry NOT_EQUALS = HexActions.make("not_equals", new ActionRegistryEntry(HexPattern.fromAngles("da", HexDir.EAST), new OpEquality(true)));
    public static final ActionRegistryEntry BOOL_COERCE = HexActions.make("bool_coerce", new ActionRegistryEntry(HexPattern.fromAngles("aw", HexDir.NORTH_EAST), OpCoerceToBool.INSTANCE));
    public static final ActionRegistryEntry IF = HexActions.make("if", new ActionRegistryEntry(HexPattern.fromAngles("awdd", HexDir.SOUTH_EAST), OpBoolIf.INSTANCE));
    public static final ActionRegistryEntry RANDOM = HexActions.make("random", new ActionRegistryEntry(HexPattern.fromAngles("eqqq", HexDir.NORTH_WEST), OpRandom.INSTANCE));
    public static final ActionRegistryEntry SIN = HexActions.make("sin", new OperationAction(HexPattern.fromAngles("qqqqqaa", HexDir.SOUTH_EAST)));
    public static final ActionRegistryEntry COS = HexActions.make("cos", new OperationAction(HexPattern.fromAngles("qqqqqad", HexDir.SOUTH_EAST)));
    public static final ActionRegistryEntry TAN = HexActions.make("tan", new OperationAction(HexPattern.fromAngles("wqqqqqadq", HexDir.SOUTH_WEST)));
    public static final ActionRegistryEntry ARCSIN = HexActions.make("arcsin", new OperationAction(HexPattern.fromAngles("ddeeeee", HexDir.SOUTH_EAST)));
    public static final ActionRegistryEntry ARCCOS = HexActions.make("arccos", new OperationAction(HexPattern.fromAngles("adeeeee", HexDir.NORTH_EAST)));
    public static final ActionRegistryEntry ARCTAN = HexActions.make("arctan", new OperationAction(HexPattern.fromAngles("eadeeeeew", HexDir.NORTH_EAST)));
    public static final ActionRegistryEntry ARCTAN2 = HexActions.make("arctan2", new OperationAction(HexPattern.fromAngles("deadeeeeewd", HexDir.WEST)));
    public static final ActionRegistryEntry LOGARITHM = HexActions.make("logarithm", new OperationAction(HexPattern.fromAngles("eqaqe", HexDir.NORTH_WEST)));
    public static final ActionRegistryEntry MODULO = HexActions.make("modulo", new OperationAction(HexPattern.fromAngles("addwaad", HexDir.NORTH_EAST)));
    public static final ActionRegistryEntry UNIQUE = HexActions.make("unique", new OperationAction(HexPattern.fromAngles("aweaqa", HexDir.NORTH_EAST)));
    public static final ActionRegistryEntry PRINT = HexActions.make("print", new ActionRegistryEntry(HexPattern.fromAngles("de", HexDir.NORTH_EAST), OpPrint.INSTANCE));
    public static final ActionRegistryEntry EXPLODE = HexActions.make("explode", new ActionRegistryEntry(HexPattern.fromAngles("aawaawaa", HexDir.EAST), new OpExplode(false)));
    public static final ActionRegistryEntry EXPLODE$FIRE = HexActions.make("explode/fire", new ActionRegistryEntry(HexPattern.fromAngles("ddwddwdd", HexDir.EAST), new OpExplode(true)));
    public static final ActionRegistryEntry ADD_MOTION = HexActions.make("add_motion", new ActionRegistryEntry(HexPattern.fromAngles("awqqqwaqw", HexDir.SOUTH_WEST), OpAddMotion.INSTANCE));
    public static final ActionRegistryEntry BLINK = HexActions.make("blink", new ActionRegistryEntry(HexPattern.fromAngles("awqqqwaq", HexDir.SOUTH_WEST), OpBlink.INSTANCE));
    public static final ActionRegistryEntry BREAK_BLOCK = HexActions.make("break_block", new ActionRegistryEntry(HexPattern.fromAngles("qaqqqqq", HexDir.EAST), OpBreakBlock.INSTANCE));
    public static final ActionRegistryEntry PLACE_BLOCK = HexActions.make("place_block", new ActionRegistryEntry(HexPattern.fromAngles("eeeeede", HexDir.SOUTH_WEST), OpPlaceBlock.INSTANCE));
    public static final ActionRegistryEntry COLORIZE = HexActions.make("colorize", new ActionRegistryEntry(HexPattern.fromAngles("awddwqawqwawq", HexDir.EAST), OpColorize.INSTANCE));
    public static final ActionRegistryEntry CYCLE_VARIANT = HexActions.make("cycle_variant", new ActionRegistryEntry(HexPattern.fromAngles("dwaawedwewdwe", HexDir.WEST), OpCycleVariant.INSTANCE));
    public static final ActionRegistryEntry CREATE_WATER = HexActions.make("create_water", new ActionRegistryEntry(HexPattern.fromAngles("aqawqadaq", HexDir.SOUTH_EAST), new OpCreateFluid(10000L, Items.WATER_BUCKET, (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3)), (Fluid)Fluids.WATER)));
    public static final ActionRegistryEntry DESTROY_WATER = HexActions.make("destroy_water", new ActionRegistryEntry(HexPattern.fromAngles("dedwedade", HexDir.SOUTH_WEST), OpDestroyFluid.INSTANCE));
    public static final ActionRegistryEntry IGNITE = HexActions.make("ignite", new ActionRegistryEntry(HexPattern.fromAngles("aaqawawa", HexDir.SOUTH_EAST), OpIgnite.INSTANCE));
    public static final ActionRegistryEntry EXTINGUISH = HexActions.make("extinguish", new ActionRegistryEntry(HexPattern.fromAngles("ddedwdwd", HexDir.SOUTH_WEST), OpExtinguish.INSTANCE));
    public static final ActionRegistryEntry CONJURE_BLOCK = HexActions.make("conjure_block", new ActionRegistryEntry(HexPattern.fromAngles("qqa", HexDir.NORTH_EAST), new OpConjureBlock(false)));
    public static final ActionRegistryEntry CONJURE_LIGHT = HexActions.make("conjure_light", new ActionRegistryEntry(HexPattern.fromAngles("qqd", HexDir.NORTH_EAST), new OpConjureBlock(true)));
    public static final ActionRegistryEntry BONEMEAL = HexActions.make("bonemeal", new ActionRegistryEntry(HexPattern.fromAngles("wqaqwawqaqw", HexDir.NORTH_EAST), OpTheOnlyReasonAnyoneDownloadedPsi.INSTANCE));
    public static final ActionRegistryEntry RECHARGE = HexActions.make("recharge", new ActionRegistryEntry(HexPattern.fromAngles("qqqqqwaeaeaeaeaea", HexDir.NORTH_WEST), OpRecharge.INSTANCE));
    public static final ActionRegistryEntry ERASE = HexActions.make("erase", new ActionRegistryEntry(HexPattern.fromAngles("qdqawwaww", HexDir.EAST), OpErase.INSTANCE));
    public static final ActionRegistryEntry EDIFY = HexActions.make("edify", new ActionRegistryEntry(HexPattern.fromAngles("wqaqwd", HexDir.NORTH_EAST), OpEdifySapling.INSTANCE));
    public static final ActionRegistryEntry BEEP = HexActions.make("beep", new ActionRegistryEntry(HexPattern.fromAngles("adaa", HexDir.WEST), OpBeep.INSTANCE));
    public static final ActionRegistryEntry CRAFT$CYPHER = HexActions.make("craft/cypher", new ActionRegistryEntry(HexPattern.fromAngles("waqqqqq", HexDir.EAST), new OpMakePackagedSpell(s -> s.is((Item)HexItems.CYPHER) || s.is((Item)HexItems.ANCIENT_CYPHER), () -> ((ItemCypher)HexItems.CYPHER).getDescription(), 100000L)));
    public static final ActionRegistryEntry CRAFT$TRINKET = HexActions.make("craft/trinket", new ActionRegistryEntry(HexPattern.fromAngles("wwaqqqqqeaqeaeqqqeaeq", HexDir.EAST), new OpMakePackagedSpell(HexItems.TRINKET, 500000L)));
    public static final ActionRegistryEntry CRAFT$ARTIFACT = HexActions.make("craft/artifact", new ActionRegistryEntry(HexPattern.fromAngles("wwaqqqqqeawqwqwqwqwqwwqqeadaeqqeqqeadaeqq", HexDir.EAST), new OpMakePackagedSpell(HexItems.ARTIFACT, 1000000L)));
    public static final ActionRegistryEntry CRAFT$BATTERY = HexActions.make("craft/battery", new ActionRegistryEntry(HexPattern.fromAngles("aqqqaqwwaqqqqqeqaqqqawwqwqwqwqwqw", HexDir.SOUTH_WEST), OpMakeBattery.INSTANCE));
    public static final ActionRegistryEntry POTION$WEAKNESS = HexActions.make("potion/weakness", new ActionRegistryEntry(HexPattern.fromAngles("qqqqqaqwawaw", HexDir.NORTH_WEST), new OpPotionEffect(MobEffects.WEAKNESS, 1000L, true, false)));
    public static final ActionRegistryEntry POTION$LEVITATION = HexActions.make("potion/levitation", new ActionRegistryEntry(HexPattern.fromAngles("qqqqqawwawawd", HexDir.WEST), new OpPotionEffect(MobEffects.LEVITATION, 2000L, false, false)));
    public static final ActionRegistryEntry POTION$WITHER = HexActions.make("potion/wither", new ActionRegistryEntry(HexPattern.fromAngles("qqqqqaewawawe", HexDir.SOUTH_WEST), new OpPotionEffect(MobEffects.WITHER, 10000L, true, false)));
    public static final ActionRegistryEntry POTION$POISON = HexActions.make("potion/poison", new ActionRegistryEntry(HexPattern.fromAngles("qqqqqadwawaww", HexDir.SOUTH_EAST), new OpPotionEffect(MobEffects.POISON, 3333L, true, false)));
    public static final ActionRegistryEntry POTION$SLOWNESS = HexActions.make("potion/slowness", new ActionRegistryEntry(HexPattern.fromAngles("qqqqqadwawaw", HexDir.SOUTH_EAST), new OpPotionEffect(MobEffects.MOVEMENT_SLOWDOWN, 3333L, true, false)));
    public static final ActionRegistryEntry POTION$REGENERATION = HexActions.make("potion/regeneration", new ActionRegistryEntry(HexPattern.fromAngles("qqqqaawawaedd", HexDir.NORTH_WEST), new OpPotionEffect(MobEffects.REGENERATION, 10000L, true, true)));
    public static final ActionRegistryEntry POTION$NIGHT_VISION = HexActions.make("potion/night_vision", new ActionRegistryEntry(HexPattern.fromAngles("qqqaawawaeqdd", HexDir.WEST), new OpPotionEffect(MobEffects.NIGHT_VISION, 2000L, false, true)));
    public static final ActionRegistryEntry POTION$ABSORPTION = HexActions.make("potion/absorption", new ActionRegistryEntry(HexPattern.fromAngles("qqaawawaeqqdd", HexDir.SOUTH_WEST), new OpPotionEffect(MobEffects.ABSORPTION, 10000L, true, true)));
    public static final ActionRegistryEntry POTION$HASTE = HexActions.make("potion/haste", new ActionRegistryEntry(HexPattern.fromAngles("qaawawaeqqqdd", HexDir.SOUTH_EAST), new OpPotionEffect(MobEffects.DIG_SPEED, 3333L, true, true)));
    public static final ActionRegistryEntry POTION$STRENGTH = HexActions.make("potion/strength", new ActionRegistryEntry(HexPattern.fromAngles("aawawaeqqqqdd", HexDir.EAST), new OpPotionEffect(MobEffects.DAMAGE_BOOST, 3333L, true, true)));
    public static final ActionRegistryEntry FLIGHT$RANGE = HexActions.make("flight/range", new ActionRegistryEntry(HexPattern.fromAngles("awawaawq", HexDir.SOUTH_WEST), new OpFlight(OpFlight.Type.LimitRange)));
    public static final ActionRegistryEntry FLIGHT$TIME = HexActions.make("flight/time", new ActionRegistryEntry(HexPattern.fromAngles("dwdwdewq", HexDir.NORTH_EAST), new OpFlight(OpFlight.Type.LimitTime)));
    public static final ActionRegistryEntry FLIGHT$CAN_FLY = HexActions.make("flight/can_fly", new ActionRegistryEntry(HexPattern.fromAngles("dwdwdeweaqa", HexDir.NORTH_EAST), OpCanEntityHexFly.INSTANCE));
    public static final ActionRegistryEntry SENTINEL$CREATE = HexActions.make("sentinel/create", new ActionRegistryEntry(HexPattern.fromAngles("waeawae", HexDir.EAST), new OpCreateSentinel(false)));
    public static final ActionRegistryEntry SENTINEL$DESTROY = HexActions.make("sentinel/destroy", new ActionRegistryEntry(HexPattern.fromAngles("qdwdqdw", HexDir.NORTH_EAST), OpDestroySentinel.INSTANCE));
    public static final ActionRegistryEntry SENTINEL$GET_POS = HexActions.make("sentinel/get_pos", new ActionRegistryEntry(HexPattern.fromAngles("waeawaede", HexDir.EAST), OpGetSentinelPos.INSTANCE));
    public static final ActionRegistryEntry SENTINEL$WAYFIND = HexActions.make("sentinel/wayfind", new ActionRegistryEntry(HexPattern.fromAngles("waeawaedwa", HexDir.EAST), OpGetSentinelWayfind.INSTANCE));
    public static final ActionRegistryEntry LIGHTNING = HexActions.make("lightning", new ActionRegistryEntry(HexPattern.fromAngles("waadwawdaaweewq", HexDir.EAST), OpLightning.INSTANCE));
    public static final ActionRegistryEntry ALTIORA = HexActions.make("flight", new ActionRegistryEntry(HexPattern.fromAngles("eawwaeawawaa", HexDir.NORTH_WEST), OpAltiora.INSTANCE));
    public static final ActionRegistryEntry CREATE_LAVA = HexActions.make("create_lava", new ActionRegistryEntry(HexPattern.fromAngles("eaqawqadaqd", HexDir.EAST), new OpCreateFluid(100000L, Items.LAVA_BUCKET, Blocks.LAVA_CAULDRON.defaultBlockState(), (Fluid)Fluids.LAVA)));
    public static final ActionRegistryEntry TELEPORT = HexActions.make("teleport/great", new ActionRegistryEntry(HexPattern.fromAngles("wwwqqqwwwqqeqqwwwqqwqqdqqqqqdqq", HexDir.EAST), OpTeleport.INSTANCE));
    public static final ActionRegistryEntry SENTINEL$GREAT = HexActions.make("sentinel/create/great", new ActionRegistryEntry(HexPattern.fromAngles("waeawaeqqqwqwqqwq", HexDir.EAST), new OpCreateSentinel(true)));
    public static final ActionRegistryEntry DISPEL_RAIN = HexActions.make("dispel_rain", new ActionRegistryEntry(HexPattern.fromAngles("eeewwweeewwaqqddqdqd", HexDir.EAST), new OpWeather(false)));
    public static final ActionRegistryEntry SUMMON_RAIN = HexActions.make("summon_rain", new ActionRegistryEntry(HexPattern.fromAngles("wwweeewwweewdawdwad", HexDir.WEST), new OpWeather(true)));
    public static final ActionRegistryEntry BRAINSWEEP = HexActions.make("brainsweep", new ActionRegistryEntry(HexPattern.fromAngles("qeqwqwqwqwqeqaeqeaqeqaeqaqded", HexDir.NORTH_EAST), OpBrainsweep.INSTANCE));
    public static final ActionRegistryEntry AKASHIC$READ = HexActions.make("akashic/read", new ActionRegistryEntry(HexPattern.fromAngles("qqqwqqqqqaq", HexDir.WEST), OpAkashicRead.INSTANCE));
    public static final ActionRegistryEntry AKASHIC$WRITE = HexActions.make("akashic/write", new ActionRegistryEntry(HexPattern.fromAngles("eeeweeeeede", HexDir.EAST), OpAkashicWrite.INSTANCE));
    public static final ActionRegistryEntry EVAL = HexActions.make("eval", new ActionRegistryEntry(HexPattern.fromAngles("deaqq", HexDir.SOUTH_EAST), OpEval.INSTANCE));
    public static final ActionRegistryEntry EVAL$CC = HexActions.make("eval/cc", new ActionRegistryEntry(HexPattern.fromAngles("qwaqde", HexDir.NORTH_WEST), OpEvalBreakable.INSTANCE));
    public static final ActionRegistryEntry HALT = HexActions.make("halt", new ActionRegistryEntry(HexPattern.fromAngles("aqdee", HexDir.SOUTH_WEST), OpHalt.INSTANCE));
    public static final ActionRegistryEntry READ = HexActions.make("read", new ActionRegistryEntry(HexPattern.fromAngles("aqqqqq", HexDir.EAST), OpRead.INSTANCE));
    public static final ActionRegistryEntry READ$ENTITY = HexActions.make("read/entity", new ActionRegistryEntry(HexPattern.fromAngles("wawqwqwqwqwqw", HexDir.EAST), OpTheCoolerRead.INSTANCE));
    public static final ActionRegistryEntry WRITE = HexActions.make("write", new ActionRegistryEntry(HexPattern.fromAngles("deeeee", HexDir.EAST), OpWrite.INSTANCE));
    public static final ActionRegistryEntry WRITE$ENTITY = HexActions.make("write/entity", new ActionRegistryEntry(HexPattern.fromAngles("wdwewewewewew", HexDir.EAST), OpTheCoolerWrite.INSTANCE));
    public static final ActionRegistryEntry READABLE = HexActions.make("readable", new ActionRegistryEntry(HexPattern.fromAngles("aqqqqqe", HexDir.EAST), OpReadable.INSTANCE));
    public static final ActionRegistryEntry READABLE$ENTITY = HexActions.make("readable/entity", new ActionRegistryEntry(HexPattern.fromAngles("wawqwqwqwqwqwew", HexDir.EAST), OpTheCoolerReadable.INSTANCE));
    public static final ActionRegistryEntry WRITABLE = HexActions.make("writable", new ActionRegistryEntry(HexPattern.fromAngles("deeeeeq", HexDir.EAST), OpWritable.INSTANCE));
    public static final ActionRegistryEntry WRITABLE$ENTITY = HexActions.make("writable/entity", new ActionRegistryEntry(HexPattern.fromAngles("wdwewewewewewqw", HexDir.EAST), OpTheCoolerWritable.INSTANCE));
    public static final ActionRegistryEntry READ$LOCAL = HexActions.make("read/local", new ActionRegistryEntry(HexPattern.fromAngles("qeewdweddw", HexDir.NORTH_EAST), OpPeekLocal.INSTANCE));
    public static final ActionRegistryEntry WRITE$LOCAL = HexActions.make("write/local", new ActionRegistryEntry(HexPattern.fromAngles("eqqwawqaaw", HexDir.NORTH_WEST), OpPushLocal.INSTANCE));
    public static final ActionRegistryEntry THANATOS = HexActions.make("thanatos", new ActionRegistryEntry(HexPattern.fromAngles("qqaed", HexDir.SOUTH_EAST), OpThanos.INSTANCE));
    public static final ActionRegistryEntry CONST$NULL = HexActions.make("const/null", new ActionRegistryEntry(HexPattern.fromAngles("d", HexDir.EAST), Action.makeConstantOp(new NullIota())));
    public static final ActionRegistryEntry CONST$TRUE = HexActions.make("const/true", new ActionRegistryEntry(HexPattern.fromAngles("aqae", HexDir.SOUTH_EAST), Action.makeConstantOp(new BooleanIota(true))));
    public static final ActionRegistryEntry CONST$FALSE = HexActions.make("const/false", new ActionRegistryEntry(HexPattern.fromAngles("dedq", HexDir.NORTH_EAST), Action.makeConstantOp(new BooleanIota(false))));
    public static final ActionRegistryEntry CONST$VEC$PX = HexActions.make("const/vec/px", new ActionRegistryEntry(HexPattern.fromAngles("qqqqqea", HexDir.NORTH_WEST), Action.makeConstantOp(new Vec3Iota(new Vec3(1.0, 0.0, 0.0)))));
    public static final ActionRegistryEntry CONST$VEC$PY = HexActions.make("const/vec/py", new ActionRegistryEntry(HexPattern.fromAngles("qqqqqew", HexDir.NORTH_WEST), Action.makeConstantOp(new Vec3Iota(new Vec3(0.0, 1.0, 0.0)))));
    public static final ActionRegistryEntry CONST$VEC$PZ = HexActions.make("const/vec/pz", new ActionRegistryEntry(HexPattern.fromAngles("qqqqqed", HexDir.NORTH_WEST), Action.makeConstantOp(new Vec3Iota(new Vec3(0.0, 0.0, 1.0)))));
    public static final ActionRegistryEntry CONST$VEC$NX = HexActions.make("const/vec/nx", new ActionRegistryEntry(HexPattern.fromAngles("eeeeeqa", HexDir.SOUTH_WEST), Action.makeConstantOp(new Vec3Iota(new Vec3(-1.0, 0.0, 0.0)))));
    public static final ActionRegistryEntry CONST$VEC$NY = HexActions.make("const/vec/ny", new ActionRegistryEntry(HexPattern.fromAngles("eeeeeqw", HexDir.SOUTH_WEST), Action.makeConstantOp(new Vec3Iota(new Vec3(0.0, -1.0, 0.0)))));
    public static final ActionRegistryEntry CONST$VEC$NZ = HexActions.make("const/vec/nz", new ActionRegistryEntry(HexPattern.fromAngles("eeeeeqd", HexDir.SOUTH_WEST), Action.makeConstantOp(new Vec3Iota(new Vec3(0.0, 0.0, -1.0)))));
    public static final ActionRegistryEntry CONST$VEC$0 = HexActions.make("const/vec/0", new ActionRegistryEntry(HexPattern.fromAngles("qqqqq", HexDir.NORTH_WEST), Action.makeConstantOp(new Vec3Iota(new Vec3(0.0, 0.0, 0.0)))));
    public static final ActionRegistryEntry CONST$DOUBLE$PI = HexActions.make("const/double/pi", new ActionRegistryEntry(HexPattern.fromAngles("qdwdq", HexDir.NORTH_EAST), Action.makeConstantOp(new DoubleIota(Math.PI))));
    public static final ActionRegistryEntry CONST$DOUBLE$TAU = HexActions.make("const/double/tau", new ActionRegistryEntry(HexPattern.fromAngles("eawae", HexDir.NORTH_WEST), Action.makeConstantOp(new DoubleIota(Math.PI * 2))));
    public static final ActionRegistryEntry CONST$E = HexActions.make("const/double/e", new ActionRegistryEntry(HexPattern.fromAngles("aaq", HexDir.EAST), Action.makeConstantOp(new DoubleIota(Math.E))));
    public static final ActionRegistryEntry GET_ENTITY = HexActions.make("get_entity", new ActionRegistryEntry(HexPattern.fromAngles("qqqqqdaqa", HexDir.SOUTH_EAST), new OpGetEntityAt(e -> true)));
    public static final ActionRegistryEntry GET_ENTITY$ANIMAL = HexActions.make("get_entity/animal", new ActionRegistryEntry(HexPattern.fromAngles("qqqqqdaqaawa", HexDir.SOUTH_EAST), new OpGetEntityAt(OpGetEntitiesBy::isAnimal)));
    public static final ActionRegistryEntry GET_ENTITY$MONSTER = HexActions.make("get_entity/monster", new ActionRegistryEntry(HexPattern.fromAngles("qqqqqdaqaawq", HexDir.SOUTH_EAST), new OpGetEntityAt(OpGetEntitiesBy::isMonster)));
    public static final ActionRegistryEntry GET_ENTITY$ITEM = HexActions.make("get_entity/item", new ActionRegistryEntry(HexPattern.fromAngles("qqqqqdaqaaww", HexDir.SOUTH_EAST), new OpGetEntityAt(OpGetEntitiesBy::isItem)));
    public static final ActionRegistryEntry GET_ENTITY$PLAYER = HexActions.make("get_entity/player", new ActionRegistryEntry(HexPattern.fromAngles("qqqqqdaqaawe", HexDir.SOUTH_EAST), new OpGetEntityAt(OpGetEntitiesBy::isPlayer)));
    public static final ActionRegistryEntry GET_ENTITY$LIVING = HexActions.make("get_entity/living", new ActionRegistryEntry(HexPattern.fromAngles("qqqqqdaqaawd", HexDir.SOUTH_EAST), new OpGetEntityAt(OpGetEntitiesBy::isLiving)));
    public static final ActionRegistryEntry ZONE_ENTITY = HexActions.make("zone_entity", new ActionRegistryEntry(HexPattern.fromAngles("qqqqqwded", HexDir.SOUTH_EAST), new OpGetEntitiesBy(e -> true, false)));
    public static final ActionRegistryEntry ZONE_ENTITY$ANIMAL = HexActions.make("zone_entity/animal", new ActionRegistryEntry(HexPattern.fromAngles("qqqqqwdeddwa", HexDir.SOUTH_EAST), new OpGetEntitiesBy(OpGetEntitiesBy::isAnimal, false)));
    public static final ActionRegistryEntry ZONE_ENTITY$NOT_ANIMAL = HexActions.make("zone_entity/not_animal", new ActionRegistryEntry(HexPattern.fromAngles("eeeeewaqaawa", HexDir.NORTH_EAST), new OpGetEntitiesBy(OpGetEntitiesBy::isAnimal, true)));
    public static final ActionRegistryEntry ZONE_ENTITY$MONSTER = HexActions.make("zone_entity/monster", new ActionRegistryEntry(HexPattern.fromAngles("qqqqqwdeddwq", HexDir.SOUTH_EAST), new OpGetEntitiesBy(OpGetEntitiesBy::isMonster, false)));
    public static final ActionRegistryEntry ZONE_ENTITY$NOT_MONSTER = HexActions.make("zone_entity/not_monster", new ActionRegistryEntry(HexPattern.fromAngles("eeeeewaqaawq", HexDir.NORTH_EAST), new OpGetEntitiesBy(OpGetEntitiesBy::isMonster, true)));
    public static final ActionRegistryEntry ZONE_ENTITY$ITEM = HexActions.make("zone_entity/item", new ActionRegistryEntry(HexPattern.fromAngles("qqqqqwdeddww", HexDir.SOUTH_EAST), new OpGetEntitiesBy(OpGetEntitiesBy::isItem, false)));
    public static final ActionRegistryEntry ZONE_ENTITY$NOT_ITEM = HexActions.make("zone_entity/not_item", new ActionRegistryEntry(HexPattern.fromAngles("eeeeewaqaaww", HexDir.NORTH_EAST), new OpGetEntitiesBy(OpGetEntitiesBy::isItem, true)));
    public static final ActionRegistryEntry ZONE_ENTITY$PLAYER = HexActions.make("zone_entity/player", new ActionRegistryEntry(HexPattern.fromAngles("qqqqqwdeddwe", HexDir.SOUTH_EAST), new OpGetEntitiesBy(OpGetEntitiesBy::isPlayer, false)));
    public static final ActionRegistryEntry ZONE_ENTITY$NOT_PLAYER = HexActions.make("zone_entity/not_player", new ActionRegistryEntry(HexPattern.fromAngles("eeeeewaqaawe", HexDir.NORTH_EAST), new OpGetEntitiesBy(OpGetEntitiesBy::isPlayer, true)));
    public static final ActionRegistryEntry ZONE_ENTITY$LIVING = HexActions.make("zone_entity/living", new ActionRegistryEntry(HexPattern.fromAngles("qqqqqwdeddwd", HexDir.SOUTH_EAST), new OpGetEntitiesBy(OpGetEntitiesBy::isLiving, false)));
    public static final ActionRegistryEntry ZONE_ENTITY$NOT_LIVING = HexActions.make("zone_entity/not_living", new ActionRegistryEntry(HexPattern.fromAngles("eeeeewaqaawd", HexDir.NORTH_EAST), new OpGetEntitiesBy(OpGetEntitiesBy::isLiving, true)));
    public static final ActionRegistryEntry APPEND = HexActions.make("append", new OperationAction(HexPattern.fromAngles("edqde", HexDir.SOUTH_WEST)));
    public static final ActionRegistryEntry UNAPPEND = HexActions.make("unappend", new OperationAction(HexPattern.fromAngles("qaeaq", HexDir.NORTH_WEST)));
    public static final ActionRegistryEntry INDEX = HexActions.make("index", new OperationAction(HexPattern.fromAngles("deeed", HexDir.NORTH_WEST)));
    public static final ActionRegistryEntry FOR_EACH = HexActions.make("for_each", new ActionRegistryEntry(HexPattern.fromAngles("dadad", HexDir.NORTH_EAST), OpForEach.INSTANCE));
    public static final ActionRegistryEntry SINGLETON = HexActions.make("singleton", new ActionRegistryEntry(HexPattern.fromAngles("adeeed", HexDir.EAST), OpSingleton.INSTANCE));
    public static final ActionRegistryEntry EMPTY_LIST = HexActions.make("empty_list", new ActionRegistryEntry(HexPattern.fromAngles("qqaeaae", HexDir.NORTH_EAST), OpEmptyList.INSTANCE));
    public static final ActionRegistryEntry REVERSE = HexActions.make("reverse", new OperationAction(HexPattern.fromAngles("qqqaede", HexDir.EAST)));
    public static final ActionRegistryEntry LAST_N_LIST = HexActions.make("last_n_list", new ActionRegistryEntry(HexPattern.fromAngles("ewdqdwe", HexDir.SOUTH_WEST), OpLastNToList.INSTANCE));
    public static final ActionRegistryEntry SPLAT = HexActions.make("splat", new ActionRegistryEntry(HexPattern.fromAngles("qwaeawq", HexDir.NORTH_WEST), OpSplat.INSTANCE));
    public static final ActionRegistryEntry INDEX_OF = HexActions.make("index_of", new OperationAction(HexPattern.fromAngles("dedqde", HexDir.EAST)));
    public static final ActionRegistryEntry REMOVE_FROM = HexActions.make("remove_from", new OperationAction(HexPattern.fromAngles("edqdewaqa", HexDir.SOUTH_WEST)));
    public static final ActionRegistryEntry SLICE = HexActions.make("slice", new OperationAction(HexPattern.fromAngles("qaeaqwded", HexDir.NORTH_WEST)));
    public static final ActionRegistryEntry REPLACE = HexActions.make("replace", new OperationAction(HexPattern.fromAngles("wqaeaqw", HexDir.NORTH_WEST)));
    public static final ActionRegistryEntry CONSTRUCT = HexActions.make("construct", new OperationAction(HexPattern.fromAngles("ddewedd", HexDir.SOUTH_EAST)));
    public static final ActionRegistryEntry DECONSTRUCT = HexActions.make("deconstruct", new OperationAction(HexPattern.fromAngles("aaqwqaa", HexDir.SOUTH_WEST)));

    public static ActionRegistryEntry make(String name, ActionRegistryEntry are) {
        ActionRegistryEntry old = ACTIONS.put(HexAPI.modLoc(name), are);
        if (old != null) {
            throw new IllegalArgumentException("Typo? Duplicate id " + name);
        }
        return are;
    }

    public static ActionRegistryEntry make(String name, OperationAction oa) {
        ActionRegistryEntry are = new ActionRegistryEntry(oa.getPattern(), oa);
        ActionRegistryEntry old = ACTIONS.put(HexAPI.modLoc(name), are);
        if (old != null) {
            throw new IllegalArgumentException("Typo? Duplicate id " + name);
        }
        return are;
    }

    public static void register(BiConsumer<ActionRegistryEntry, ResourceLocation> r) {
        for (Map.Entry<ResourceLocation, ActionRegistryEntry> e : ACTIONS.entrySet()) {
            r.accept(e.getValue(), e.getKey());
        }
    }

    static {
        if (PehkuiInterop.isActive()) {
            HexActions.make("interop/pehkui/get", new ActionRegistryEntry(HexPattern.fromAngles("aawawwawwa", HexDir.NORTH_WEST), OpGetScale.INSTANCE));
            HexActions.make("interop/pehkui/set", new ActionRegistryEntry(HexPattern.fromAngles("ddwdwwdwwd", HexDir.NORTH_EAST), OpSetScale.INSTANCE));
        }
    }
}

