/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.lib;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.common.items.storage.ItemScroll;
import at.petrak.hexcasting.common.lib.HexItems;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class HexCreativeTabs {
    private static final Map<ResourceLocation, CreativeModeTab> TABS = new LinkedHashMap<ResourceLocation, CreativeModeTab>();
    public static final CreativeModeTab HEX = HexCreativeTabs.register("hexcasting", CreativeModeTab.builder((CreativeModeTab.Row)CreativeModeTab.Row.TOP, (int)7).icon(() -> new ItemStack((ItemLike)HexItems.SPELLBOOK)));
    public static final CreativeModeTab SCROLLS = HexCreativeTabs.register("scrolls", CreativeModeTab.builder((CreativeModeTab.Row)CreativeModeTab.Row.TOP, (int)7).icon(() -> ItemScroll.withPerWorldPattern(new ItemStack((ItemLike)HexItems.SCROLL_LARGE), "")));

    public static void registerCreativeTabs(BiConsumer<CreativeModeTab, ResourceLocation> r) {
        for (Map.Entry<ResourceLocation, CreativeModeTab> e : TABS.entrySet()) {
            r.accept(e.getValue(), e.getKey());
        }
    }

    private static CreativeModeTab register(String name, CreativeModeTab.Builder tabBuilder) {
        CreativeModeTab tab = tabBuilder.title((Component)Component.translatable((String)("itemGroup.hexcasting." + name))).build();
        CreativeModeTab old = TABS.put(HexAPI.modLoc(name), tab);
        if (old != null) {
            throw new IllegalArgumentException("Typo? Duplicate id " + name);
        }
        return tab;
    }
}

