/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items.magic;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.circles.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.item.MediaHolderItem;
import at.petrak.hexcasting.api.misc.DiscoveryHandlers;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.items.ItemLoreFragment;
import at.petrak.hexcasting.common.items.magic.ItemMediaHolder;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.lib.HexSounds;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class ItemCreativeUnlocker
extends Item
implements MediaHolderItem {
    public static final String DISPLAY_MEDIA = "media";
    public static final String DISPLAY_PATTERNS = "patterns";
    public static final String TAG_EXTRACTIONS = "extractions";
    public static final String TAG_INSERTIONS = "insertions";

    public static boolean isDebug(ItemStack stack) {
        return ItemCreativeUnlocker.isDebug(stack, null);
    }

    public static boolean isDebug(ItemStack stack, String flag) {
        if (!stack.is((Item)HexItems.CREATIVE_UNLOCKER) || !stack.hasCustomHoverName()) {
            return false;
        }
        List<String> keywords = Arrays.asList(stack.getHoverName().getString().toLowerCase(Locale.ROOT).split(" "));
        if (!keywords.contains("debug")) {
            return false;
        }
        return flag == null || keywords.contains(flag);
    }

    public static Component infiniteMedia(Level level) {
        String prefix = "item.hexcasting.creative_unlocker.";
        String emphasis = Language.getInstance().getOrDefault(prefix + "for_emphasis");
        MutableComponent emphasized = Component.empty();
        for (int i = 0; i < emphasis.length(); ++i) {
            emphasized.append((Component)ItemCreativeUnlocker.rainbow(Component.literal((String)("" + emphasis.charAt(i))), i, level));
        }
        return emphasized;
    }

    public ItemCreativeUnlocker(Item.Properties properties) {
        super(properties);
    }

    @Override
    public long getMedia(ItemStack stack) {
        return Long.MAX_VALUE;
    }

    @Override
    public long getMaxMedia(ItemStack stack) {
        return Long.MAX_VALUE;
    }

    @Override
    public void setMedia(ItemStack stack, long media) {
    }

    @Override
    public boolean canProvideMedia(ItemStack stack) {
        return true;
    }

    @Override
    public boolean canRecharge(ItemStack stack) {
        return true;
    }

    public static void addToIntArray(ItemStack stack, String tag, int n) {
        int[] arr = NBTHelper.getIntArray(stack, tag);
        if (arr == null) {
            arr = new int[]{};
        }
        int[] newArr = Arrays.copyOf(arr, arr.length + 1);
        newArr[newArr.length - 1] = n;
        NBTHelper.putIntArray(stack, tag, newArr);
    }

    public static void addToLongArray(ItemStack stack, String tag, long n) {
        long[] arr = NBTHelper.getLongArray(stack, tag);
        if (arr == null) {
            arr = new long[]{};
        }
        long[] newArr = Arrays.copyOf(arr, arr.length + 1);
        newArr[newArr.length - 1] = n;
        NBTHelper.putLongArray(stack, tag, newArr);
    }

    @Override
    public long withdrawMedia(ItemStack stack, long cost, boolean simulate) {
        if (!simulate && ItemCreativeUnlocker.isDebug(stack, DISPLAY_MEDIA)) {
            ItemCreativeUnlocker.addToLongArray(stack, TAG_EXTRACTIONS, cost);
        }
        return cost < 0L ? this.getMedia(stack) : cost;
    }

    @Override
    public long insertMedia(ItemStack stack, long amount, boolean simulate) {
        if (!simulate && ItemCreativeUnlocker.isDebug(stack, DISPLAY_MEDIA)) {
            ItemCreativeUnlocker.addToLongArray(stack, TAG_INSERTIONS, amount);
        }
        return amount < 0L ? this.getMaxMedia(stack) : amount;
    }

    public boolean isFoil(ItemStack stack) {
        return super.isFoil(stack) || ItemCreativeUnlocker.isDebug(stack);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (ItemCreativeUnlocker.isDebug(stack, DISPLAY_MEDIA) && !level.isClientSide) {
            this.debugDisplay(stack, TAG_EXTRACTIONS, "withdrawn", "all_media", entity);
            this.debugDisplay(stack, TAG_INSERTIONS, "inserted", "infinite_media", entity);
        }
    }

    private void debugDisplay(ItemStack stack, String tag, String langKey, String allKey, Entity entity) {
        long[] arr = NBTHelper.getLongArray(stack, tag);
        if (arr != null) {
            NBTHelper.remove(stack, tag);
            for (long i : arr) {
                if (i < 0L) {
                    entity.sendSystemMessage((Component)Component.translatable((String)("hexcasting.debug.media_" + langKey), (Object[])new Object[]{stack.getDisplayName(), Component.translatable((String)("hexcasting.debug." + allKey)).withStyle(ChatFormatting.GRAY)}).withStyle(ChatFormatting.LIGHT_PURPLE));
                    continue;
                }
                entity.sendSystemMessage((Component)Component.translatable((String)("hexcasting.debug.media_" + langKey + ".with_dust"), (Object[])new Object[]{stack.getDisplayName(), Component.literal((String)("" + i)).withStyle(ChatFormatting.WHITE), Component.literal((String)String.format("%.2f", (double)i * 1.0 / 10000.0)).withStyle(ChatFormatting.WHITE)}).withStyle(ChatFormatting.LIGHT_PURPLE));
            }
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockEntity be = context.getLevel().getBlockEntity(context.getClickedPos());
        if (be instanceof BlockEntityAbstractImpetus) {
            BlockEntityAbstractImpetus impetus = (BlockEntityAbstractImpetus)be;
            impetus.setInfiniteMedia();
            context.getLevel().playSound(null, context.getClickedPos(), HexSounds.SPELL_CIRCLE_FIND_BLOCK, SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide());
        }
        return InteractionResult.PASS;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity consumer) {
        if (level instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            if (consumer instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)consumer;
                ArrayList<ResourceLocation> names = new ArrayList<ResourceLocation>(ItemLoreFragment.NAMES);
                names.add(0, HexAPI.modLoc("root"));
                for (ResourceLocation name : names) {
                    Advancement rootAdv = slevel.getServer().getAdvancements().getAdvancement(name);
                    if (rootAdv == null) continue;
                    ArrayList<Advancement> children = new ArrayList<Advancement>();
                    children.add(rootAdv);
                    ItemCreativeUnlocker.addChildren(rootAdv, children);
                    PlayerAdvancements adman = player.getAdvancements();
                    for (Advancement kid : children) {
                        AdvancementProgress progress = adman.getOrStartProgress(kid);
                        if (progress.isDone()) continue;
                        for (String crit : progress.getRemainingCriteria()) {
                            adman.award(kid, crit);
                        }
                    }
                }
            }
        }
        ItemStack copy = stack.copy();
        super.finishUsingItem(stack, level, consumer);
        return copy;
    }

    private static MutableComponent rainbow(MutableComponent component, int shift, Level level) {
        if (level == null) {
            return component.withStyle(ChatFormatting.WHITE);
        }
        return component.withStyle(s -> s.withColor(TextColor.fromRgb((int)Mth.hsvToRgb((float)((float)((level.getGameTime() + (long)shift) * 2L % 360L) / 360.0f), (float)1.0f, (float)1.0f))));
    }

    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        Component emphasized = ItemCreativeUnlocker.infiniteMedia(level);
        MutableComponent modName = Component.translatable((String)"item.hexcasting.creative_unlocker.mod_name").withStyle(s -> s.withColor(ItemMediaHolder.HEX_COLOR));
        tooltipComponents.add((Component)Component.translatable((String)"hexcasting.spelldata.onitem", (Object[])new Object[]{emphasized}).withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"item.hexcasting.creative_unlocker.tooltip", (Object[])new Object[]{modName}).withStyle(ChatFormatting.GRAY));
    }

    private static void addChildren(Advancement root, List<Advancement> out) {
        for (Advancement kiddo : root.getChildren()) {
            out.add(kiddo);
            ItemCreativeUnlocker.addChildren(kiddo, out);
        }
    }

    static {
        DiscoveryHandlers.addDebugItemDiscoverer((player, type) -> {
            for (ItemStack item : player.getInventory().items) {
                if (!ItemCreativeUnlocker.isDebug(item, type)) continue;
                return item;
            }
            for (ItemStack item : player.getInventory().armor) {
                if (!ItemCreativeUnlocker.isDebug(item, type)) continue;
                return item;
            }
            for (ItemStack item : player.getInventory().offhand) {
                if (!ItemCreativeUnlocker.isDebug(item, type)) continue;
                return item;
            }
            return ItemStack.EMPTY;
        });
    }
}

