/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items.magic;

import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.items.magic.ItemCypher;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemAncientCypher
extends ItemCypher {
    public static final String TAG_PATTERNS = "patterns";
    public static final String TAG_HEX_NAME = "hex_name";

    public ItemAncientCypher(Item.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public void clearHex(ItemStack stack) {
        super.clearHex(stack);
        NBTHelper.remove(stack, TAG_HEX_NAME);
    }

    public Component getName(ItemStack pStack) {
        String descID = this.getDescriptionId(pStack);
        String hexName = NBTHelper.getString(pStack, TAG_HEX_NAME);
        if (hexName != null) {
            return Component.translatable((String)(descID + ".preset"), (Object[])new Object[]{Component.translatable((String)hexName)});
        }
        return Component.translatable((String)descID);
    }

    @Override
    public void appendHoverText(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.appendHoverText(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        ListTag patternsTag = NBTHelper.getList(pStack, TAG_PATTERNS, 10);
        if (patternsTag != null) {
            MutableComponent storedHex = Component.translatable((String)"hexcasting.tooltip.stored_hex");
            for (Tag iotaTag : patternsTag) {
                CompoundTag iotaTagC = NBTHelper.getAsCompound(iotaTag);
                MutableComponent iotaComponent = IotaType.getDisplay(iotaTagC).copy();
                storedHex.append((Component)iotaComponent.withStyle(ChatFormatting.DARK_PURPLE));
            }
            pTooltipComponents.add((Component)storedHex);
        }
    }
}

