/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items;

import at.petrak.hexcasting.api.casting.eval.ResolvedPattern;
import at.petrak.hexcasting.api.casting.eval.vm.CastingVM;
import at.petrak.hexcasting.common.lib.HexAttributes;
import at.petrak.hexcasting.common.lib.HexSounds;
import at.petrak.hexcasting.common.msgs.MsgClearSpiralPatternsS2C;
import at.petrak.hexcasting.common.msgs.MsgOpenSpellGuiS2C;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.List;
import kotlin.Pair;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ItemStaff
extends Item {
    public static final ResourceLocation FUNNY_LEVEL_PREDICATE = new ResourceLocation("hexcasting", "funny_level");

    public ItemStaff(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ServerPlayer serverPlayer;
        if (player.getAttributeValue(HexAttributes.FEEBLE_MIND) > 0.0) {
            return InteractionResultHolder.fail((Object)player.getItemInHand(hand));
        }
        if (player.isShiftKeyDown()) {
            if (world.isClientSide()) {
                player.playSound(HexSounds.STAFF_RESET, 1.0f, 1.0f);
            } else if (player instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)player;
                IXplatAbstractions.INSTANCE.clearCastingData(serverPlayer);
                MsgClearSpiralPatternsS2C packet = new MsgClearSpiralPatternsS2C(player.getUUID());
                IXplatAbstractions.INSTANCE.sendPacketToPlayer(serverPlayer, packet);
                IXplatAbstractions.INSTANCE.sendPacketTracking((Entity)serverPlayer, packet);
            }
        }
        if (!world.isClientSide() && player instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)player;
            CastingVM vm = IXplatAbstractions.INSTANCE.getStaffcastVM(serverPlayer, hand);
            List<ResolvedPattern> patterns = IXplatAbstractions.INSTANCE.getPatternsSavedInUi(serverPlayer);
            Pair<List<CompoundTag>, CompoundTag> descs = vm.generateDescs();
            IXplatAbstractions.INSTANCE.sendPacketToPlayer(serverPlayer, new MsgOpenSpellGuiS2C(hand, patterns, (List)descs.getFirst(), (CompoundTag)descs.getSecond(), 0));
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }
}

