/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.entities;

import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.entities.HexEntities;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.lib.HexSounds;
import at.petrak.hexcasting.common.msgs.MsgNewWallScrollS2C;
import at.petrak.hexcasting.common.msgs.MsgRecalcWallScrollDisplayS2C;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityWallScroll
extends HangingEntity {
    private static final EntityDataAccessor<Boolean> SHOWS_STROKE_ORDER = SynchedEntityData.defineId(EntityWallScroll.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public ItemStack scroll;
    @Nullable
    public HexPattern pattern;
    public boolean isAncient;
    public int blockSize;

    public EntityWallScroll(EntityType<? extends EntityWallScroll> type, Level world) {
        super(type, world);
    }

    public EntityWallScroll(Level world, BlockPos pos, Direction dir, ItemStack scroll, boolean showStrokeOrder, int blockSize) {
        super(HexEntities.WALL_SCROLL, world, pos);
        this.setDirection(dir);
        this.blockSize = blockSize;
        this.entityData.set(SHOWS_STROKE_ORDER, (Object)showStrokeOrder);
        this.scroll = scroll;
        this.recalculateDisplay();
        this.recalculateBoundingBox();
    }

    public void recalculateDisplay() {
        CompoundTag patternTag = NBTHelper.getCompound(this.scroll, "pattern");
        if (patternTag != null) {
            this.pattern = HexPattern.fromNBT(patternTag);
            this.isAncient = NBTHelper.hasString(this.scroll, "op_id");
        } else {
            this.pattern = null;
            this.isAncient = false;
        }
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(SHOWS_STROKE_ORDER, (Object)false);
    }

    public boolean getShowsStrokeOrder() {
        return (Boolean)this.entityData.get(SHOWS_STROKE_ORDER);
    }

    public void setShowsStrokeOrder(boolean b) {
        this.entityData.set(SHOWS_STROKE_ORDER, (Object)b);
    }

    public int getWidth() {
        return 16 * this.blockSize;
    }

    public int getHeight() {
        return 16 * this.blockSize;
    }

    public void dropItem(@Nullable Entity pBrokenEntity) {
        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            this.playSound(SoundEvents.PAINTING_BREAK, 1.0f, 1.0f);
            if (pBrokenEntity instanceof Player) {
                Player player = (Player)pBrokenEntity;
                if (player.getAbilities().instabuild) {
                    return;
                }
            }
            this.spawnAtLocation(this.scroll);
        }
    }

    public InteractionResult interactAt(Player pPlayer, Vec3 pVec, InteractionHand pHand) {
        ItemStack handStack = pPlayer.getItemInHand(pHand);
        if (handStack.is(HexItems.AMETHYST_DUST) && !this.getShowsStrokeOrder()) {
            if (!pPlayer.getAbilities().instabuild) {
                handStack.shrink(1);
            }
            this.setShowsStrokeOrder(true);
            pPlayer.level().playSound(pPlayer, (Entity)this, HexSounds.SCROLL_DUST, SoundSource.PLAYERS, 1.0f, 1.0f);
            Level level = pPlayer.level();
            if (level instanceof ServerLevel) {
                ServerLevel slevel = (ServerLevel)level;
                IXplatAbstractions.INSTANCE.sendPacketNear(this.position(), 32.0, slevel, new MsgRecalcWallScrollDisplayS2C(this.getId(), true));
            } else {
                this.recalculateDisplay();
            }
            return InteractionResult.SUCCESS;
        }
        return super.interactAt(pPlayer, pVec, pHand);
    }

    public void playPlacementSound() {
        this.playSound(SoundEvents.PAINTING_PLACE, 1.0f, 1.0f);
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        return IXplatAbstractions.INSTANCE.toVanillaClientboundPacket(new MsgNewWallScrollS2C(new ClientboundAddEntityPacket((Entity)this), this.pos, this.direction, this.scroll, this.getShowsStrokeOrder(), this.blockSize));
    }

    public void readSpawnData(BlockPos pos, Direction dir, ItemStack scrollItem, boolean showsStrokeOrder, int blockSize) {
        this.pos = pos;
        this.scroll = scrollItem;
        this.blockSize = blockSize;
        this.setDirection(dir);
        this.setShowsStrokeOrder(showsStrokeOrder);
        this.recalculateDisplay();
        this.recalculateBoundingBox();
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putByte("direction", (byte)this.direction.ordinal());
        tag.put("scroll", (Tag)HexUtils.serializeToNBT(this.scroll));
        tag.putBoolean("showsStrokeOrder", this.getShowsStrokeOrder());
        tag.putInt("blockSize", this.blockSize);
        super.addAdditionalSaveData(tag);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        this.direction = Direction.values()[tag.getByte("direction")];
        this.scroll = ItemStack.of((CompoundTag)tag.getCompound("scroll"));
        this.blockSize = tag.getInt("blockSize");
        this.setDirection(this.direction);
        this.setShowsStrokeOrder(tag.getBoolean("showsStrokeOrder"));
        this.recalculateDisplay();
        this.recalculateBoundingBox();
        super.readAdditionalSaveData(tag);
    }

    public void moveTo(double pX, double pY, double pZ, float pYaw, float pPitch) {
        this.setPos(pX, pY, pZ);
    }

    public void lerpTo(double pX, double pY, double pZ, float pYaw, float pPitch, int pPosRotationIncrements, boolean pTeleport) {
        BlockPos blockpos = this.pos.offset((int)(pX - this.getX()), (int)(pY - this.getY()), (int)(pZ - this.getZ()));
        this.setPos(blockpos.getX(), blockpos.getY(), blockpos.getZ());
    }

    @Nullable
    public ItemStack getPickResult() {
        return this.scroll.copy();
    }
}

