/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.command;

import at.petrak.hexcasting.api.casting.ActionRegistryEntry;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.mod.HexTags;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.common.casting.PatternRegistryManifest;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class PatternResLocArgument
extends ResourceLocationArgument {
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_PATTERN = new DynamicCommandExceptionType(errorer -> Component.translatable((String)"hexcasting.pattern.unknown", (Object[])new Object[]{errorer}));

    public static PatternResLocArgument id() {
        return new PatternResLocArgument();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        ArrayList<String> suggestions = new ArrayList<String>();
        Registry<ActionRegistryEntry> registry = IXplatAbstractions.INSTANCE.getActionRegistry();
        for (ResourceKey key : registry.registryKeySet()) {
            if (!HexUtils.isOfTag(registry, key, HexTags.Actions.PER_WORLD_PATTERN)) continue;
            suggestions.add(key.location().toString());
        }
        return SharedSuggestionProvider.suggest(suggestions, (SuggestionsBuilder)builder);
    }

    public static HexPattern getPattern(CommandContext<CommandSourceStack> ctx, String argumentName) throws CommandSyntaxException {
        ResourceLocation targetId = (ResourceLocation)ctx.getArgument(argumentName, ResourceLocation.class);
        ResourceKey targetKey = ResourceKey.create((ResourceKey)IXplatAbstractions.INSTANCE.getActionRegistry().key(), (ResourceLocation)targetId);
        HexPattern foundPat = PatternRegistryManifest.getCanonicalStrokesPerWorld((ResourceKey<ActionRegistryEntry>)targetKey, ((CommandSourceStack)ctx.getSource()).getServer().overworld());
        if (foundPat == null) {
            throw ERROR_UNKNOWN_PATTERN.create((Object)targetId);
        }
        return foundPat;
    }
}

