/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.arithmetic.operator.vec;

import at.petrak.hexcasting.api.casting.arithmetic.IterPair;
import at.petrak.hexcasting.api.casting.arithmetic.TripleIterable;
import at.petrak.hexcasting.api.casting.arithmetic.operator.OperatorBasic;
import at.petrak.hexcasting.api.casting.arithmetic.predicates.IotaMultiPredicate;
import at.petrak.hexcasting.api.casting.arithmetic.predicates.IotaPredicate;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.iota.DoubleIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.Vec3Iota;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.api.casting.mishaps.MishapDivideByZero;
import at.petrak.hexcasting.common.casting.arithmetic.DoubleArithmetic;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class OperatorVec3Delegating
extends OperatorBasic {
    private final BiFunction<Vec3, Vec3, Iota> op;
    private final OperatorBasic fb;

    public OperatorVec3Delegating(BiFunction<Vec3, Vec3, Iota> core, HexPattern fallback) {
        super(2, IotaMultiPredicate.any(IotaPredicate.ofType(HexIotaTypes.VEC3), IotaPredicate.ofType(HexIotaTypes.DOUBLE)));
        this.op = core;
        this.fb = (OperatorBasic)Objects.requireNonNull(DoubleArithmetic.INSTANCE.getOperator(fallback));
    }

    @Override
    @NotNull
    public Iterable<Iota> apply(Iterable<? extends Iota> iotas, @NotNull CastingEnvironment env) throws Mishap {
        Iterator<? extends Iota> it = iotas.iterator();
        Iota left = it.next();
        Iota right = it.next();
        try {
            Vec3 vec3;
            Vec3Iota lh;
            if (this.op != null && left instanceof Vec3Iota) {
                lh = (Vec3Iota)left;
                if (right instanceof Vec3Iota) {
                    Vec3Iota rh = (Vec3Iota)right;
                    return List.of(this.op.apply(lh.getVec3(), rh.getVec3()));
                }
            }
            if (left instanceof Vec3Iota) {
                Vec3Iota l = (Vec3Iota)left;
                v0 = l.getVec3();
            } else {
                v0 = lh = OperatorVec3Delegating.triplicate(OperatorVec3Delegating.downcast(left, HexIotaTypes.DOUBLE).getDouble());
            }
            if (right instanceof Vec3Iota) {
                Vec3Iota r = (Vec3Iota)right;
                vec3 = r.getVec3();
            } else {
                vec3 = OperatorVec3Delegating.triplicate(OperatorVec3Delegating.downcast(right, HexIotaTypes.DOUBLE).getDouble());
            }
            Vec3 rh = vec3;
            return new TripleIterable(this.fb.apply(new IterPair<DoubleIota>(new DoubleIota(lh.x()), new DoubleIota(rh.x())), env), this.fb.apply(new IterPair<DoubleIota>(new DoubleIota(lh.y()), new DoubleIota(rh.y())), env), this.fb.apply(new IterPair<DoubleIota>(new DoubleIota(lh.z()), new DoubleIota(rh.z())), env), (x, y, z) -> new Vec3Iota(new Vec3(OperatorVec3Delegating.downcast(x, HexIotaTypes.DOUBLE).getDouble(), OperatorVec3Delegating.downcast(y, HexIotaTypes.DOUBLE).getDouble(), OperatorVec3Delegating.downcast(z, HexIotaTypes.DOUBLE).getDouble())));
        }
        catch (MishapDivideByZero e) {
            throw MishapDivideByZero.of(left, right, e.getSuffix());
        }
    }

    public static Vec3 triplicate(double in) {
        return new Vec3(in, in, in);
    }
}

