/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.actions.spells.great;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadLocation;
import at.petrak.hexcasting.api.casting.mishaps.MishapImmuneEntity;
import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.api.mod.HexTags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/great/OpTeleport;", "Lat/petrak/hexcasting/api/casting/castables/SpellAction;", "()V", "argc", "", "getArgc", "()I", "execute", "Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "args", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "teleportRespectSticky", "", "teleportee", "Lnet/minecraft/world/entity/Entity;", "delta", "Lnet/minecraft/world/phys/Vec3;", "world", "Lnet/minecraft/server/level/ServerLevel;", "Spell", "hexcasting-common-1.20.1"})
public final class OpTeleport
implements SpellAction {
    @NotNull
    public static final OpTeleport INSTANCE = new OpTeleport();
    private static final int argc = 2;

    private OpTeleport() {
    }

    @Override
    public int getArgc() {
        return argc;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SpellAction.Result execute(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Entity teleportee = OperatorUtils.getEntity(args, 0, this.getArgc());
        Vec3 delta = OperatorUtils.getVec3(args, 1, this.getArgc());
        env.assertEntityInRange(teleportee);
        if (teleportee.getType().is(HexTags.Entities.CANNOT_TELEPORT)) {
            throw new MishapImmuneEntity(teleportee);
        }
        if (teleportee.getType().is(HexTags.Entities.STICKY_TELEPORTERS)) {
            void $this$filterTo$iv$iv;
            List list = teleportee.getPassengers();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"teleportee.passengers");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Entity it = (Entity)element$iv$iv;
                boolean bl = false;
                if (!it.getType().is(HexTags.Entities.CANNOT_TELEPORT)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List immunePassengers = (List)destination$iv$iv;
            if (!immunePassengers.isEmpty()) {
                Object e = immunePassengers.get(0);
                Intrinsics.checkNotNullExpressionValue(e, (String)"immunePassengers.get(0)");
                throw new MishapImmuneEntity((Entity)e);
            }
        }
        Vec3 targetPos = teleportee.position().add(delta);
        if (!HexConfig.server().canTeleportInThisDimension((ResourceKey<Level>)env.getWorld().dimension())) {
            Intrinsics.checkNotNullExpressionValue((Object)targetPos, (String)"targetPos");
            throw new MishapBadLocation(targetPos, "bad_dimension");
        }
        env.assertVecInWorld(targetPos);
        if (!env.isVecInWorld(targetPos.subtract(0.0, 1.0, 0.0))) {
            Intrinsics.checkNotNullExpressionValue((Object)targetPos, (String)"targetPos");
            throw new MishapBadLocation(targetPos, "too_close_to_out");
        }
        Vec3 targetMiddlePos = teleportee.position().add(0.0, (double)teleportee.getEyeHeight() / 2.0, 0.0);
        RenderedSpell renderedSpell = new Spell(teleportee, delta);
        Object[] objectArray = new ParticleSpray[2];
        Intrinsics.checkNotNullExpressionValue((Object)targetMiddlePos, (String)"targetMiddlePos");
        objectArray[0] = ParticleSpray.Companion.cloud$default(ParticleSpray.Companion, targetMiddlePos, 2.0, 0, 4, null);
        Vec3 vec3 = targetMiddlePos.add(delta);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"targetMiddlePos.add(delta)");
        objectArray[1] = ParticleSpray.Companion.burst$default(ParticleSpray.Companion, vec3, 2.0, 0, 4, null);
        return new SpellAction.Result(renderedSpell, 1000000L, CollectionsKt.listOf((Object[])objectArray), 0L, 8, null);
    }

    public final void teleportRespectSticky(@NotNull Entity teleportee, @NotNull Vec3 delta, @NotNull ServerLevel world) {
        Intrinsics.checkNotNullParameter((Object)teleportee, (String)"teleportee");
        Intrinsics.checkNotNullParameter((Object)delta, (String)"delta");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        if (!HexConfig.server().canTeleportInThisDimension((ResourceKey<Level>)world.dimension())) {
            return;
        }
        Vec3 target = teleportee.position().add(delta);
        teleportee.stopRiding();
        if (!teleportee.getType().is(HexTags.Entities.STICKY_TELEPORTERS)) {
            List list = teleportee.getPassengers();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"teleportee.passengers");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entity p0 = (Entity)element$iv;
                boolean bl = false;
                p0.stopRiding();
            }
        }
        teleportee.teleportTo(target.x, target.y, target.z);
    }

    @Override
    public boolean hasCastingSound(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public boolean awardsCastingStat(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    @NotNull
    public SpellAction.Result executeWithUserdata(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env, @NotNull CompoundTag userData) throws Mishap {
        return SpellAction.DefaultImpls.executeWithUserdata(this, args, env, userData);
    }

    @Override
    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return SpellAction.DefaultImpls.operate(this, env, image, continuation);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/great/OpTeleport$Spell;", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "teleportee", "Lnet/minecraft/world/entity/Entity;", "delta", "Lnet/minecraft/world/phys/Vec3;", "(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;)V", "getDelta", "()Lnet/minecraft/world/phys/Vec3;", "getTeleportee", "()Lnet/minecraft/world/entity/Entity;", "cast", "", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "hexcasting-common-1.20.1"})
    private static final class Spell
    implements RenderedSpell {
        @NotNull
        private final Entity teleportee;
        @NotNull
        private final Vec3 delta;

        public Spell(@NotNull Entity teleportee, @NotNull Vec3 delta) {
            Intrinsics.checkNotNullParameter((Object)teleportee, (String)"teleportee");
            Intrinsics.checkNotNullParameter((Object)delta, (String)"delta");
            this.teleportee = teleportee;
            this.delta = delta;
        }

        @NotNull
        public final Entity getTeleportee() {
            return this.teleportee;
        }

        @NotNull
        public final Vec3 getDelta() {
            return this.delta;
        }

        @Override
        public void cast(@NotNull CastingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            double distance = this.delta.length();
            ServerLevel serverLevel = env.getWorld();
            Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"env.world");
            INSTANCE.teleportRespectSticky(this.teleportee, this.delta, serverLevel);
            if (HexConfig.server().doesGreaterTeleportSplatItems() && this.teleportee instanceof ServerPlayer && Intrinsics.areEqual((Object)this.teleportee, (Object)env.getCastingEntity())) {
                double baseDropChance = distance / 10000.0;
                for (ItemStack armorItem : ((ServerPlayer)this.teleportee).getInventory().armor) {
                    if (EnchantmentHelper.hasBindingCurse((ItemStack)armorItem) || !(Math.random() < baseDropChance * 0.25)) continue;
                    ((ServerPlayer)this.teleportee).drop(armorItem.copy(), true, false);
                    armorItem.shrink(armorItem.getCount());
                }
                Iterator iterator = ((ServerPlayer)this.teleportee).getInventory().items.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    double dropChance;
                    int pos = n++;
                    ItemStack invItem = (ItemStack)iterator.next();
                    if (Intrinsics.areEqual((Object)invItem, (Object)((ServerPlayer)this.teleportee).getMainHandItem())) continue;
                    double d = dropChance = pos < 9 ? baseDropChance * 0.5 : baseDropChance;
                    if (!(Math.random() < dropChance)) continue;
                    ((ServerPlayer)this.teleportee).drop(invItem.copy(), true, false);
                    invItem.shrink(invItem.getCount());
                }
            }
        }

        @Override
        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast(this, env, image);
        }

        @NotNull
        public final Entity component1() {
            return this.teleportee;
        }

        @NotNull
        public final Vec3 component2() {
            return this.delta;
        }

        @NotNull
        public final Spell copy(@NotNull Entity teleportee, @NotNull Vec3 delta) {
            Intrinsics.checkNotNullParameter((Object)teleportee, (String)"teleportee");
            Intrinsics.checkNotNullParameter((Object)delta, (String)"delta");
            return new Spell(teleportee, delta);
        }

        public static /* synthetic */ Spell copy$default(Spell spell, Entity entity, Vec3 vec3, int n, Object object) {
            if ((n & 1) != 0) {
                entity = spell.teleportee;
            }
            if ((n & 2) != 0) {
                vec3 = spell.delta;
            }
            return spell.copy(entity, vec3);
        }

        @NotNull
        public String toString() {
            return "Spell(teleportee=" + this.teleportee + ", delta=" + this.delta + ")";
        }

        public int hashCode() {
            int result = this.teleportee.hashCode();
            result = result * 31 + this.delta.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spell)) {
                return false;
            }
            Spell spell = (Spell)other;
            if (!Intrinsics.areEqual((Object)this.teleportee, (Object)spell.teleportee)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.delta, (Object)spell.delta);
        }
    }
}

