/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.actions.spells;

import at.petrak.hexcasting.api.addldata.ADHexHolder;
import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadItem;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadOffhandItem;
import at.petrak.hexcasting.api.casting.mishaps.MishapOthersName;
import at.petrak.hexcasting.api.utils.MediaHelper;
import at.petrak.hexcasting.common.items.magic.ItemPackagedHex;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B)\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0016\u00a8\u0006\u001f"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpMakePackagedSpell;", "Lat/petrak/hexcasting/api/casting/castables/SpellAction;", "itemType", "Lat/petrak/hexcasting/common/items/magic/ItemPackagedHex;", "cost", "", "(Lat/petrak/hexcasting/common/items/magic/ItemPackagedHex;J)V", "isValid", "Ljava/util/function/Predicate;", "Lnet/minecraft/world/item/ItemStack;", "expectedTypeDesc", "Ljava/util/function/Supplier;", "Lnet/minecraft/network/chat/Component;", "(Ljava/util/function/Predicate;Ljava/util/function/Supplier;J)V", "argc", "", "getArgc", "()I", "getCost", "()J", "getExpectedTypeDesc", "()Ljava/util/function/Supplier;", "()Ljava/util/function/Predicate;", "execute", "Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "args", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "Spell", "hexcasting-common-1.20.1"})
public final class OpMakePackagedSpell
implements SpellAction {
    @NotNull
    private final Predicate<ItemStack> isValid;
    @NotNull
    private final Supplier<Component> expectedTypeDesc;
    private final long cost;
    private final int argc;

    public OpMakePackagedSpell(@NotNull Predicate<ItemStack> isValid, @NotNull Supplier<Component> expectedTypeDesc, long cost) {
        Intrinsics.checkNotNullParameter(isValid, (String)"isValid");
        Intrinsics.checkNotNullParameter(expectedTypeDesc, (String)"expectedTypeDesc");
        this.isValid = isValid;
        this.expectedTypeDesc = expectedTypeDesc;
        this.cost = cost;
        this.argc = 2;
    }

    @NotNull
    public final Predicate<ItemStack> isValid() {
        return this.isValid;
    }

    @NotNull
    public final Supplier<Component> getExpectedTypeDesc() {
        return this.expectedTypeDesc;
    }

    public final long getCost() {
        return this.cost;
    }

    public OpMakePackagedSpell(@NotNull ItemPackagedHex itemType, long cost) {
        Intrinsics.checkNotNullParameter((Object)itemType, (String)"itemType");
        this(arg_0 -> OpMakePackagedSpell._init_$lambda$0(itemType, arg_0), () -> ((ItemPackagedHex)itemType).getDescription(), cost);
    }

    @Override
    public int getArgc() {
        return this.argc;
    }

    @Override
    @NotNull
    public SpellAction.Result execute(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        ItemStack handStack;
        List patterns;
        ItemEntity entity;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter(args, (String)"args");
                Intrinsics.checkNotNullParameter((Object)env, (String)"env");
                entity = OperatorUtils.getItemEntity(args, 0, this.getArgc());
                patterns = CollectionsKt.toList((Iterable)OperatorUtils.getList(args, 1, this.getArgc()));
                CastingEnvironment.HeldItemInfo heldItemInfo = env.getHeldItemToOperateOn(arg_0 -> OpMakePackagedSpell.execute$lambda$1(this, arg_0));
                if (heldItemInfo == null) {
                    ItemStack itemStack = ItemStack.EMPTY.copy();
                    Component component = this.expectedTypeDesc.get();
                    Intrinsics.checkNotNullExpressionValue((Object)component, (String)"expectedTypeDesc.get()");
                    throw new MishapBadOffhandItem(itemStack, component);
                }
                handStack = heldItemInfo.component1();
                ADHexHolder hexHolder = IXplatAbstractions.INSTANCE.findHexHolder(handStack);
                if (!this.isValid.test(handStack)) {
                    Component component = this.expectedTypeDesc.get();
                    Intrinsics.checkNotNullExpressionValue((Object)component, (String)"expectedTypeDesc.get()");
                    throw new MishapBadOffhandItem(handStack, component);
                }
                if (hexHolder == null || hexHolder.hasHex()) {
                    throw MishapBadOffhandItem.Companion.of(handStack, "iota.write", new Object[0]);
                }
                env.assertEntityInRange((Entity)entity);
                ItemStack itemStack = entity.getItem();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"entity.item");
                if (!MediaHelper.isMediaItem(itemStack)) break block7;
                ItemStack itemStack2 = entity.getItem();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"entity.item");
                if (MediaHelper.extractMedia$default(itemStack2, 0L, true, true, 2, null) > 0L) break block8;
            }
            throw MishapBadItem.Companion.of(entity, "media_for_battery");
        }
        LivingEntity livingEntity = env.getCastingEntity();
        Player trueName = MishapOthersName.Companion.getTrueNameFromArgs(patterns, (Player)(livingEntity instanceof ServerPlayer ? (ServerPlayer)livingEntity : null));
        if (trueName != null) {
            throw new MishapOthersName(trueName);
        }
        Intrinsics.checkNotNullExpressionValue((Object)handStack, (String)"handStack");
        RenderedSpell renderedSpell = new Spell(entity, patterns, handStack);
        Vec3 vec3 = entity.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"entity.position()");
        return new SpellAction.Result(renderedSpell, this.cost, CollectionsKt.listOf((Object)ParticleSpray.Companion.burst$default(ParticleSpray.Companion, vec3, 0.5, 0, 4, null)), 0L, 8, null);
    }

    @Override
    public boolean hasCastingSound(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public boolean awardsCastingStat(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    @NotNull
    public SpellAction.Result executeWithUserdata(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env, @NotNull CompoundTag userData) throws Mishap {
        return SpellAction.DefaultImpls.executeWithUserdata(this, args, env, userData);
    }

    @Override
    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return SpellAction.DefaultImpls.operate(this, env, image, continuation);
    }

    private static final boolean _init_$lambda$0(ItemPackagedHex $itemType, ItemStack s) {
        Intrinsics.checkNotNullParameter((Object)$itemType, (String)"$itemType");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return s.is((Item)$itemType);
    }

    private static final boolean execute$lambda$1(OpMakePackagedSpell this$0, ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ADHexHolder hexHolder = IXplatAbstractions.INSTANCE.findHexHolder(it);
        return this$0.isValid.test(it) && hexHolder != null && !hexHolder.hasHex();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpMakePackagedSpell$Spell;", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "itemEntity", "Lnet/minecraft/world/entity/item/ItemEntity;", "patterns", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "stack", "Lnet/minecraft/world/item/ItemStack;", "(Lat/petrak/hexcasting/common/casting/actions/spells/OpMakePackagedSpell;Lnet/minecraft/world/entity/item/ItemEntity;Ljava/util/List;Lnet/minecraft/world/item/ItemStack;)V", "getItemEntity", "()Lnet/minecraft/world/entity/item/ItemEntity;", "getPatterns", "()Ljava/util/List;", "getStack", "()Lnet/minecraft/world/item/ItemStack;", "cast", "", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "hexcasting-common-1.20.1"})
    private final class Spell
    implements RenderedSpell {
        @NotNull
        private final ItemEntity itemEntity;
        @NotNull
        private final List<Iota> patterns;
        @NotNull
        private final ItemStack stack;

        public Spell(@NotNull ItemEntity itemEntity, @NotNull List<? extends Iota> patterns, ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)itemEntity, (String)"itemEntity");
            Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            this.itemEntity = itemEntity;
            this.patterns = patterns;
            this.stack = stack;
        }

        @NotNull
        public final ItemEntity getItemEntity() {
            return this.itemEntity;
        }

        @NotNull
        public final List<Iota> getPatterns() {
            return this.patterns;
        }

        @NotNull
        public final ItemStack getStack() {
            return this.stack;
        }

        @Override
        public void cast(@NotNull CastingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            ADHexHolder hexHolder = IXplatAbstractions.INSTANCE.findHexHolder(this.stack);
            if (hexHolder != null && !hexHolder.hasHex() && this.itemEntity.isAlive()) {
                ItemStack entityStack = this.itemEntity.getItem().copy();
                Intrinsics.checkNotNullExpressionValue((Object)entityStack, (String)"entityStack");
                long mediamount = MediaHelper.extractMedia$default(entityStack, 0L, true, false, 10, null);
                if (mediamount > 0L) {
                    hexHolder.writeHex(this.patterns, env.getPigment(), mediamount);
                }
                this.itemEntity.setItem(entityStack);
                if (entityStack.isEmpty()) {
                    this.itemEntity.kill();
                }
            }
        }

        @Override
        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast(this, env, image);
        }
    }
}

