/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.actions.spells;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.EntityIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.Vec3Iota;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.api.casting.mishaps.MishapInvalidIota;
import at.petrak.hexcasting.ktxt.AccessorWrappers;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpIgnite;", "Lat/petrak/hexcasting/api/casting/castables/SpellAction;", "()V", "argc", "", "getArgc", "()I", "execute", "Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "args", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "BlockSpell", "EntitySpell", "hexcasting-common-1.20.1"})
public final class OpIgnite
implements SpellAction {
    @NotNull
    public static final OpIgnite INSTANCE = new OpIgnite();
    private static final int argc = 1;

    private OpIgnite() {
    }

    @Override
    public int getArgc() {
        return argc;
    }

    @Override
    @NotNull
    public SpellAction.Result execute(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Iota target = args.get(0);
        if (target instanceof EntityIota) {
            Entity entity = OperatorUtils.getEntity(args, 0, this.getArgc());
            env.assertEntityInRange(entity);
            RenderedSpell renderedSpell = new EntitySpell(entity);
            Vec3 vec3 = entity.position();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"entity.position()");
            return new SpellAction.Result(renderedSpell, 10000L, CollectionsKt.listOf((Object)ParticleSpray.Companion.burst$default(ParticleSpray.Companion, vec3, 1.0, 0, 4, null)), 0L, 8, null);
        }
        if (target instanceof Vec3Iota) {
            BlockPos block = OperatorUtils.getBlockPos(args, 0, this.getArgc());
            env.assertPosInRangeForEditing(block);
            RenderedSpell renderedSpell = new BlockSpell(block);
            Vec3 vec3 = Vec3.atCenterOf((Vec3i)((Vec3i)new BlockPos((Vec3i)block)));
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"atCenterOf(BlockPos(block))");
            return new SpellAction.Result(renderedSpell, 10000L, CollectionsKt.listOf((Object)ParticleSpray.Companion.burst$default(ParticleSpray.Companion, vec3, 1.0, 0, 4, null)), 0L, 8, null);
        }
        throw MishapInvalidIota.Companion.ofType(target, 0, "entity_or_vector");
    }

    @Override
    public boolean hasCastingSound(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public boolean awardsCastingStat(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    @NotNull
    public SpellAction.Result executeWithUserdata(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env, @NotNull CompoundTag userData) throws Mishap {
        return SpellAction.DefaultImpls.executeWithUserdata(this, args, env, userData);
    }

    @Override
    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return SpellAction.DefaultImpls.operate(this, env, image, continuation);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\u001e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpIgnite$BlockSpell;", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "pos", "Lnet/minecraft/core/BlockPos;", "(Lnet/minecraft/core/BlockPos;)V", "getPos", "()Lnet/minecraft/core/BlockPos;", "cast", "", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "tryToClick", "ctx", "item", "Lnet/minecraft/world/item/Item;", "hexcasting-common-1.20.1"})
    private static final class BlockSpell
    implements RenderedSpell {
        @NotNull
        private final BlockPos pos;

        public BlockSpell(@NotNull BlockPos pos) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            this.pos = pos;
        }

        @NotNull
        public final BlockPos getPos() {
            return this.pos;
        }

        @Override
        public void cast(@NotNull CastingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            Item item = Items.FIRE_CHARGE;
            Intrinsics.checkNotNullExpressionValue((Object)item, (String)"FIRE_CHARGE");
            if (!this.tryToClick(env, this.pos, item)) {
                Item item2 = Items.FLINT_AND_STEEL;
                Intrinsics.checkNotNullExpressionValue((Object)item2, (String)"FLINT_AND_STEEL");
                this.tryToClick(env, this.pos, item2);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean tryToClick(@NotNull CastingEnvironment ctx, @NotNull BlockPos pos, @NotNull Item item) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            LivingEntity livingEntity = ctx.getCastingEntity();
            if (!IXplatAbstractions.INSTANCE.isPlacingAllowed(ctx.getWorld(), pos, new ItemStack((ItemLike)item), (Player)(livingEntity instanceof ServerPlayer ? (ServerPlayer)livingEntity : null))) return false;
            ServerLevel serverLevel = ctx.getWorld();
            Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"ctx.world");
            if (!item.useOn(AccessorWrappers.UseOnContext((Level)serverLevel, null, InteractionHand.MAIN_HAND, new ItemStack((ItemLike)item), new BlockHitResult(Vec3.atCenterOf((Vec3i)((Vec3i)pos)), Direction.UP, pos, false))).consumesAction()) return false;
            return true;
        }

        @Override
        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast(this, env, image);
        }

        @NotNull
        public final BlockPos component1() {
            return this.pos;
        }

        @NotNull
        public final BlockSpell copy(@NotNull BlockPos pos) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            return new BlockSpell(pos);
        }

        public static /* synthetic */ BlockSpell copy$default(BlockSpell blockSpell, BlockPos blockPos, int n, Object object) {
            if ((n & 1) != 0) {
                blockPos = blockSpell.pos;
            }
            return blockSpell.copy(blockPos);
        }

        @NotNull
        public String toString() {
            return "BlockSpell(pos=" + this.pos + ")";
        }

        public int hashCode() {
            return this.pos.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BlockSpell)) {
                return false;
            }
            BlockSpell blockSpell = (BlockSpell)other;
            return Intrinsics.areEqual((Object)this.pos, (Object)blockSpell.pos);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpIgnite$EntitySpell;", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "entity", "Lnet/minecraft/world/entity/Entity;", "(Lnet/minecraft/world/entity/Entity;)V", "getEntity", "()Lnet/minecraft/world/entity/Entity;", "cast", "", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "hexcasting-common-1.20.1"})
    private static final class EntitySpell
    implements RenderedSpell {
        @NotNull
        private final Entity entity;

        public EntitySpell(@NotNull Entity entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            this.entity = entity;
        }

        @NotNull
        public final Entity getEntity() {
            return this.entity;
        }

        @Override
        public void cast(@NotNull CastingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            this.entity.setSecondsOnFire(8);
        }

        @Override
        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast(this, env, image);
        }

        @NotNull
        public final Entity component1() {
            return this.entity;
        }

        @NotNull
        public final EntitySpell copy(@NotNull Entity entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            return new EntitySpell(entity);
        }

        public static /* synthetic */ EntitySpell copy$default(EntitySpell entitySpell, Entity entity, int n, Object object) {
            if ((n & 1) != 0) {
                entity = entitySpell.entity;
            }
            return entitySpell.copy(entity);
        }

        @NotNull
        public String toString() {
            return "EntitySpell(entity=" + this.entity + ")";
        }

        public int hashCode() {
            return this.entity.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EntitySpell)) {
                return false;
            }
            EntitySpell entitySpell = (EntitySpell)other;
            return Intrinsics.areEqual((Object)this.entity, (Object)entitySpell.entity);
        }
    }
}

