/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.actions.spells;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.common.casting.actions.selectors.OpGetEntitiesBy;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpExplode;", "Lat/petrak/hexcasting/api/casting/castables/SpellAction;", "fire", "", "(Z)V", "argc", "", "getArgc", "()I", "getFire", "()Z", "execute", "Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "args", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "Spell", "hexcasting-common-1.20.1"})
public final class OpExplode
implements SpellAction {
    private final boolean fire;

    public OpExplode(boolean fire) {
        this.fire = fire;
    }

    public final boolean getFire() {
        return this.fire;
    }

    @Override
    public int getArgc() {
        return 2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SpellAction.Result execute(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        boolean tooCloseToEyePos2;
        double strength;
        Vec3 pos;
        block4: {
            void $this$any$iv;
            Intrinsics.checkNotNullParameter(args, (String)"args");
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            pos = null;
            pos = OperatorUtils.getVec3(args, 0, this.getArgc());
            strength = OperatorUtils.getPositiveDoubleUnderInclusive(args, 1, 10.0, this.getArgc());
            env.assertVecInRange(pos);
            double eps = 0.01;
            Vec3 epsv = new Vec3(eps, eps, eps);
            AABB aabb = new AABB(pos.subtract(epsv), pos.add(epsv));
            List list = env.getWorld().getEntities(null, aabb, arg_0 -> OpExplode.execute$lambda$0((Function1)new Function1<Entity, Boolean>(env){
                final /* synthetic */ CastingEnvironment $env;
                {
                    this.$env = $env;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(Entity it) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    return OpGetEntitiesBy.Companion.isReasonablySelectable(this.$env, it);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"env: CastingEnvironment\n\u2026ctable(env, it)\n        }");
            Iterable iterable = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v1 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Entity it = (Entity)element$iv;
                    boolean bl = false;
                    if (!(it.getEyePosition().distanceToSqr(pos) == 0.0)) continue;
                    v1 = true;
                    break block4;
                }
                v1 = tooCloseToEyePos2 = false;
            }
        }
        if (tooCloseToEyePos2) {
            Vec3 vec3 = pos.add(0.0, 1.0E-6, 0.0);
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"pos.add(0.0, 0.000001, 0.0)");
            pos = vec3;
        }
        double clampedStrength = Mth.clamp((double)strength, (double)0.0, (double)10.0);
        double cost = (double)10000L * ((double)3 * clampedStrength + (this.fire ? 1.0 : 0.125));
        return new SpellAction.Result(new Spell(pos, strength, this.fire), (long)cost, CollectionsKt.listOf((Object)ParticleSpray.Companion.burst(pos, strength, 50)), 0L, 8, null);
    }

    @Override
    public boolean hasCastingSound(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public boolean awardsCastingStat(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    @NotNull
    public SpellAction.Result executeWithUserdata(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env, @NotNull CompoundTag userData) throws Mishap {
        return SpellAction.DefaultImpls.executeWithUserdata(this, args, env, userData);
    }

    @Override
    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return SpellAction.DefaultImpls.operate(this, env, image, continuation);
    }

    private static final boolean execute$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpExplode$Spell;", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "pos", "Lnet/minecraft/world/phys/Vec3;", "strength", "", "fire", "", "(Lnet/minecraft/world/phys/Vec3;DZ)V", "getFire", "()Z", "getPos", "()Lnet/minecraft/world/phys/Vec3;", "getStrength", "()D", "cast", "", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "", "hexcasting-common-1.20.1"})
    private static final class Spell
    implements RenderedSpell {
        @NotNull
        private final Vec3 pos;
        private final double strength;
        private final boolean fire;

        public Spell(@NotNull Vec3 pos, double strength, boolean fire) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            this.pos = pos;
            this.strength = strength;
            this.fire = fire;
        }

        @NotNull
        public final Vec3 getPos() {
            return this.pos;
        }

        public final double getStrength() {
            return this.strength;
        }

        public final boolean getFire() {
            return this.fire;
        }

        @Override
        public void cast(@NotNull CastingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            if (!env.canEditBlockAt(BlockPos.containing((Position)((Position)this.pos)))) {
                return;
            }
            env.getWorld().explode((Entity)env.getCastingEntity(), this.pos.x, this.pos.y, this.pos.z, (float)this.strength, this.fire, Level.ExplosionInteraction.TNT);
        }

        @Override
        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast(this, env, image);
        }

        @NotNull
        public final Vec3 component1() {
            return this.pos;
        }

        public final double component2() {
            return this.strength;
        }

        public final boolean component3() {
            return this.fire;
        }

        @NotNull
        public final Spell copy(@NotNull Vec3 pos, double strength, boolean fire) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            return new Spell(pos, strength, fire);
        }

        public static /* synthetic */ Spell copy$default(Spell spell, Vec3 vec3, double d, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                vec3 = spell.pos;
            }
            if ((n & 2) != 0) {
                d = spell.strength;
            }
            if ((n & 4) != 0) {
                bl = spell.fire;
            }
            return spell.copy(vec3, d, bl);
        }

        @NotNull
        public String toString() {
            return "Spell(pos=" + this.pos + ", strength=" + this.strength + ", fire=" + this.fire + ")";
        }

        public int hashCode() {
            int result = this.pos.hashCode();
            result = result * 31 + Double.hashCode(this.strength);
            int n = this.fire ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spell)) {
                return false;
            }
            Spell spell = (Spell)other;
            if (!Intrinsics.areEqual((Object)this.pos, (Object)spell.pos)) {
                return false;
            }
            if (Double.compare(this.strength, spell.strength) != 0) {
                return false;
            }
            return this.fire == spell.fire;
        }
    }
}

