/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.actions.spells;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadLocation;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001f"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpCreateFluid;", "Lat/petrak/hexcasting/api/casting/castables/SpellAction;", "cost", "", "bucket", "Lnet/minecraft/world/item/Item;", "cauldron", "Lnet/minecraft/world/level/block/state/BlockState;", "fluid", "Lnet/minecraft/world/level/material/Fluid;", "(JLnet/minecraft/world/item/Item;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/material/Fluid;)V", "argc", "", "getArgc", "()I", "getBucket", "()Lnet/minecraft/world/item/Item;", "getCauldron", "()Lnet/minecraft/world/level/block/state/BlockState;", "getCost", "()J", "getFluid", "()Lnet/minecraft/world/level/material/Fluid;", "execute", "Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "args", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "Spell", "hexcasting-common-1.20.1"})
public final class OpCreateFluid
implements SpellAction {
    private final long cost;
    @NotNull
    private final Item bucket;
    @NotNull
    private final BlockState cauldron;
    @NotNull
    private final Fluid fluid;
    private final int argc;

    public OpCreateFluid(long cost, @NotNull Item bucket, @NotNull BlockState cauldron, @NotNull Fluid fluid) {
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        Intrinsics.checkNotNullParameter((Object)cauldron, (String)"cauldron");
        Intrinsics.checkNotNullParameter((Object)fluid, (String)"fluid");
        this.cost = cost;
        this.bucket = bucket;
        this.cauldron = cauldron;
        this.fluid = fluid;
        this.argc = 1;
    }

    public final long getCost() {
        return this.cost;
    }

    @NotNull
    public final Item getBucket() {
        return this.bucket;
    }

    @NotNull
    public final BlockState getCauldron() {
        return this.cauldron;
    }

    @NotNull
    public final Fluid getFluid() {
        return this.fluid;
    }

    @Override
    public int getArgc() {
        return this.argc;
    }

    @Override
    @NotNull
    public SpellAction.Result execute(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        LivingEntity livingEntity;
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Vec3 vecPos = OperatorUtils.getVec3(args, 0, this.getArgc());
        BlockPos pos = BlockPos.containing((Position)((Position)vecPos));
        if (!env.canEditBlockAt(pos) || !IXplatAbstractions.INSTANCE.isPlacingAllowed(env.getWorld(), pos, new ItemStack((ItemLike)this.bucket), (Player)((livingEntity = env.getCastingEntity()) instanceof ServerPlayer ? (ServerPlayer)livingEntity : null))) {
            throw new MishapBadLocation(vecPos, "forbidden");
        }
        Intrinsics.checkNotNullExpressionValue((Object)pos, (String)"pos");
        RenderedSpell renderedSpell = new Spell(pos, this.bucket, this.cauldron, this.fluid);
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)((Vec3i)new BlockPos((Vec3i)pos)));
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"atCenterOf(BlockPos(pos))");
        return new SpellAction.Result(renderedSpell, this.cost, CollectionsKt.listOf((Object)ParticleSpray.Companion.burst$default(ParticleSpray.Companion, vec3, 1.0, 0, 4, null)), 0L, 8, null);
    }

    @Override
    public boolean hasCastingSound(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public boolean awardsCastingStat(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    @NotNull
    public SpellAction.Result executeWithUserdata(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env, @NotNull CompoundTag userData) throws Mishap {
        return SpellAction.DefaultImpls.executeWithUserdata(this, args, env, userData);
    }

    @Override
    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return SpellAction.DefaultImpls.operate(this, env, image, continuation);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\tH\u00c6\u0003J1\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpCreateFluid$Spell;", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "pos", "Lnet/minecraft/core/BlockPos;", "bucket", "Lnet/minecraft/world/item/Item;", "cauldron", "Lnet/minecraft/world/level/block/state/BlockState;", "fluid", "Lnet/minecraft/world/level/material/Fluid;", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/item/Item;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/material/Fluid;)V", "getBucket", "()Lnet/minecraft/world/item/Item;", "getCauldron", "()Lnet/minecraft/world/level/block/state/BlockState;", "getFluid", "()Lnet/minecraft/world/level/material/Fluid;", "getPos", "()Lnet/minecraft/core/BlockPos;", "cast", "", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "hexcasting-common-1.20.1"})
    private static final class Spell
    implements RenderedSpell {
        @NotNull
        private final BlockPos pos;
        @NotNull
        private final Item bucket;
        @NotNull
        private final BlockState cauldron;
        @NotNull
        private final Fluid fluid;

        public Spell(@NotNull BlockPos pos, @NotNull Item bucket, @NotNull BlockState cauldron, @NotNull Fluid fluid) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
            Intrinsics.checkNotNullParameter((Object)cauldron, (String)"cauldron");
            Intrinsics.checkNotNullParameter((Object)fluid, (String)"fluid");
            this.pos = pos;
            this.bucket = bucket;
            this.cauldron = cauldron;
            this.fluid = fluid;
        }

        @NotNull
        public final BlockPos getPos() {
            return this.pos;
        }

        @NotNull
        public final Item getBucket() {
            return this.bucket;
        }

        @NotNull
        public final BlockState getCauldron() {
            return this.cauldron;
        }

        @NotNull
        public final Fluid getFluid() {
            return this.fluid;
        }

        @Override
        public void cast(@NotNull CastingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            BlockState state = env.getWorld().getBlockState(this.pos);
            if (Intrinsics.areEqual((Object)state.getBlock(), (Object)Blocks.CAULDRON)) {
                env.getWorld().setBlock(this.pos, this.cauldron, 3);
            } else if (!IXplatAbstractions.INSTANCE.tryPlaceFluid((Level)env.getWorld(), env.getCastingHand(), this.pos, this.fluid) && this.bucket instanceof BucketItem) {
                ((BucketItem)this.bucket).emptyContents(null, (Level)env.getWorld(), this.pos, null);
            }
        }

        @Override
        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast(this, env, image);
        }

        @NotNull
        public final BlockPos component1() {
            return this.pos;
        }

        @NotNull
        public final Item component2() {
            return this.bucket;
        }

        @NotNull
        public final BlockState component3() {
            return this.cauldron;
        }

        @NotNull
        public final Fluid component4() {
            return this.fluid;
        }

        @NotNull
        public final Spell copy(@NotNull BlockPos pos, @NotNull Item bucket, @NotNull BlockState cauldron, @NotNull Fluid fluid) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
            Intrinsics.checkNotNullParameter((Object)cauldron, (String)"cauldron");
            Intrinsics.checkNotNullParameter((Object)fluid, (String)"fluid");
            return new Spell(pos, bucket, cauldron, fluid);
        }

        public static /* synthetic */ Spell copy$default(Spell spell, BlockPos blockPos, Item item, BlockState blockState, Fluid fluid, int n, Object object) {
            if ((n & 1) != 0) {
                blockPos = spell.pos;
            }
            if ((n & 2) != 0) {
                item = spell.bucket;
            }
            if ((n & 4) != 0) {
                blockState = spell.cauldron;
            }
            if ((n & 8) != 0) {
                fluid = spell.fluid;
            }
            return spell.copy(blockPos, item, blockState, fluid);
        }

        @NotNull
        public String toString() {
            return "Spell(pos=" + this.pos + ", bucket=" + this.bucket + ", cauldron=" + this.cauldron + ", fluid=" + this.fluid + ")";
        }

        public int hashCode() {
            int result = this.pos.hashCode();
            result = result * 31 + this.bucket.hashCode();
            result = result * 31 + this.cauldron.hashCode();
            result = result * 31 + this.fluid.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spell)) {
                return false;
            }
            Spell spell = (Spell)other;
            if (!Intrinsics.areEqual((Object)this.pos, (Object)spell.pos)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.bucket, (Object)spell.bucket)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.cauldron, (Object)spell.cauldron)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.fluid, (Object)spell.fluid);
        }
    }
}

