/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.blocks.circles.impetuses;

import at.petrak.hexcasting.api.addldata.ADIotaHolder;
import at.petrak.hexcasting.api.block.circle.BlockAbstractImpetus;
import at.petrak.hexcasting.api.casting.iota.EntityIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.common.blocks.circles.impetuses.BlockEntityRedstoneImpetus;
import at.petrak.hexcasting.common.lib.HexSounds;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class BlockRedstoneImpetus
extends BlockAbstractImpetus {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public BlockRedstoneImpetus(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new BlockEntityRedstoneImpetus(pPos, pState);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWERED});
    }

    public InteractionResult use(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ServerLevel level;
        BlockEntity blockEntity;
        if (pLevel instanceof ServerLevel && (blockEntity = (level = (ServerLevel)pLevel).getBlockEntity(pPos)) instanceof BlockEntityRedstoneImpetus) {
            EntityIota eieio;
            Entity entity;
            Iota stored;
            BlockEntityRedstoneImpetus tile = (BlockEntityRedstoneImpetus)blockEntity;
            ItemStack usedStack = pPlayer.getItemInHand(pHand);
            if (usedStack.isEmpty() && pPlayer.isDiscrete()) {
                tile.clearPlayer();
                tile.sync();
                pLevel.playSound(null, pPos, HexSounds.IMPETUS_REDSTONE_CLEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
            }
            ADIotaHolder datumContainer = IXplatAbstractions.INSTANCE.findDataHolder(usedStack);
            if (datumContainer != null && (stored = datumContainer.readIota(level)) instanceof EntityIota && (entity = (eieio = (EntityIota)stored).getEntity()) instanceof Player) {
                Player player = (Player)entity;
                tile.setPlayer(player.getGameProfile(), entity.getUUID());
                tile.sync();
                pLevel.playSound(null, pPos, HexSounds.IMPETUS_REDSTONE_DING, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.tick(pState, pLevel, pPos, pRandom);
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof BlockEntityRedstoneImpetus) {
            BlockEntityRedstoneImpetus tile = (BlockEntityRedstoneImpetus)blockEntity;
            tile.updatePlayerProfile();
        }
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        super.neighborChanged(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
        if (pLevel instanceof ServerLevel) {
            boolean isPowered;
            ServerLevel slevel = (ServerLevel)pLevel;
            boolean prevPowered = (Boolean)pState.getValue((Property)POWERED);
            if (prevPowered != (isPowered = pLevel.hasNeighborSignal(pPos))) {
                BlockEntity blockEntity;
                pLevel.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(isPowered)));
                if (isPowered && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof BlockEntityRedstoneImpetus) {
                    BlockEntityRedstoneImpetus tile = (BlockEntityRedstoneImpetus)blockEntity;
                    ServerPlayer player = tile.getStoredPlayer();
                    tile.startExecution(player);
                }
            }
        }
    }
}

